/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.Attr;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.DerSchemaTO;
import org.apache.syncope.common.lib.to.PlainSchemaTO;
import org.apache.syncope.common.lib.to.SchemaTO;
import org.apache.syncope.common.lib.to.VirSchemaTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.AttrSchemaType;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.common.lib.types.SchemaType;
import org.apache.syncope.core.logic.AbstractTransactionalLogic;
import org.apache.syncope.core.logic.UnresolvedReferenceException;
import org.apache.syncope.core.persistence.api.attrvalue.DropdownValueProvider;
import org.apache.syncope.core.persistence.api.dao.AnyTypeClassDAO;
import org.apache.syncope.core.persistence.api.dao.DerSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.DuplicateException;
import org.apache.syncope.core.persistence.api.dao.ImplementationDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.PlainSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.VirSchemaDAO;
import org.apache.syncope.core.persistence.api.entity.AnyTypeClass;
import org.apache.syncope.core.persistence.api.entity.DerSchema;
import org.apache.syncope.core.persistence.api.entity.Implementation;
import org.apache.syncope.core.persistence.api.entity.PlainSchema;
import org.apache.syncope.core.persistence.api.entity.Schema;
import org.apache.syncope.core.persistence.api.entity.VirSchema;
import org.apache.syncope.core.provisioning.api.data.SchemaDataBinder;
import org.apache.syncope.core.spring.implementation.ImplementationManager;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;

public class SchemaLogic
extends AbstractTransactionalLogic<SchemaTO> {
    protected final PlainSchemaDAO plainSchemaDAO;
    protected final DerSchemaDAO derSchemaDAO;
    protected final VirSchemaDAO virSchemaDAO;
    protected final AnyTypeClassDAO anyTypeClassDAO;
    protected final ImplementationDAO implementationDAO;
    protected final SchemaDataBinder binder;
    protected final Map<String, DropdownValueProvider> perContextDropdownValueProviders = new ConcurrentHashMap<String, DropdownValueProvider>();

    public SchemaLogic(PlainSchemaDAO plainSchemaDAO, DerSchemaDAO derSchemaDAO, VirSchemaDAO virSchemaDAO, AnyTypeClassDAO anyTypeClassDAO, ImplementationDAO implementationDAO, SchemaDataBinder binder) {
        this.plainSchemaDAO = plainSchemaDAO;
        this.derSchemaDAO = derSchemaDAO;
        this.virSchemaDAO = virSchemaDAO;
        this.anyTypeClassDAO = anyTypeClassDAO;
        this.implementationDAO = implementationDAO;
        this.binder = binder;
    }

    protected <S extends Schema> Optional<S> findById(SchemaType schemaType, String name) {
        Optional result = Optional.empty();
        switch (schemaType) {
            case VIRTUAL: {
                result = this.virSchemaDAO.findById(name);
                break;
            }
            case DERIVED: {
                result = this.derSchemaDAO.findById(name);
                break;
            }
            case PLAIN: {
                result = this.plainSchemaDAO.findById(name);
                break;
            }
        }
        return result;
    }

    @PreAuthorize(value="hasRole('SCHEMA_CREATE')")
    public <T extends SchemaTO> T create(SchemaType schemaType, T schemaTO) {
        if (StringUtils.isBlank((CharSequence)schemaTO.getKey())) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.RequiredValuesMissing);
            sce.getElements().add("Schema key");
            throw sce;
        }
        if (this.findById(schemaType, schemaTO.getKey()).isPresent()) {
            throw new DuplicateException(String.valueOf(schemaType) + "/" + schemaTO.getKey());
        }
        return (T)(switch (schemaType) {
            case SchemaType.VIRTUAL -> this.binder.getVirSchemaTO(this.binder.create((VirSchemaTO)schemaTO).getKey());
            case SchemaType.DERIVED -> this.binder.getDerSchemaTO(this.binder.create((DerSchemaTO)schemaTO).getKey());
            default -> this.binder.getPlainSchemaTO(this.binder.create((PlainSchemaTO)schemaTO).getKey());
        });
    }

    @PreAuthorize(value="hasRole('SCHEMA_DELETE')")
    public void delete(SchemaType schemaType, String schemaKey) {
        this.findById(schemaType, schemaKey).orElseThrow(() -> new NotFoundException(String.valueOf(schemaType) + ": " + schemaKey));
        switch (schemaType) {
            case VIRTUAL: {
                this.virSchemaDAO.deleteById(schemaKey);
                break;
            }
            case DERIVED: {
                this.derSchemaDAO.deleteById(schemaKey);
                break;
            }
            default: {
                this.plainSchemaDAO.deleteById(schemaKey);
            }
        }
    }

    @PreAuthorize(value="isAuthenticated()")
    @Transactional(readOnly=true)
    public <T extends SchemaTO> List<T> search(SchemaType schemaType, List<String> anyTypeClasses, String keyword) {
        ArrayList classes = new ArrayList(anyTypeClasses.size());
        anyTypeClasses.remove(AnyTypeKind.USER.name());
        anyTypeClasses.remove(AnyTypeKind.GROUP.name());
        anyTypeClasses.forEach(anyTypeClass -> this.anyTypeClassDAO.findById(anyTypeClass).ifPresentOrElse(classes::add, () -> LOG.warn("Ignoring invalid {}: {}", (Object)AnyTypeClass.class.getSimpleName(), anyTypeClass)));
        return switch (schemaType) {
            case SchemaType.VIRTUAL -> {
                List virSchemas = classes.isEmpty() ? (keyword == null ? this.virSchemaDAO.findAll() : this.virSchemaDAO.findByIdLike(keyword)) : this.virSchemaDAO.findByAnyTypeClasses(classes);
                yield virSchemas.stream().map(schema -> this.binder.getVirSchemaTO(schema.getKey())).toList();
            }
            case SchemaType.DERIVED -> {
                List derSchemas = classes.isEmpty() ? (keyword == null ? this.derSchemaDAO.findAll() : this.derSchemaDAO.findByIdLike(keyword)) : this.derSchemaDAO.findByAnyTypeClasses(classes);
                yield derSchemas.stream().map(schema -> this.binder.getDerSchemaTO(schema.getKey())).toList();
            }
            default -> {
                List plainSchemas = classes.isEmpty() ? (keyword == null ? this.plainSchemaDAO.findAll() : this.plainSchemaDAO.findByIdLike(keyword)) : this.plainSchemaDAO.findByAnyTypeClasses(classes);
                yield plainSchemas.stream().map(schema -> this.binder.getPlainSchemaTO(schema.getKey())).toList();
            }
        };
    }

    @PreAuthorize(value="isAuthenticated()")
    public <T extends SchemaTO> T read(SchemaType schemaType, String schemaKey) {
        return (T)(switch (schemaType) {
            case SchemaType.VIRTUAL -> this.binder.getVirSchemaTO(schemaKey);
            case SchemaType.DERIVED -> this.binder.getDerSchemaTO(schemaKey);
            default -> this.binder.getPlainSchemaTO(schemaKey);
        });
    }

    @PreAuthorize(value="hasRole('SCHEMA_UPDATE')")
    public <T extends SchemaTO> void update(SchemaType schemaType, T schemaTO) {
        Schema schema = (Schema)this.findById(schemaType, schemaTO.getKey()).orElseThrow(() -> new NotFoundException(String.valueOf(schemaType) + ": " + schemaTO.getKey()));
        switch (schemaType) {
            case VIRTUAL: {
                this.binder.update((VirSchemaTO)schemaTO, (VirSchema)schema);
                break;
            }
            case DERIVED: {
                this.binder.update((DerSchemaTO)schemaTO, (DerSchema)schema);
                break;
            }
            case PLAIN: {
                this.binder.update((PlainSchemaTO)schemaTO, (PlainSchema)schema);
                break;
            }
        }
    }

    @PreAuthorize(value="isAuthenticated()")
    public Attr getDropdownValues(String key, AnyTO anyTO) {
        PlainSchema schema = this.plainSchemaDAO.findById(key).filter(s -> s.getType() == AttrSchemaType.Dropdown).orElseThrow(() -> new NotFoundException(AttrSchemaType.Dropdown.name() + " PlainSchema " + key));
        try {
            DropdownValueProvider provider = (DropdownValueProvider)ImplementationManager.build((Implementation)schema.getDropdownValueProvider(), () -> this.perContextDropdownValueProviders.get(schema.getDropdownValueProvider().getKey()), instance -> this.perContextDropdownValueProviders.put(schema.getDropdownValueProvider().getKey(), (DropdownValueProvider)instance));
            return new Attr.Builder(schema.getKey()).values((Collection)provider.getChoices(anyTO)).build();
        }
        catch (Exception e) {
            LOG.error("While getting dropdown values for {}", (Object)key, (Object)e);
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidImplementation);
            sce.getElements().add(e.getMessage());
            throw sce;
        }
    }

    @Override
    protected SchemaTO resolveReference(Method method, Object ... args) throws UnresolvedReferenceException {
        String key = null;
        if (ArrayUtils.isNotEmpty((Object[])args)) {
            for (int i = 0; key == null && i < args.length; ++i) {
                Object object = args[i];
                if (object instanceof String) {
                    String string;
                    key = string = (String)object;
                    continue;
                }
                object = args[i];
                if (!(object instanceof SchemaTO)) continue;
                SchemaTO schemaTO = (SchemaTO)object;
                key = schemaTO.getKey();
            }
        }
        if (key != null) {
            try {
                PlainSchemaTO result = null;
                Optional schema = this.plainSchemaDAO.findById(key);
                if (schema.isEmpty()) {
                    schema = this.derSchemaDAO.findById(key);
                    if (schema.isEmpty()) {
                        schema = this.virSchemaDAO.findById(key);
                        if (schema.isPresent()) {
                            result = this.binder.getVirSchemaTO(key);
                        }
                    } else {
                        result = this.binder.getDerSchemaTO(key);
                    }
                } else {
                    result = this.binder.getPlainSchemaTO(key);
                }
                return result;
            }
            catch (Throwable ignore) {
                LOG.debug("Unresolved reference", ignore);
                throw new UnresolvedReferenceException(ignore);
            }
        }
        throw new UnresolvedReferenceException();
    }
}

