/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import java.lang.reflect.Method;
import java.util.List;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.syncope.common.lib.SyncopeConstants;
import org.apache.syncope.common.lib.to.DelegationTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.core.logic.AbstractTransactionalLogic;
import org.apache.syncope.core.logic.UnresolvedReferenceException;
import org.apache.syncope.core.persistence.api.dao.DelegationDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.entity.Delegation;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.provisioning.api.data.DelegationDataBinder;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.apache.syncope.core.spring.security.DelegatedAdministrationException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;

public class DelegationLogic
extends AbstractTransactionalLogic<DelegationTO> {
    protected final DelegationDataBinder binder;
    protected final DelegationDAO delegationDAO;
    protected final UserDAO userDAO;

    public DelegationLogic(DelegationDataBinder binder, DelegationDAO delegationDAO, UserDAO userDAO) {
        this.binder = binder;
        this.delegationDAO = delegationDAO;
        this.userDAO = userDAO;
    }

    protected void securityChecks(String delegating, String entitlement) {
        if (!(AuthContextUtils.getAuthorizations().keySet().contains(entitlement) || delegating != null && delegating.equals(this.userDAO.findKey(AuthContextUtils.getUsername()).orElseThrow(() -> new NotFoundException("Could not find authenticated user"))))) {
            throw new DelegatedAdministrationException("/", AnyTypeKind.USER.name(), delegating);
        }
    }

    @PreAuthorize(value="isAuthenticated()")
    @Transactional(readOnly=true)
    public DelegationTO read(String key) {
        Delegation delegation = (Delegation)this.delegationDAO.findById(key).orElseThrow(() -> new NotFoundException("Delegation " + key));
        this.securityChecks(delegation.getDelegating().getKey(), "DELEGATION_READ");
        return this.binder.getDelegationTO(delegation);
    }

    @PreAuthorize(value="isAuthenticated()")
    @Transactional(readOnly=true)
    public List<DelegationTO> list() {
        Stream<DelegationTO> delegations = this.delegationDAO.findAll().stream().map(arg_0 -> ((DelegationDataBinder)this.binder).getDelegationTO(arg_0));
        if (!AuthContextUtils.getAuthorizations().keySet().contains("DELEGATION_LIST")) {
            String authUserKey = this.userDAO.findKey(AuthContextUtils.getUsername()).orElse(null);
            delegations = delegations.filter(delegation -> delegation.getDelegating().equals(authUserKey));
        }
        return delegations.toList();
    }

    @PreAuthorize(value="isAuthenticated()")
    public DelegationTO create(DelegationTO delegationTO) {
        if (delegationTO.getDelegating() != null && !SyncopeConstants.UUID_PATTERN.matcher(delegationTO.getDelegating()).matches()) {
            delegationTO.setDelegating((String)this.userDAO.findKey(delegationTO.getDelegating()).orElse(null));
        }
        if (delegationTO.getDelegated() != null && !SyncopeConstants.UUID_PATTERN.matcher(delegationTO.getDelegated()).matches()) {
            delegationTO.setDelegated((String)this.userDAO.findKey(delegationTO.getDelegated()).orElse(null));
        }
        this.securityChecks(delegationTO.getDelegating(), "DELEGATION_CREATE");
        return this.binder.getDelegationTO((Delegation)this.delegationDAO.save((Entity)this.binder.create(delegationTO)));
    }

    @PreAuthorize(value="isAuthenticated()")
    public DelegationTO update(DelegationTO delegationTO) {
        Delegation delegation = (Delegation)this.delegationDAO.findById(delegationTO.getKey()).orElseThrow(() -> new NotFoundException("Delegation " + delegationTO.getKey()));
        this.securityChecks(delegation.getDelegating().getKey(), "DELEGATION_UPDATE");
        return this.binder.getDelegationTO((Delegation)this.delegationDAO.save((Entity)this.binder.update(delegation, delegationTO)));
    }

    @PreAuthorize(value="isAuthenticated()")
    public DelegationTO delete(String key) {
        Delegation delegation = (Delegation)this.delegationDAO.findById(key).orElseThrow(() -> new NotFoundException("Delegation " + key));
        this.securityChecks(delegation.getDelegating().getKey(), "DELEGATION_DELETE");
        DelegationTO deleted = this.binder.getDelegationTO(delegation);
        this.delegationDAO.deleteById(key);
        return deleted;
    }

    @Override
    protected DelegationTO resolveReference(Method method, Object ... args) throws UnresolvedReferenceException {
        String key = null;
        if (ArrayUtils.isNotEmpty((Object[])args)) {
            for (int i = 0; key == null && i < args.length; ++i) {
                Object object = args[i];
                if (object instanceof String) {
                    String string;
                    key = string = (String)object;
                    continue;
                }
                object = args[i];
                if (!(object instanceof DelegationTO)) continue;
                DelegationTO delegationTO = (DelegationTO)object;
                key = delegationTO.getKey();
            }
        }
        if (key != null) {
            try {
                return this.binder.getDelegationTO((Delegation)this.delegationDAO.findById(key).orElseThrow());
            }
            catch (Throwable ignore) {
                LOG.debug("Unresolved reference", ignore);
                throw new UnresolvedReferenceException(ignore);
            }
        }
        throw new UnresolvedReferenceException();
    }
}

