/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import java.lang.reflect.Method;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.syncope.common.lib.to.ApplicationTO;
import org.apache.syncope.common.lib.to.PrivilegeTO;
import org.apache.syncope.core.logic.AbstractTransactionalLogic;
import org.apache.syncope.core.logic.UnresolvedReferenceException;
import org.apache.syncope.core.persistence.api.dao.ApplicationDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.entity.Application;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.Privilege;
import org.apache.syncope.core.provisioning.api.data.ApplicationDataBinder;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;

public class ApplicationLogic
extends AbstractTransactionalLogic<ApplicationTO> {
    protected final ApplicationDataBinder binder;
    protected final ApplicationDAO applicationDAO;

    public ApplicationLogic(ApplicationDataBinder binder, ApplicationDAO applicationDAO) {
        this.binder = binder;
        this.applicationDAO = applicationDAO;
    }

    @PreAuthorize(value="hasRole('APPLICATION_READ')")
    @Transactional(readOnly=true)
    public ApplicationTO read(String key) {
        Application application = (Application)this.applicationDAO.findById(key).orElseThrow(() -> new NotFoundException("Application " + key));
        return this.binder.getApplicationTO(application);
    }

    @PreAuthorize(value="hasRole('APPLICATION_READ')")
    @Transactional(readOnly=true)
    public PrivilegeTO readPrivilege(String key) {
        Privilege privilege = (Privilege)this.applicationDAO.findPrivilege(key).orElseThrow(() -> new NotFoundException("Privilege " + key));
        return this.binder.getPrivilegeTO(privilege);
    }

    @PreAuthorize(value="hasRole('APPLICATION_LIST')")
    @Transactional(readOnly=true)
    public List<ApplicationTO> list() {
        return this.applicationDAO.findAll().stream().map(arg_0 -> ((ApplicationDataBinder)this.binder).getApplicationTO(arg_0)).toList();
    }

    @PreAuthorize(value="hasRole('APPLICATION_CREATE')")
    public ApplicationTO create(ApplicationTO applicationTO) {
        return this.binder.getApplicationTO((Application)this.applicationDAO.save((Entity)this.binder.create(applicationTO)));
    }

    @PreAuthorize(value="hasRole('APPLICATION_UPDATE')")
    public ApplicationTO update(ApplicationTO applicationTO) {
        Application application = (Application)this.applicationDAO.findById(applicationTO.getKey()).orElseThrow(() -> new NotFoundException("Application " + applicationTO.getKey()));
        return this.binder.getApplicationTO((Application)this.applicationDAO.save((Entity)this.binder.update(application, applicationTO)));
    }

    @PreAuthorize(value="hasRole('APPLICATION_DELETE')")
    public ApplicationTO delete(String key) {
        Application application = (Application)this.applicationDAO.findById(key).orElseThrow(() -> new NotFoundException("Application " + key));
        ApplicationTO deleted = this.binder.getApplicationTO(application);
        this.applicationDAO.delete((Entity)application);
        return deleted;
    }

    @Override
    protected ApplicationTO resolveReference(Method method, Object ... args) throws UnresolvedReferenceException {
        String key = null;
        if (ArrayUtils.isNotEmpty((Object[])args)) {
            for (int i = 0; key == null && i < args.length; ++i) {
                Object object = args[i];
                if (object instanceof String) {
                    String string;
                    key = string = (String)object;
                    continue;
                }
                object = args[i];
                if (!(object instanceof ApplicationTO)) continue;
                ApplicationTO applicationTO = (ApplicationTO)object;
                key = applicationTO.getKey();
            }
        }
        if (key != null) {
            try {
                return this.binder.getApplicationTO((Application)this.applicationDAO.findById(key).orElseThrow());
            }
            catch (Throwable ignore) {
                LOG.debug("Unresolved reference", ignore);
                throw new UnresolvedReferenceException(ignore);
            }
        }
        throw new UnresolvedReferenceException();
    }
}

