/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.services;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.services.DefaultServicesManagerRegisteredServiceLocator;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.SamlIdPUtils;
import org.apereo.cas.support.saml.idp.SamlIdPSessionManager;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.SamlRegisteredServiceMetadataAdaptor;
import org.apereo.cas.support.saml.services.idp.metadata.cache.SamlRegisteredServiceCachingMetadataResolver;
import org.apereo.cas.util.CollectionUtils;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.pac4j.core.context.session.SessionStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.Ordered;

public class SamlIdPServicesManagerRegisteredServiceLocator
extends DefaultServicesManagerRegisteredServiceLocator {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlIdPServicesManagerRegisteredServiceLocator.class);

    public SamlIdPServicesManagerRegisteredServiceLocator(SamlRegisteredServiceCachingMetadataResolver resolver) {
        this.setOrder(Integer.MIN_VALUE);
        this.setRegisteredServiceFilter((registeredService, service) -> {
            Optional<Pair<SamlProtocolServiceAttribute, String>> parameterValue = this.getSamlParameterValue((RegisteredService)registeredService, (Service)service);
            return parameterValue.map(pair -> {
                SamlProtocolServiceAttribute attribute = (SamlProtocolServiceAttribute)pair.getLeft();
                String attributeValue = (String)pair.getRight();
                LOGGER.trace("Located service attribute [{}] with value [{}]", (Object)attribute, (Object)attributeValue);
                return attribute.getEntityIdFrom(resolver, attributeValue);
            }).filter(StringUtils::isNotBlank).filter(StringUtils::isNotBlank).filter(arg_0 -> ((RegisteredService)registeredService).matches(arg_0)).stream().anyMatch(entityId -> {
                LOGGER.trace("Resolving metadata for service [{}] via entity id [{}]", (Object)registeredService.getName(), entityId);
                SamlRegisteredService samlService = (SamlRegisteredService)((Object)registeredService);
                Optional<SamlRegisteredServiceMetadataAdaptor> adaptor = SamlRegisteredServiceMetadataAdaptor.get(resolver, samlService, entityId);
                return adaptor.isPresent();
            });
        });
    }

    public boolean supports(RegisteredService registeredService, Service service) {
        boolean matched = SamlRegisteredService.class.isAssignableFrom(registeredService.getClass()) && registeredService.getFriendlyName().equalsIgnoreCase("SAML2 Service Provider");
        return matched && this.getSamlParameterValue(registeredService, service).isPresent();
    }

    protected Optional<Pair<SamlProtocolServiceAttribute, String>> getSamlParameterValue(RegisteredService registeredService, Service service) {
        if (registeredService instanceof SamlRegisteredService) {
            Map attributes = service.getAttributes();
            LOGGER.trace("Reviewing service attributes [{}] for service id [{}] to match registered service [{}]", new Object[]{attributes, service.getId(), registeredService.getName()});
            return SamlProtocolServiceAttribute.values().stream().sorted(Comparator.comparing(SamlProtocolServiceAttribute::getOrder)).filter(attr -> attributes.containsKey(attr.getAttributeName())).map(attr -> Pair.of((Object)attr, (Object)CollectionUtils.firstElement(attributes.get(attr.getAttributeName())).map(Object::toString).orElseThrow())).findFirst();
        }
        LOGGER.trace("Registered service [{}] is not a SAML2 registered service", (Object)registeredService.getName());
        return Optional.empty();
    }

    protected Class<? extends RegisteredService> getRegisteredServiceIndexedType() {
        return SamlRegisteredService.class;
    }

    private static class SamlProtocolServiceAttribute
    implements Ordered {
        private static final SamlProtocolServiceAttribute SAML_REQUEST = new SamlProtocolServiceAttribute("SAMLRequest", Integer.MAX_VALUE){

            @Override
            public String getEntityIdFrom(SamlRegisteredServiceCachingMetadataResolver resolver, String attributeValue) {
                OpenSamlConfigBean openSamlConfigBean = resolver.getOpenSamlConfigBean();
                SessionStore sessionStore = (SessionStore)openSamlConfigBean.getApplicationContext().getBean("samlIdPDistributedSessionStore", SessionStore.class);
                RequestAbstractType authnRequest = SamlIdPSessionManager.of(resolver.getOpenSamlConfigBean(), sessionStore).fetch(RequestAbstractType.class, attributeValue);
                openSamlConfigBean.logObject((XMLObject)authnRequest);
                return SamlIdPUtils.getIssuerFromSamlObject((SAMLObject)authnRequest);
            }
        };
        private static final SamlProtocolServiceAttribute ENTITY_ID = new SamlProtocolServiceAttribute("entityId", Integer.MIN_VALUE);
        private static final SamlProtocolServiceAttribute PROVIDER_ID = new SamlProtocolServiceAttribute("providerId", Integer.MIN_VALUE);
        private final String attributeName;
        private final int order;

        public static List<SamlProtocolServiceAttribute> values() {
            return List.of(ENTITY_ID, PROVIDER_ID, SAML_REQUEST);
        }

        public String getEntityIdFrom(SamlRegisteredServiceCachingMetadataResolver resolver, String attributeValue) {
            return attributeValue;
        }

        @Generated
        public SamlProtocolServiceAttribute(String attributeName, int order) {
            this.attributeName = attributeName;
            this.order = order;
        }

        @Generated
        public String getAttributeName() {
            return this.attributeName;
        }

        @Generated
        public int getOrder() {
            return this.order;
        }
    }
}

