/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.idp.metadata.generator;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apereo.cas.configuration.model.support.saml.idp.metadata.SamlIdPMetadataProperties;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.SamlUtils;
import org.apereo.cas.support.saml.idp.metadata.generator.BaseSamlIdPMetadataGenerator;
import org.apereo.cas.support.saml.idp.metadata.generator.SamlIdPMetadataGeneratorConfigurationContext;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.util.crypto.PrivateKeyFactoryBean;
import org.apereo.cas.util.function.FunctionUtils;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.Unmarshaller;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.x509.BasicX509Credential;
import org.opensaml.xmlsec.SignatureSigningParameters;
import org.opensaml.xmlsec.config.impl.DefaultSecurityConfigurationBootstrap;
import org.opensaml.xmlsec.keyinfo.KeyInfoGenerator;
import org.opensaml.xmlsec.keyinfo.NamedKeyInfoGeneratorManager;
import org.opensaml.xmlsec.signature.SignableXMLObject;
import org.opensaml.xmlsec.signature.support.SignatureSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FileSystemSamlIdPMetadataGenerator
extends BaseSamlIdPMetadataGenerator
implements InitializingBean {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(FileSystemSamlIdPMetadataGenerator.class);

    public FileSystemSamlIdPMetadataGenerator(SamlIdPMetadataGeneratorConfigurationContext context) {
        super(context);
    }

    @Override
    public Pair<String, String> buildSelfSignedEncryptionCert(Optional<SamlRegisteredService> registeredService) throws Throwable {
        Resource encCert = this.getConfigurationContext().getSamlIdPMetadataLocator().getEncryptionCertificate(registeredService);
        Resource encKey = this.getConfigurationContext().getSamlIdPMetadataLocator().resolveEncryptionKey(registeredService);
        if (encCert.isFile() && encKey.isFile()) {
            this.writeCertificateAndKey(encCert.getFile(), encKey.getFile(), registeredService);
        }
        return Pair.of((Object)encCert.getContentAsString(StandardCharsets.UTF_8), (Object)encKey.getContentAsString(StandardCharsets.UTF_8));
    }

    @Override
    public Pair<String, String> buildSelfSignedSigningCert(Optional<SamlRegisteredService> registeredService) throws Throwable {
        Resource signingCert = this.getConfigurationContext().getSamlIdPMetadataLocator().resolveSigningCertificate(registeredService);
        Resource signingKey = this.getConfigurationContext().getSamlIdPMetadataLocator().resolveSigningKey(registeredService);
        if (signingCert.isFile() && signingKey.isFile()) {
            this.writeCertificateAndKey(signingCert.getFile(), signingKey.getFile(), registeredService);
        }
        return Pair.of((Object)signingCert.getContentAsString(StandardCharsets.UTF_8), (Object)signingKey.getContentAsString(StandardCharsets.UTF_8));
    }

    @Override
    protected String writeMetadata(String metadata, Optional<SamlRegisteredService> registeredService) throws Throwable {
        Resource metadataResource = this.getConfigurationContext().getSamlIdPMetadataLocator().resolveMetadata(registeredService);
        File metadataFile = metadataResource.getFile();
        LOGGER.info("Writing SAML2 metadata to [{}]", (Object)metadataFile);
        SamlIdPMetadataProperties mdProps = this.getConfigurationContext().getCasProperties().getAuthn().getSamlIdp().getMetadata();
        if (mdProps.getFileSystem().isSignMetadata()) {
            Resource resolvedCert = this.getConfigurationContext().getSamlIdPMetadataLocator().resolveSigningCertificate(registeredService);
            X509Certificate signingCertificate = SamlUtils.readCertificate((Resource)resolvedCert);
            Resource resolvedKey = this.getConfigurationContext().getSamlIdPMetadataLocator().resolveSigningKey(registeredService);
            PrivateKeyFactoryBean bean = new PrivateKeyFactoryBean();
            bean.setLocation(resolvedKey);
            bean.afterPropertiesSet();
            PrivateKey signingKey = (PrivateKey)bean.getObject();
            byte[] signedMetadata = this.sign(metadata.getBytes(StandardCharsets.UTF_8), signingCertificate, signingKey);
            FileUtils.write((File)metadataFile, (CharSequence)new String(signedMetadata, StandardCharsets.UTF_8), (Charset)StandardCharsets.UTF_8);
        } else {
            FileUtils.write((File)metadataFile, (CharSequence)metadata, (Charset)StandardCharsets.UTF_8);
        }
        LOGGER.info("Wrote SAML2 metadata to [{}]", (Object)metadataFile);
        return metadata;
    }

    private byte[] sign(byte[] metadata, X509Certificate signingCertificate, PrivateKey privateKey) throws Exception {
        try (ByteArrayInputStream is = new ByteArrayInputStream(metadata);){
            SignableXMLObject root;
            Document document = this.getConfigurationContext().getOpenSamlConfigBean().getParserPool().parse((InputStream)is);
            Element documentElement = document.getDocumentElement();
            Unmarshaller unmarshaller = this.getConfigurationContext().getOpenSamlConfigBean().getUnmarshallerFactory().getUnmarshaller(documentElement);
            XMLObject xmlObject = Objects.requireNonNull(unmarshaller).unmarshall(documentElement);
            if (xmlObject instanceof SignableXMLObject && !(root = (SignableXMLObject)xmlObject).isSigned()) {
                SignatureSigningParameters signingParameters = new SignatureSigningParameters();
                BasicX509Credential credential = new BasicX509Credential(signingCertificate, privateKey);
                NamedKeyInfoGeneratorManager mgmr = DefaultSecurityConfigurationBootstrap.buildBasicKeyInfoGeneratorManager();
                KeyInfoGenerator keyInfoGenerator = mgmr.getDefaultManager().getFactory((Credential)credential).newInstance();
                signingParameters.setKeyInfoGenerator(keyInfoGenerator);
                signingParameters.setSigningCredential((Credential)credential);
                signingParameters.setSignatureAlgorithm("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
                signingParameters.setSignatureReferenceDigestMethod("http://www.w3.org/2001/04/xmlenc#sha256");
                signingParameters.setSignatureCanonicalizationAlgorithm("http://www.w3.org/2001/10/xml-exc-c14n#");
                SignatureSupport.signObject((SignableXMLObject)root, (SignatureSigningParameters)signingParameters);
                byte[] byArray = SamlUtils.transformSamlObject((OpenSamlConfigBean)this.getConfigurationContext().getOpenSamlConfigBean(), (XMLObject)root).toString().getBytes(StandardCharsets.UTF_8);
                return byArray;
            }
            byte[] byArray = metadata;
            return byArray;
        }
    }

    protected void writeCertificateAndKey(File certificate, File key, Optional<SamlRegisteredService> registeredService) throws Exception {
        if (certificate.exists()) {
            LOGGER.info("Certificate file [{}] already exists, and will be deleted", (Object)certificate.getCanonicalPath());
            FileUtils.forceDelete((File)certificate);
        }
        if (key.exists()) {
            LOGGER.info("Key file [{}] already exists, and will be deleted", (Object)key.getCanonicalPath());
            FileUtils.forceDelete((File)key);
        }
        LOGGER.debug("Writing SAML2 key file to [{}]", (Object)key.getPath());
        LOGGER.debug("Writing SAML2 certificate file to [{}]", (Object)certificate.getPath());
        try (BufferedWriter keyWriter = Files.newBufferedWriter(key.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);
             BufferedWriter certWriter = Files.newBufferedWriter(certificate.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
            this.getConfigurationContext().getSamlIdPCertificateAndKeyWriter().writeCertificateAndKey(keyWriter, certWriter);
        }
    }

    public void afterPropertiesSet() {
        FunctionUtils.doUnchecked(u -> this.generate(Optional.empty()), (Object[])new Object[0]);
    }

    public void initialize() throws Throwable {
        this.getConfigurationContext().getSamlIdPMetadataLocator().initialize();
        this.generate(Optional.empty());
    }
}

