/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.rest.cxf.service;

import jakarta.ws.rs.core.Response;
import java.time.OffsetDateTime;
import org.apache.syncope.common.lib.request.StatusR;
import org.apache.syncope.common.lib.request.UserCR;
import org.apache.syncope.common.lib.request.UserUR;
import org.apache.syncope.common.lib.to.ProvisioningResult;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.rest.api.service.UserService;
import org.apache.syncope.core.logic.AbstractAnyLogic;
import org.apache.syncope.core.logic.UserLogic;
import org.apache.syncope.core.persistence.api.dao.AnyDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.search.SearchCondVisitor;
import org.apache.syncope.core.rest.cxf.service.AbstractAnyService;
import org.springframework.stereotype.Service;

@Service
public class UserServiceImpl
extends AbstractAnyService<UserTO, UserCR, UserUR>
implements UserService {
    protected final UserDAO userDAO;
    protected final UserLogic logic;

    public UserServiceImpl(SearchCondVisitor searchCondVisitor, UserDAO userDAO, UserLogic logic) {
        super(searchCondVisitor);
        this.userDAO = userDAO;
        this.logic = logic;
    }

    @Override
    protected AnyDAO<?> getAnyDAO() {
        return this.userDAO;
    }

    @Override
    protected AbstractAnyLogic<UserTO, UserCR, UserUR> getAnyLogic() {
        return this.logic;
    }

    @Override
    protected UserUR newUpdateReq(String key) {
        return (UserUR)new UserUR.Builder(key).build();
    }

    public Response create(UserCR createReq) {
        ProvisioningResult created = this.logic.create(createReq, this.isNullPriorityAsync());
        return this.createResponse(created);
    }

    public Response update(UserUR updateReq) {
        return this.doUpdate(updateReq);
    }

    public Response status(StatusR statusR) {
        OffsetDateTime etag = this.findLastChange(statusR.getKey());
        this.checkETag(String.valueOf(etag.toInstant().toEpochMilli()));
        ProvisioningResult updated = this.logic.status(statusR, this.isNullPriorityAsync());
        return this.modificationResponse(updated);
    }
}

