/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.rest.cxf.service;

import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.EntityTag;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.core.UriInfo;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.ext.search.SearchContext;
import org.apache.syncope.common.lib.BaseBean;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.SyncopeConstants;
import org.apache.syncope.common.lib.to.PagedResult;
import org.apache.syncope.common.lib.to.ProvisioningResult;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.common.rest.api.Preference;
import org.apache.syncope.common.rest.api.beans.AbstractQuery;
import org.apache.syncope.common.rest.api.service.JAXRSService;
import org.apache.syncope.core.persistence.api.dao.AnyDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

public abstract class AbstractService
implements JAXRSService {
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractService.class);
    protected static final String OPTIONS_ALLOW = "GET,POST,OPTIONS,HEAD";
    @Context
    protected UriInfo uriInfo;
    @Context
    protected MessageContext messageContext;
    @Context
    protected SearchContext searchContext;

    protected static Sort sort(String orderBy, Sort defaultIfBlank) {
        if (StringUtils.isBlank((CharSequence)orderBy)) {
            return defaultIfBlank;
        }
        ArrayList<Sort.Order> clauses = new ArrayList<Sort.Order>();
        for (String clause : orderBy.split(",")) {
            String[] elems = clause.trim().split(" ");
            if (elems.length <= 0 || !StringUtils.isNotBlank((CharSequence)elems[0])) continue;
            String property = "key".equals(elems[0]) ? "id" : elems[0];
            Sort.Direction direction = Sort.DEFAULT_DIRECTION;
            if (elems.length > 1 && StringUtils.isNotBlank((CharSequence)elems[1])) {
                direction = elems[1].trim().equalsIgnoreCase(Sort.Direction.ASC.name()) ? Sort.Direction.ASC : Sort.Direction.DESC;
            }
            clauses.add(new Sort.Order(direction, property.trim()));
        }
        return Sort.by(clauses);
    }

    protected static Pageable pageable(AbstractQuery query, Sort defaultIfOrderByIsBlank) {
        return PageRequest.of((int)(query.getPage() - 1), (int)query.getSize(), (Sort)AbstractService.sort(query.getOrderBy(), defaultIfOrderByIsBlank));
    }

    protected static Pageable pageable(AbstractQuery query) {
        return AbstractService.pageable(query, AbstractService.sort(query.getOrderBy(), Sort.unsorted()));
    }

    protected String findActualKey(AnyDAO<?> dao, String pretendingKey) {
        String actualKey = pretendingKey;
        if (this.uriInfo.getPathParameters(true).containsKey((Object)"key")) {
            String keyInPath = (String)((List)this.uriInfo.getPathParameters(true).get((Object)"key")).get(0);
            if (actualKey == null) {
                actualKey = keyInPath;
            } else if (!actualKey.equals(keyInPath)) {
                SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRequest);
                sce.getElements().add("Key specified in request does not match key in the path");
                throw sce;
            }
        }
        if (actualKey == null) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRequest);
            sce.getElements().add("Key is null");
            throw sce;
        }
        if (!SyncopeConstants.UUID_PATTERN.matcher(actualKey).matches()) {
            actualKey = dao instanceof UserDAO ? (String)((UserDAO)dao).findKey(actualKey).orElse(null) : (dao instanceof GroupDAO ? (String)((GroupDAO)dao).findKey(actualKey).orElse(null) : null);
        }
        return actualKey;
    }

    protected boolean isNullPriorityAsync() {
        return BooleanUtils.toBoolean((String)this.messageContext.getHttpServletRequest().getHeader("X-Syncope-Null-Priority-Async"));
    }

    protected Preference getPreference() {
        return Preference.fromString((String)this.messageContext.getHttpServletRequest().getHeader("Prefer"));
    }

    protected Response.ResponseBuilder applyPreference(ProvisioningResult<?> provisioningResult, Response.ResponseBuilder builder) {
        switch (this.getPreference()) {
            case RETURN_NO_CONTENT: {
                break;
            }
            default: {
                builder.entity(provisioningResult);
            }
        }
        if (this.getPreference() == Preference.RETURN_CONTENT || this.getPreference() == Preference.RETURN_NO_CONTENT) {
            builder.header("Preference-Applied", (Object)this.getPreference().toString());
        }
        return builder;
    }

    protected Response createResponse(ProvisioningResult<?> provisioningResult) {
        String entityId = provisioningResult.getEntity().getKey();
        Response.ResponseBuilder builder = Response.created((URI)this.uriInfo.getAbsolutePathBuilder().path(entityId).build(new Object[0])).header("X-Syncope-Key", (Object)entityId);
        return this.applyPreference(provisioningResult, builder).build();
    }

    protected Response modificationResponse(Object entity) {
        Response.ResponseBuilder builder = switch (this.getPreference()) {
            case Preference.RETURN_NO_CONTENT -> Response.noContent();
            default -> Response.ok((Object)entity);
        };
        if (this.getPreference() == Preference.RETURN_CONTENT || this.getPreference() == Preference.RETURN_NO_CONTENT) {
            builder.header("Preference-Applied", (Object)this.getPreference().toString());
        }
        return builder.build();
    }

    protected void checkETag(String etag) {
        Response.ResponseBuilder builder = this.messageContext.getRequest().evaluatePreconditions(new EntityTag(etag));
        if (builder != null) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.ConcurrentModification);
            sce.getElements().add("Mismatching ETag value");
            throw sce;
        }
    }

    protected <T extends BaseBean> PagedResult<T> buildPagedResult(Page<T> page) {
        PagedResult result = new PagedResult();
        result.getResult().addAll(page.get().toList());
        result.setPage(page.getNumber() + 1);
        result.setSize(result.getResult().size());
        result.setTotalCount(page.getTotalElements());
        UriBuilder builder = this.uriInfo.getAbsolutePathBuilder();
        MultivaluedMap queryParams = this.uriInfo.getQueryParameters();
        queryParams.forEach((key, value) -> builder.queryParam(key, value.toArray()));
        if (result.getPage() > 1) {
            result.setPrev(builder.replaceQueryParam("page", new Object[]{result.getPage() - 1}).replaceQueryParam("size", new Object[]{page.getSize()}).build(new Object[0]));
        }
        if ((long)((result.getPage() - 1) * page.getSize() + result.getSize()) < page.getTotalElements()) {
            result.setNext(builder.replaceQueryParam("page", new Object[]{result.getPage() + 1}).replaceQueryParam("size", new Object[]{page.getSize()}).build(new Object[0]));
        }
        return result;
    }
}

