/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.rest.cxf.service;

import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.core.Response;
import java.time.OffsetDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.syncope.common.lib.Attr;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.request.AnyCR;
import org.apache.syncope.common.lib.request.AnyUR;
import org.apache.syncope.common.lib.request.AttrPatch;
import org.apache.syncope.common.lib.request.ResourceAR;
import org.apache.syncope.common.lib.request.ResourceDR;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.to.PagedResult;
import org.apache.syncope.common.lib.to.ProvisioningResult;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.common.lib.types.PatchOperation;
import org.apache.syncope.common.lib.types.ResourceAssociationAction;
import org.apache.syncope.common.lib.types.ResourceDeassociationAction;
import org.apache.syncope.common.lib.types.SchemaType;
import org.apache.syncope.common.rest.api.Preference;
import org.apache.syncope.common.rest.api.RESTHeaders;
import org.apache.syncope.common.rest.api.batch.BatchPayloadGenerator;
import org.apache.syncope.common.rest.api.batch.BatchResponseItem;
import org.apache.syncope.common.rest.api.beans.AbstractQuery;
import org.apache.syncope.common.rest.api.beans.AnyQuery;
import org.apache.syncope.common.rest.api.service.AnyService;
import org.apache.syncope.core.logic.AbstractAnyLogic;
import org.apache.syncope.core.persistence.api.dao.AnyDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.search.SearchCond;
import org.apache.syncope.core.persistence.api.search.SearchCondVisitor;
import org.apache.syncope.core.provisioning.api.serialization.POJOHelper;
import org.apache.syncope.core.rest.cxf.service.AbstractSearchService;
import org.apache.syncope.core.spring.security.SecureRandomUtils;
import org.springframework.data.domain.Page;

public abstract class AbstractAnyService<TO extends AnyTO, CR extends AnyCR, UR extends AnyUR>
extends AbstractSearchService
implements AnyService<TO> {
    public AbstractAnyService(SearchCondVisitor searchCondVisitor) {
        super(searchCondVisitor);
    }

    protected abstract AnyDAO<?> getAnyDAO();

    protected abstract AbstractAnyLogic<TO, CR, UR> getAnyLogic();

    protected abstract UR newUpdateReq(String var1);

    public Set<Attr> read(String key, SchemaType schemaType) {
        TO any = this.read(key);
        return switch (schemaType) {
            case SchemaType.DERIVED -> any.getDerAttrs();
            case SchemaType.VIRTUAL -> any.getVirAttrs();
            default -> any.getPlainAttrs();
        };
    }

    public Attr read(String key, SchemaType schemaType, String schema) {
        TO any = this.read(key);
        return (Attr)(switch (schemaType) {
            case SchemaType.DERIVED -> any.getDerAttr(schema);
            case SchemaType.VIRTUAL -> any.getVirAttr(schema);
            default -> any.getPlainAttr(schema);
        }).orElseThrow(() -> new NotFoundException("Attribute for type " + String.valueOf(schemaType) + " and schema " + schema));
    }

    public TO read(String key) {
        return (TO)this.getAnyLogic().read(this.findActualKey(this.getAnyDAO(), key));
    }

    public PagedResult<TO> search(AnyQuery anyQuery) {
        String realm = StringUtils.prependIfMissing((String)anyQuery.getRealm(), (CharSequence)"/", (CharSequence[])new CharSequence[0]);
        SearchCond searchCond = StringUtils.isBlank((CharSequence)anyQuery.getFiql()) ? null : this.getSearchCond(anyQuery.getFiql(), realm);
        try {
            Page result = this.getAnyLogic().search(searchCond, AbstractAnyService.pageable((AbstractQuery)anyQuery), realm, anyQuery.getRecursive().booleanValue(), anyQuery.getDetails().booleanValue());
            return this.buildPagedResult(result);
        }
        catch (IllegalArgumentException e) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidSearchParameters);
            sce.getElements().add(anyQuery.getFiql());
            sce.getElements().add(ExceptionUtils.getRootCauseMessage((Throwable)e));
            throw sce;
        }
    }

    protected OffsetDateTime findLastChange(String key) {
        return (OffsetDateTime)this.getAnyDAO().findLastChange(key).orElseThrow(() -> new NotFoundException("User, Group or Any Object for " + key));
    }

    protected Response doUpdate(UR updateReq) {
        updateReq.setKey(this.findActualKey(this.getAnyDAO(), updateReq.getKey()));
        OffsetDateTime etag = this.findLastChange(updateReq.getKey());
        this.checkETag(String.valueOf(etag.toInstant().toEpochMilli()));
        ProvisioningResult updated = this.getAnyLogic().update(updateReq, this.isNullPriorityAsync());
        return this.modificationResponse(updated);
    }

    protected void addUpdateOrReplaceAttr(String key, SchemaType schemaType, Attr attrTO, PatchOperation operation) {
        if (attrTO.getSchema() == null) {
            throw new NotFoundException("Must specify schema");
        }
        UR updateReq = this.newUpdateReq(key);
        switch (schemaType) {
            case VIRTUAL: {
                updateReq.getVirAttrs().add(attrTO);
                break;
            }
            case PLAIN: {
                updateReq.getPlainAttrs().add((AttrPatch)((AttrPatch.Builder)new AttrPatch.Builder(attrTO).operation(operation)).build());
                break;
            }
        }
        this.doUpdate(updateReq);
    }

    public Response update(String key, SchemaType schemaType, Attr attrTO) {
        String actualKey = this.findActualKey(this.getAnyDAO(), key);
        this.addUpdateOrReplaceAttr(actualKey, schemaType, attrTO, PatchOperation.ADD_REPLACE);
        return this.modificationResponse(this.read(actualKey, schemaType, attrTO.getSchema()));
    }

    public void delete(String key, SchemaType schemaType, String schema) {
        this.addUpdateOrReplaceAttr(this.findActualKey(this.getAnyDAO(), key), schemaType, new Attr.Builder(schema).build(), PatchOperation.DELETE);
    }

    public Response delete(String key) {
        String actualKey = this.findActualKey(this.getAnyDAO(), key);
        OffsetDateTime etag = this.findLastChange(actualKey);
        this.checkETag(String.valueOf(etag.toInstant().toEpochMilli()));
        ProvisioningResult deleted = this.getAnyLogic().delete(actualKey, this.isNullPriorityAsync());
        return this.modificationResponse(deleted);
    }

    public Response deassociate(ResourceDR req) {
        ProvisioningResult updated;
        OffsetDateTime etag = this.findLastChange(req.getKey());
        this.checkETag(String.valueOf(etag.toInstant().toEpochMilli()));
        switch (req.getAction()) {
            case UNLINK: {
                updated = new ProvisioningResult();
                updated.setEntity((EntityTO)this.getAnyLogic().unlink(req.getKey(), (Collection)req.getResources()));
                break;
            }
            case UNASSIGN: {
                updated = this.getAnyLogic().unassign(req.getKey(), (Collection)req.getResources(), this.isNullPriorityAsync());
                break;
            }
            case DEPROVISION: {
                updated = this.getAnyLogic().deprovision(req.getKey(), req.getResources(), this.isNullPriorityAsync());
                break;
            }
            default: {
                throw new BadRequestException("Missing action");
            }
        }
        List<BatchResponseItem> batchResponseItems = req.getAction() == ResourceDeassociationAction.UNLINK ? req.getResources().stream().map(resource -> {
            BatchResponseItem item = new BatchResponseItem();
            item.getHeaders().put("X-Syncope-Key", List.of(resource));
            item.setStatus(((AnyTO)updated.getEntity()).getResources().contains(resource) ? Response.Status.BAD_REQUEST.getStatusCode() : Response.Status.OK.getStatusCode());
            if (this.getPreference() == Preference.RETURN_NO_CONTENT) {
                item.getHeaders().put("Preference-Applied", List.of(Preference.RETURN_NO_CONTENT.toString()));
            } else {
                item.setContent(POJOHelper.serialize((Object)updated.getEntity()));
            }
            return item;
        }).toList() : updated.getPropagationStatuses().stream().map(status -> {
            BatchResponseItem item = new BatchResponseItem();
            item.getHeaders().put("X-Syncope-Key", List.of(status.getResource()));
            item.setStatus(status.getStatus().getHttpStatus());
            if (status.getFailureReason() != null) {
                item.getHeaders().put("X-Application-Error-Info", List.of(status.getFailureReason()));
            }
            if (this.getPreference() == Preference.RETURN_NO_CONTENT) {
                item.getHeaders().put("Preference-Applied", List.of(Preference.RETURN_NO_CONTENT.toString()));
            } else {
                item.setContent(POJOHelper.serialize((Object)updated.getEntity()));
            }
            return item;
        }).toList();
        String boundary = "deassociate_" + SecureRandomUtils.generateRandomUUID().toString();
        return Response.ok((Object)BatchPayloadGenerator.generate(batchResponseItems, (String)("--" + boundary))).type(RESTHeaders.multipartMixedWith((String)boundary)).build();
    }

    public Response associate(ResourceAR req) {
        ProvisioningResult updated;
        OffsetDateTime etag = this.findLastChange(req.getKey());
        this.checkETag(String.valueOf(etag.toInstant().toEpochMilli()));
        switch (req.getAction()) {
            case LINK: {
                updated = new ProvisioningResult();
                updated.setEntity((EntityTO)this.getAnyLogic().link(req.getKey(), (Collection)req.getResources()));
                break;
            }
            case ASSIGN: {
                updated = this.getAnyLogic().assign(req.getKey(), (Collection)req.getResources(), req.getValue() != null, (String)req.getValue(), this.isNullPriorityAsync());
                break;
            }
            case PROVISION: {
                updated = this.getAnyLogic().provision(req.getKey(), req.getResources(), req.getValue() != null, (String)req.getValue(), this.isNullPriorityAsync());
                break;
            }
            default: {
                throw new BadRequestException("Missing action");
            }
        }
        List<BatchResponseItem> batchResponseItems = req.getAction() == ResourceAssociationAction.LINK ? req.getResources().stream().map(resource -> {
            BatchResponseItem item = new BatchResponseItem();
            item.getHeaders().put("X-Syncope-Key", List.of(resource));
            item.setStatus(((AnyTO)updated.getEntity()).getResources().contains(resource) ? Response.Status.OK.getStatusCode() : Response.Status.BAD_REQUEST.getStatusCode());
            if (this.getPreference() == Preference.RETURN_NO_CONTENT) {
                item.getHeaders().put("Preference-Applied", List.of(Preference.RETURN_NO_CONTENT.toString()));
            } else {
                item.setContent(POJOHelper.serialize((Object)updated.getEntity()));
            }
            return item;
        }).toList() : updated.getPropagationStatuses().stream().map(status -> {
            BatchResponseItem item = new BatchResponseItem();
            item.getHeaders().put("X-Syncope-Key", List.of(status.getResource()));
            item.setStatus(status.getStatus().getHttpStatus());
            if (status.getFailureReason() != null) {
                item.getHeaders().put("X-Application-Error-Info", List.of(status.getFailureReason()));
            }
            if (this.getPreference() == Preference.RETURN_NO_CONTENT) {
                item.getHeaders().put("Preference-Applied", List.of(Preference.RETURN_NO_CONTENT.toString()));
            } else {
                item.setContent(POJOHelper.serialize((Object)updated.getEntity()));
            }
            return item;
        }).toList();
        String boundary = "associate_" + SecureRandomUtils.generateRandomUUID().toString();
        return Response.ok((Object)BatchPayloadGenerator.generate(batchResponseItems, (String)("--" + boundary))).type(RESTHeaders.multipartMixedWith((String)boundary)).build();
    }
}

