/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.rest.cxf.batch;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.WriteListener;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class BatchItemResponse
implements HttpServletResponse {
    private final Set<Cookie> cookies = new HashSet<Cookie>();
    private final Map<String, List<Object>> headers = new HashMap<String, List<Object>>();
    private final ByteArrayOutputStream baos = new ByteArrayOutputStream();
    private final ServletOutputStream servletOuputStream = new ServletOutputStream(){

        public boolean isReady() {
            return true;
        }

        public void setWriteListener(WriteListener writeListener) {
        }

        public void write(int b) {
            BatchItemResponse.this.baos.write(b);
        }
    };
    private final PrintWriter writer = new PrintWriter(this.baos);
    private int status;
    private Locale locale;

    public Set<Cookie> getCookies() {
        return this.cookies;
    }

    public Map<String, List<Object>> getHeaders() {
        return this.headers;
    }

    public void addCookie(Cookie cookie) {
        this.cookies.add(cookie);
    }

    public boolean containsHeader(String name) {
        return this.headers.containsKey(name);
    }

    public void setDateHeader(String name, long date) {
        List<Object> values = this.headers.get(name);
        if (values == null) {
            values = new ArrayList<Object>();
            this.headers.put(name, values);
        } else {
            values.clear();
        }
        values.add(date);
    }

    public void addDateHeader(String name, long date) {
        List<Object> values = this.headers.get(name);
        if (values == null) {
            values = new ArrayList<Object>();
            this.headers.put(name, values);
        }
        values.add(date);
    }

    public void setHeader(String name, String value) {
        List<Object> values = this.headers.get(name);
        if (values == null) {
            values = new ArrayList<Object>();
            this.headers.put(name, values);
        } else {
            values.clear();
        }
        values.add(value);
    }

    public void addHeader(String name, String value) {
        List<Object> values = this.headers.get(name);
        if (values == null) {
            values = new ArrayList<Object>();
            this.headers.put(name, values);
        }
        values.add(value);
    }

    public void setIntHeader(String name, int value) {
        List<Object> values = this.headers.get(name);
        if (values == null) {
            values = new ArrayList<Object>();
            this.headers.put(name, values);
        } else {
            values.clear();
        }
        values.add(value);
    }

    public void addIntHeader(String name, int value) {
        List<Object> values = this.headers.get(name);
        if (values == null) {
            values = new ArrayList<Object>();
            this.headers.put(name, values);
        }
        values.add(value);
    }

    public String getHeader(String name) {
        return this.headers.containsKey(name) ? this.headers.get(name).get(0).toString() : null;
    }

    public Collection<String> getHeaders(String name) {
        return this.headers.containsKey(name) ? this.headers.get(name).stream().map(Object::toString).toList() : List.of();
    }

    public Collection<String> getHeaderNames() {
        return this.headers.keySet();
    }

    public String encodeURL(String url) {
        return url;
    }

    public String encodeRedirectURL(String url) {
        return url;
    }

    public void sendError(int sc, String msg) {
        this.setStatus(sc);
    }

    public void sendError(int sc) {
        this.setStatus(sc);
    }

    public void sendRedirect(String location) {
        this.setStatus(302);
        this.setHeader("Location", location);
    }

    public void setStatus(int sc) {
        this.status = sc;
    }

    public int getStatus() {
        return this.status;
    }

    public String getCharacterEncoding() {
        throw new UnsupportedOperationException();
    }

    public String getContentType() {
        throw new UnsupportedOperationException();
    }

    public ByteArrayOutputStream getUnderlyingOutputStream() {
        return this.baos;
    }

    public ServletOutputStream getOutputStream() {
        return this.servletOuputStream;
    }

    public PrintWriter getWriter() {
        return this.writer;
    }

    public void setCharacterEncoding(String charset) {
        throw new UnsupportedOperationException();
    }

    public void setContentLength(int len) {
        this.setIntHeader("Content-Length", len);
    }

    public void setContentLengthLong(long len) {
        this.setContentLength((int)len);
    }

    public void setContentType(String type) {
        this.setHeader("Content-Type", type);
    }

    public void setBufferSize(int size) {
        throw new UnsupportedOperationException();
    }

    public int getBufferSize() {
        throw new UnsupportedOperationException();
    }

    public void flushBuffer() {
        throw new UnsupportedOperationException();
    }

    public void resetBuffer() {
        throw new UnsupportedOperationException();
    }

    public boolean isCommitted() {
        throw new UnsupportedOperationException();
    }

    public void reset() {
        throw new UnsupportedOperationException();
    }

    public void setLocale(Locale loc) {
        this.locale = loc;
    }

    public Locale getLocale() {
        return this.locale;
    }
}

