/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.rest.cxf.batch;

import jakarta.servlet.ReadListener;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import java.io.ByteArrayInputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.syncope.common.rest.api.batch.BatchRequestItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchItemRequest
extends HttpServletRequestWrapper {
    private static final Logger LOG = LoggerFactory.getLogger(BatchItemRequest.class);
    private final String scheme;
    private final String serverName;
    private final int serverPort;
    private final String contextPath;
    private final String servletPath;
    private final String pathInfo;
    private final String characterEncoding;
    private final String baseURI;
    private final BatchRequestItem batchItem;
    private final ServletInputStream inputStream;
    private final Map<String, Object> attributes = new HashMap<String, Object>();

    public BatchItemRequest(String scheme, String serverName, int serverPort, String contextPath, String servletPath, String pathInfo, String characterEncoding, String baseURI, HttpServletRequest request, final BatchRequestItem batchItem) {
        super(request);
        this.scheme = scheme;
        this.serverName = serverName;
        this.serverPort = serverPort;
        this.contextPath = contextPath;
        this.servletPath = servletPath;
        this.pathInfo = pathInfo;
        this.characterEncoding = characterEncoding;
        this.baseURI = baseURI;
        this.batchItem = batchItem;
        this.inputStream = new ServletInputStream(this){
            private final ByteArrayInputStream bais;
            private boolean isFinished;
            private boolean isReady;
            {
                this.bais = new ByteArrayInputStream(batchItem.getContent().getBytes());
                this.isFinished = false;
                this.isReady = true;
            }

            public boolean isFinished() {
                return this.isFinished;
            }

            public boolean isReady() {
                return this.isReady;
            }

            public void setReadListener(ReadListener readListener) {
            }

            public int read() {
                this.isFinished = true;
                this.isReady = false;
                return this.bais.read();
            }
        };
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getServerName() {
        return this.serverName;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public String getMethod() {
        return this.batchItem.getMethod();
    }

    public StringBuffer getRequestURL() {
        return new StringBuffer(this.baseURI).append(this.getRequestURI());
    }

    public String getRequestURI() {
        return this.batchItem.getRequestURI();
    }

    public String getQueryString() {
        return this.batchItem.getQueryString();
    }

    public String getContentType() {
        return this.batchItem.getHeaders().containsKey("Content-Type") ? ((List)this.batchItem.getHeaders().get("Content-Type")).get(0).toString() : "*/*";
    }

    public int getContentLength() {
        int contentLength = 0;
        if (this.batchItem.getHeaders().containsKey("Content-Length")) {
            try {
                contentLength = Integer.parseInt(((List)this.batchItem.getHeaders().get("Content-Length")).get(0).toString());
            }
            catch (NumberFormatException e) {
                LOG.error("Invalid value found for {}: {}", new Object[]{"Content-Length", this.batchItem.getHeaders().get("Content-Length"), e});
            }
        }
        return contentLength;
    }

    public long getContentLengthLong() {
        return this.getContentLength();
    }

    public String getHeader(String name) {
        return this.batchItem.getHeaders().containsKey(name) ? ((List)this.batchItem.getHeaders().get(name)).get(0).toString() : ("Content-Type".equals(name) || "Accept".equals(name) ? "*/*" : null);
    }

    public Enumeration<String> getHeaders(String name) {
        return this.batchItem.getHeaders().containsKey(name) ? Collections.enumeration(((List)this.batchItem.getHeaders().get(name)).stream().map(Object::toString).collect(Collectors.toList())) : ("Content-Type".equals(name) || "Accept".equals(name) ? Collections.enumeration(List.of("*/*")) : Collections.emptyEnumeration());
    }

    public Enumeration<String> getHeaderNames() {
        HashSet names = new HashSet(this.batchItem.getHeaders().keySet());
        names.add("Content-Type");
        names.add("Accept");
        return Collections.enumeration(names);
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public ServletInputStream getInputStream() {
        return this.inputStream;
    }
}

