/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.gauth.web.flow.account;

import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.web.flow.actions.ConsumerExecutionAction;
import org.apereo.cas.web.flow.actions.PopulateMessageContextAction;
import org.apereo.cas.web.flow.configurer.MultifactorAuthenticationAccountProfileWebflowConfigurer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.ActionState;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.engine.TransitionableState;
import org.springframework.webflow.engine.ViewState;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.execution.Action;

public class GoogleMultifactorAuthenticationAccountProfileWebflowConfigurer
extends MultifactorAuthenticationAccountProfileWebflowConfigurer {
    public GoogleMultifactorAuthenticationAccountProfileWebflowConfigurer(FlowBuilderServices flowBuilderServices, FlowDefinitionRegistry accountProfileFlowRegistry, ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
        super(flowBuilderServices, accountProfileFlowRegistry, applicationContext, casProperties);
    }

    protected void doInitialize() {
        super.doInitialize();
        Flow accountFlow = this.getFlow("account");
        ViewState myAccountView = (ViewState)this.getState(accountFlow, "myAccountProfile", ViewState.class);
        myAccountView.getRenderActionList().add((Action)this.createEvaluateAction("googleAccountProfilePrepareAction"));
        ViewState regViewState = this.createViewState(accountFlow, "viewRegistration", "gauth/casGoogleAuthenticatorRegistrationView");
        regViewState.getEntryActionList().add((Action)this.createEvaluateAction("googleAccountProfileRegistrationAction"));
        regViewState.getEntryActionList().addAll(new Action[]{this.createEvaluateAction("googleAccountCreateRegistrationAction")});
        this.createTransitionForState((TransitionableState)regViewState, "submit", "saveRegistration");
        ActionState acctRegSaveState = this.createActionState(accountFlow, "saveRegistration", (Action)this.createEvaluateAction("googleSaveAccountRegistrationAction"));
        this.createTransitionForState((TransitionableState)acctRegSaveState, "success", "googleAccountProfileRegistrationFinalized");
        this.createStateDefaultTransition((TransitionableState)acctRegSaveState, "viewRegistration");
        ConsumerExecutionAction finalizeRegistrationAction = new PopulateMessageContextAction.Info(new String[]{"screen.account.mfadevices.register.success"}).setEventId("success");
        ActionState acctRegFinalize = this.createActionState(accountFlow, "googleAccountProfileRegistrationFinalized", (Action)finalizeRegistrationAction);
        this.createStateDefaultTransition((TransitionableState)acctRegFinalize, "myAccountProfile");
        ViewState accountProfileView = (ViewState)accountFlow.getState("myAccountProfile");
        this.createTransitionForState((TransitionableState)accountProfileView, "register", regViewState.getId());
    }
}

