/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import jakarta.servlet.http.HttpServletRequest;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.core5.http.HttpEntityContainer;
import org.apache.hc.core5.http.HttpResponse;
import org.apereo.cas.configuration.model.support.captcha.GoogleRecaptchaProperties;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.util.http.HttpExecutionRequest;
import org.apereo.cas.util.http.HttpUtils;
import org.apereo.cas.web.CaptchaValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;

public abstract class BaseCaptchaValidator
implements CaptchaValidator {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseCaptchaValidator.class);
    private static final ObjectReader READER = new ObjectMapper().findAndRegisterModules().reader();
    private final GoogleRecaptchaProperties recaptchaProperties;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean validate(String recaptchaResponse, String userAgent) {
        HttpResponse response;
        block4: {
            boolean bl;
            response = null;
            try {
                response = this.executeCaptchaVerification(recaptchaResponse, userAgent);
                if (response == null || response.getCode() != HttpStatus.OK.value()) break block4;
                bl = this.parseCaptchaResponse(response);
            }
            catch (Exception e) {
                try {
                    LoggingUtils.error((Logger)LOGGER, (Throwable)e);
                }
                catch (Throwable throwable) {
                    HttpUtils.close(response);
                    throw throwable;
                }
                HttpUtils.close((HttpResponse)response);
            }
            HttpUtils.close((HttpResponse)response);
            return bl;
        }
        HttpUtils.close((HttpResponse)response);
        return false;
    }

    @Override
    public String getRecaptchaResponse(HttpServletRequest request) {
        return request.getParameter(this.getRecaptchaResponseParameterName());
    }

    protected HttpResponse executeCaptchaVerification(String recaptchaResponse, String userAgent) {
        Map headers = CollectionUtils.wrap((String)"User-Agent", (Object)userAgent, (String)"Content-Type", (Object)"application/x-www-form-urlencoded", (String)"Accept-Language", (Object)"en-US,en;q=0.5");
        headers.putAll(this.recaptchaProperties.getHeaders());
        HttpExecutionRequest exec = HttpExecutionRequest.builder().method(HttpMethod.POST).url(this.recaptchaProperties.getVerifyUrl()).headers(headers).entity("secret=%s&response=%s".formatted(this.recaptchaProperties.getSecret(), recaptchaResponse)).build();
        return HttpUtils.execute((HttpExecutionRequest)exec);
    }

    protected boolean parseCaptchaResponse(HttpResponse response) throws Exception {
        try (InputStream content = ((HttpEntityContainer)response).getEntity().getContent();){
            String result = IOUtils.toString((InputStream)content, (Charset)StandardCharsets.UTF_8);
            if (StringUtils.isBlank((CharSequence)result)) {
                throw new IllegalArgumentException("Unable to parse empty entity response from " + this.recaptchaProperties.getVerifyUrl());
            }
            LOGGER.debug("Recaptcha verification response received: [{}]", (Object)result);
            JsonNode node = READER.readTree(result);
            if (node.has("score") && node.get("score").doubleValue() <= this.recaptchaProperties.getScore()) {
                LOGGER.warn("Recaptcha score received is less than the threshold score defined for CAS");
                boolean bl = false;
                return bl;
            }
            if (node.has("success") && node.get("success").booleanValue()) {
                LOGGER.trace("Recaptcha has successfully verified the request");
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    @Generated
    public BaseCaptchaValidator(GoogleRecaptchaProperties recaptchaProperties) {
        this.recaptchaProperties = recaptchaProperties;
    }

    @Override
    @Generated
    public GoogleRecaptchaProperties getRecaptchaProperties() {
        return this.recaptchaProperties;
    }
}

