/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.consent;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.consent.ConsentDecision;
import org.apereo.cas.consent.ConsentEngine;
import org.apereo.cas.consent.ConsentRepository;
import org.apereo.cas.util.CompressionUtils;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.apereo.cas.web.BaseCasRestActuatorEndpoint;
import org.jooq.lambda.Unchecked;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.core.io.WritableResource;
import org.springframework.http.ContentDisposition;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Endpoint(id="attributeConsent", enableByDefault=false)
public class AttributeConsentReportEndpoint
extends BaseCasRestActuatorEndpoint {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AttributeConsentReportEndpoint.class);
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().defaultTypingEnabled(false).build().toObjectMapper();
    private final ObjectProvider<ConsentRepository> consentRepository;
    private final ObjectProvider<ConsentEngine> consentEngine;

    public AttributeConsentReportEndpoint(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext, ObjectProvider<ConsentRepository> consentRepository, ObjectProvider<ConsentEngine> consentEngine) {
        super(casProperties, applicationContext);
        this.consentRepository = consentRepository;
        this.consentEngine = consentEngine;
    }

    @GetMapping(produces={"application/json"})
    @Operation(summary="Get all consent decisions")
    public Collection<Map<String, Object>> consentDecisions() {
        HashSet<Map<String, Object>> result = new HashSet<Map<String, Object>>();
        Collection consentDecisions = ((ConsentRepository)this.consentRepository.getObject()).findConsentDecisions();
        consentDecisions.forEach(decision -> {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("decision", decision);
            map.put("attributes", ((ConsentEngine)this.consentEngine.getObject()).resolveConsentableAttributesFrom(decision));
            result.add(map);
        });
        return result;
    }

    @GetMapping(path={"{principal}"}, produces={"application/json"})
    @Operation(summary="Get consent decisions for principal", parameters={@Parameter(name="principal", required=true, description="The principal to look up")})
    public Collection<Map<String, Object>> consentDecisions(@PathVariable String principal) {
        HashSet<Map<String, Object>> result = new HashSet<Map<String, Object>>();
        LOGGER.debug("Fetching consent decisions for principal [{}]", (Object)principal);
        Collection consentDecisions = ((ConsentRepository)this.consentRepository.getObject()).findConsentDecisions(principal);
        LOGGER.debug("Resolved consent decisions for principal [{}]: [{}]", (Object)principal, (Object)consentDecisions);
        consentDecisions.forEach(d -> {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("decision", d);
            map.put("attributes", ((ConsentEngine)this.consentEngine.getObject()).resolveConsentableAttributesFrom(d));
            result.add(map);
        });
        return result;
    }

    @GetMapping(path={"/export"}, produces={"application/octet-stream"})
    @ResponseBody
    @Operation(summary="Export consent decisions as a zip file")
    public ResponseEntity<Resource> export() {
        Collection accounts = ((ConsentRepository)this.consentRepository.getObject()).findConsentDecisions();
        WritableResource resource = CompressionUtils.toZipFile(accounts.stream(), (Function)Unchecked.function(entry -> {
            ConsentDecision acct = (ConsentDecision)entry;
            String fileName = String.format("%s-%s", acct.getPrincipal(), acct.getId());
            File sourceFile = Files.createTempFile(fileName, ".json", new FileAttribute[0]).toFile();
            MAPPER.writeValue(sourceFile, (Object)acct);
            return sourceFile;
        }), (String)"attrconsent");
        HttpHeaders headers = new HttpHeaders();
        headers.setContentDisposition(ContentDisposition.attachment().filename(Objects.requireNonNull(resource.getFilename())).build());
        headers.put("Filename", List.of("consent.zip"));
        return new ResponseEntity((Object)resource, (MultiValueMap)headers, (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(path={"/import"}, consumes={"application/json"})
    @Operation(summary="Import a consent decision as a JSON document")
    public ResponseEntity importAccount(HttpServletRequest request) throws Throwable {
        String requestBody = IOUtils.toString((InputStream)request.getInputStream(), (Charset)StandardCharsets.UTF_8);
        LOGGER.trace("Submitted account: [{}]", (Object)requestBody);
        ConsentDecision decision = (ConsentDecision)MAPPER.readValue(requestBody, (TypeReference)new TypeReference<ConsentDecision>(this){});
        LOGGER.trace("Storing account: [{}]", (Object)decision);
        ((ConsentRepository)this.consentRepository.getObject()).storeConsentDecision(decision);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).build();
    }

    @DeleteMapping(path={"{principal}/{decisionId}"}, produces={"application/json"})
    @Operation(summary="Delete a consent decision for principal using a decision id", parameters={@Parameter(name="principal", required=true, description="The principal id to look up"), @Parameter(name="decisionId", required=true, description="The decision id to delete")})
    public boolean revokeConsents(@PathVariable String principal, @PathVariable long decisionId) throws Throwable {
        LOGGER.debug("Deleting consent decision for principal [{}].", (Object)principal);
        return ((ConsentRepository)this.consentRepository.getObject()).deleteConsentDecision(decisionId, principal);
    }

    @DeleteMapping(path={"{principal}"}, produces={"application/json"})
    @Operation(summary="Delete consent decisions for principal", parameters={@Parameter(name="principal", required=true, description="The principal id to look up")})
    public boolean revokeAllConsents(@PathVariable String principal) throws Throwable {
        LOGGER.debug("Deleting all consent decisions for principal [{}].", (Object)principal);
        return ((ConsentRepository)this.consentRepository.getObject()).deleteConsentDecisions(principal);
    }
}

