/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.mutable;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.kafka.server.mutable.BoundedList;
import org.apache.kafka.server.mutable.BoundedListTooLongException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=120L)
public class BoundedListTest {
    @Test
    public void testMaxLengthMustNotBeZero() {
        Assertions.assertEquals((Object)"Invalid non-positive maxLength of 0", (Object)((IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> new BoundedList(0, new ArrayList()))).getMessage());
    }

    @Test
    public void testMaxLengthMustNotBeNegative() {
        Assertions.assertEquals((Object)"Invalid non-positive maxLength of -123", (Object)((IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> new BoundedList(-123, new ArrayList()))).getMessage());
    }

    @Test
    public void testOwnedListMustNotBeTooLong() {
        Assertions.assertEquals((Object)"Cannot wrap list, because it is longer than the maximum length 1", (Object)((BoundedListTooLongException)Assertions.assertThrows(BoundedListTooLongException.class, () -> new BoundedList(1, new ArrayList<Integer>(Arrays.asList(1, 2))))).getMessage());
    }

    @Test
    public void testAddingToBoundedList() {
        BoundedList list = new BoundedList(2, new ArrayList(3));
        Assertions.assertEquals((int)0, (int)list.size());
        Assertions.assertTrue((boolean)list.isEmpty());
        Assertions.assertTrue((boolean)list.add((Object)456));
        Assertions.assertTrue((boolean)list.contains((Object)456));
        Assertions.assertEquals((int)1, (int)list.size());
        Assertions.assertFalse((boolean)list.isEmpty());
        Assertions.assertTrue((boolean)list.add((Object)789));
        Assertions.assertEquals((Object)"Cannot add another element to the list because it would exceed the maximum length of 2", (Object)((BoundedListTooLongException)Assertions.assertThrows(BoundedListTooLongException.class, () -> list.add((Object)912))).getMessage());
        Assertions.assertEquals((Object)"Cannot add another element to the list because it would exceed the maximum length of 2", (Object)((BoundedListTooLongException)Assertions.assertThrows(BoundedListTooLongException.class, () -> list.add(0, (Object)912))).getMessage());
    }

    private static <E> void testHashCodeAndEquals(List<E> a) {
        Assertions.assertEquals(a, (Object)new BoundedList(123, a));
        Assertions.assertEquals((int)a.hashCode(), (int)new BoundedList(123, a).hashCode());
    }

    @Test
    public void testHashCodeAndEqualsForEmptyList() {
        BoundedListTest.testHashCodeAndEquals(Collections.emptyList());
    }

    @Test
    public void testHashCodeAndEqualsForNonEmptyList() {
        BoundedListTest.testHashCodeAndEquals(Arrays.asList(1, 2, 3, 4, 5, 6, 7));
    }

    @Test
    public void testSet() {
        ArrayList<Integer> underlying = new ArrayList<Integer>(Arrays.asList(1, 2, 3));
        BoundedList list = new BoundedList(3, underlying);
        list.set(1, (Object)200);
        Assertions.assertEquals(Arrays.asList(1, 200, 3), (Object)list);
    }

    @Test
    public void testRemove() {
        ArrayList<String> underlying = new ArrayList<String>(Arrays.asList("a", "a", "c"));
        BoundedList list = new BoundedList(3, underlying);
        Assertions.assertEquals((int)0, (int)list.indexOf((Object)"a"));
        Assertions.assertEquals((int)1, (int)list.lastIndexOf((Object)"a"));
        list.remove((Object)"a");
        Assertions.assertEquals(Arrays.asList("a", "c"), (Object)list);
        list.remove(0);
        Assertions.assertEquals(Arrays.asList("c"), (Object)list);
    }

    @Test
    public void testClear() {
        ArrayList<String> underlying = new ArrayList<String>(Arrays.asList("a", "b", "c"));
        BoundedList list = new BoundedList(3, underlying);
        list.clear();
        Assertions.assertEquals(Arrays.asList(new Object[0]), (Object)list);
        Assertions.assertTrue((boolean)list.isEmpty());
    }

    @Test
    public void testGet() {
        BoundedList list = new BoundedList(3, Arrays.asList(1, 2, 3));
        Assertions.assertEquals((int)2, (Integer)((Integer)list.get(1)));
    }

    @Test
    public void testToArray() {
        BoundedList list = new BoundedList(3, Arrays.asList(1, 2, 3));
        Assertions.assertArrayEquals((Object[])new Integer[]{1, 2, 3}, (Object[])list.toArray());
        Assertions.assertArrayEquals((Object[])new Integer[]{1, 2, 3}, (Object[])list.toArray((Object[])new Integer[3]));
    }

    @Test
    public void testAddAll() {
        ArrayList<String> underlying = new ArrayList<String>(Arrays.asList("a", "b", "c"));
        BoundedList list = new BoundedList(5, underlying);
        Assertions.assertEquals((Object)"Cannot add another 3 element(s) to the list because it would exceed the maximum length of 5", (Object)((BoundedListTooLongException)Assertions.assertThrows(BoundedListTooLongException.class, () -> list.addAll(Arrays.asList("d", "e", "f")))).getMessage());
        Assertions.assertEquals((Object)"Cannot add another 3 element(s) to the list because it would exceed the maximum length of 5", (Object)((BoundedListTooLongException)Assertions.assertThrows(BoundedListTooLongException.class, () -> list.addAll(0, Arrays.asList("d", "e", "f")))).getMessage());
        list.addAll(Arrays.asList("d", "e"));
        Assertions.assertEquals(Arrays.asList("a", "b", "c", "d", "e"), (Object)list);
    }

    @Test
    public void testIterator() {
        BoundedList list = new BoundedList(3, Arrays.asList(1, 2, 3));
        Assertions.assertEquals((int)1, (Integer)((Integer)list.iterator().next()));
        Assertions.assertEquals((int)1, (Integer)((Integer)list.listIterator().next()));
        Assertions.assertEquals((int)3, (Integer)((Integer)list.listIterator(2).next()));
        Assertions.assertFalse((boolean)list.listIterator(3).hasNext());
    }

    @Test
    public void testIteratorIsImmutable() {
        BoundedList list = new BoundedList(3, new ArrayList<Integer>(Arrays.asList(1, 2, 3)));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> list.iterator().remove());
        Assertions.assertThrows(UnsupportedOperationException.class, () -> list.listIterator().remove());
    }

    @Test
    public void testSubList() {
        BoundedList list = new BoundedList(3, new ArrayList<Integer>(Arrays.asList(1, 2, 3)));
        Assertions.assertEquals(Arrays.asList(2), (Object)list.subList(1, 2));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> {
            Integer cfr_ignored_0 = (Integer)list.subList(1, 2).remove(2);
        });
    }
}

