/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.events.web;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.servlet.http.HttpServletRequest;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.support.events.CasEventRepository;
import org.apereo.cas.support.events.dao.CasEvent;
import org.apereo.cas.web.BaseCasRestActuatorEndpoint;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Endpoint(id="events", enableByDefault=false)
public class CasEventsReportEndpoint
extends BaseCasRestActuatorEndpoint {
    public CasEventsReportEndpoint(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext) {
        super(casProperties, applicationContext);
    }

    @DeleteMapping
    @Operation(summary="Delete all CAS events in the event repository")
    public ResponseEntity deleteAllEvents() {
        CasEventRepository eventRepository = (CasEventRepository)this.applicationContext.getBean("casEventRepository", CasEventRepository.class);
        eventRepository.removeAll();
        return ResponseEntity.ok().build();
    }

    @GetMapping(produces={"application/json", "application/vnd.spring-boot.actuator.v2+json", "application/vnd.spring-boot.actuator.v3+json", "application/x-www-form-urlencoded", "application/vnd.cas.services+yaml"})
    @Operation(summary="Provide a report of CAS events in the event repository", parameters={@Parameter(name="limit", required=false, description="Limit the number of events to fetch")})
    public ResponseEntity events(@RequestParam(required=false, defaultValue="1000") int limit) throws Exception {
        CasEventRepository eventRepository = (CasEventRepository)this.applicationContext.getBean("casEventRepository", CasEventRepository.class);
        List results = eventRepository.load().sorted(Comparator.comparingLong(CasEvent::getTimestamp).reversed()).limit(limit).collect(Collectors.toList());
        return ResponseEntity.ok((Object)MAPPER.writeValueAsString(results));
    }

    @PostMapping(produces={"application/json", "application/vnd.spring-boot.actuator.v2+json", "application/vnd.spring-boot.actuator.v3+json", "application/x-www-form-urlencoded", "application/vnd.cas.services+yaml"})
    @Operation(summary="Upload CAS events and store them into the event repository")
    public ResponseEntity uploadEvents(HttpServletRequest request) throws Throwable {
        String contentType = request.getContentType();
        if (StringUtils.equalsAnyIgnoreCase((CharSequence)"application/octet-stream", (CharSequence[])new CharSequence[]{contentType})) {
            return this.importEventsAsStream(request);
        }
        return this.importSingleEvent(request);
    }

    private ResponseEntity<CasEvent> importSingleEvent(HttpServletRequest request) throws Throwable {
        String requestBody = IOUtils.toString((InputStream)request.getInputStream(), (Charset)StandardCharsets.UTF_8);
        CasEventRepository eventRepository = (CasEventRepository)this.applicationContext.getBean("casEventRepository", CasEventRepository.class);
        CasEvent casEvent = (CasEvent)MAPPER.readValue(requestBody, CasEvent.class);
        eventRepository.save(casEvent);
        return ResponseEntity.ok().build();
    }

    private ResponseEntity<CasEvent> importEventsAsStream(HttpServletRequest request) throws Throwable {
        CasEventRepository eventRepository = (CasEventRepository)this.applicationContext.getBean("casEventRepository", CasEventRepository.class);
        try (ByteArrayInputStream bais = new ByteArrayInputStream(IOUtils.toByteArray((InputStream)request.getInputStream()));
             ZipInputStream zipIn = new ZipInputStream(bais);){
            ZipEntry entry = zipIn.getNextEntry();
            while (entry != null) {
                if (!entry.isDirectory() && !entry.getName().contains("..") && entry.getName().endsWith(".json")) {
                    String requestBody = IOUtils.toString((InputStream)zipIn, (Charset)StandardCharsets.UTF_8);
                    CasEvent casEvent = (CasEvent)MAPPER.readValue(requestBody, CasEvent.class);
                    eventRepository.save(casEvent);
                }
                zipIn.closeEntry();
                entry = zipIn.getNextEntry();
            }
        }
        return ResponseEntity.ok().build();
    }
}

