/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.otp.web.flow;

import java.util.Collection;
import lombok.Generated;
import org.apereo.cas.authentication.OneTimeTokenAccount;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.otp.repository.credentials.OneTimeTokenCredentialRepository;
import org.apereo.cas.web.flow.actions.AbstractMultifactorAuthenticationAction;
import org.apereo.cas.web.flow.util.MultifactorAuthenticationWebflowUtils;
import org.apereo.cas.web.support.WebUtils;
import org.springframework.webflow.action.EventFactorySupport;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class OneTimeTokenAccountCheckRegistrationAction
extends AbstractMultifactorAuthenticationAction {
    private final OneTimeTokenCredentialRepository repository;

    protected Event doExecuteInternal(RequestContext requestContext) {
        Principal principal = this.resolvePrincipal(WebUtils.getAuthentication((RequestContext)requestContext).getPrincipal(), requestContext);
        String uid = principal.getId();
        Collection<? extends OneTimeTokenAccount> accounts = this.repository.get(uid);
        if (accounts == null || accounts.isEmpty()) {
            return new EventFactorySupport().event((Object)this, "register");
        }
        if (accounts.size() > 1) {
            MultifactorAuthenticationWebflowUtils.putOneTimeTokenAccounts((RequestContext)requestContext, accounts);
            return new EventFactorySupport().event((Object)this, "confirm");
        }
        MultifactorAuthenticationWebflowUtils.putOneTimeTokenAccount((RequestContext)requestContext, (OneTimeTokenAccount)accounts.iterator().next());
        return this.success();
    }

    @Generated
    public OneTimeTokenAccountCheckRegistrationAction(OneTimeTokenCredentialRepository repository) {
        this.repository = repository;
    }
}

