/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.cqengine.query.parser.cqn.support;

import com.googlecode.cqengine.query.parser.common.ValueParser;
import com.googlecode.cqengine.query.parser.cqn.support.ApacheSolrDataMathParser;
import com.googlecode.cqengine.query.parser.cqn.support.StringParser;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class DateMathParser
extends ValueParser<Date> {
    final TimeZone timeZone;
    final Locale locale;
    final Date now;

    public DateMathParser() {
        this(ApacheSolrDataMathParser.DEFAULT_MATH_TZ, ApacheSolrDataMathParser.DEFAULT_MATH_LOCALE, null);
    }

    public DateMathParser(Date now) {
        this(ApacheSolrDataMathParser.DEFAULT_MATH_TZ, ApacheSolrDataMathParser.DEFAULT_MATH_LOCALE, now);
    }

    public DateMathParser(TimeZone timeZone, Locale locale) {
        this(timeZone, locale, null);
    }

    public DateMathParser(TimeZone timeZone, Locale locale, Date now) {
        this.timeZone = timeZone;
        this.locale = locale;
        this.now = now;
    }

    @Override
    protected Date parse(Class<? extends Date> valueType, String stringValue) {
        try {
            ApacheSolrDataMathParser solrParser = new ApacheSolrDataMathParser();
            if (this.now != null) {
                solrParser.setNow(this.now);
            }
            return solrParser.parseMath(this.stripQuotes(stringValue));
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to parse date math expression: " + stringValue, e);
        }
    }

    protected String stripQuotes(String stringValue) {
        return StringParser.stripQuotes(stringValue);
    }
}

