/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.keymaster.rest.cxf.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.json.JsonMapper;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.syncope.common.keymaster.rest.api.service.ConfParamService;
import org.apache.syncope.core.logic.ConfParamLogic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ConfParamServiceImpl
implements ConfParamService {
    private static final long serialVersionUID = 3954522705963997651L;
    protected static final Logger LOG = LoggerFactory.getLogger(ConfParamService.class);
    private static final JsonMapper MAPPER = (JsonMapper)((JsonMapper.Builder)JsonMapper.builder().findAndAddModules()).build();
    protected final ConfParamLogic logic;

    public ConfParamServiceImpl(ConfParamLogic logic) {
        this.logic = logic;
    }

    public Map<String, Object> list() {
        return this.logic.list();
    }

    public Response get(String key) {
        return Response.ok((Object)this.logic.get(key)).build();
    }

    public void set(String key, InputStream value) {
        JsonNode valueNode = null;
        try {
            valueNode = MAPPER.readTree(value);
        }
        catch (IOException e) {
            LOG.error("Could not deserialize body as valid JSON", (Throwable)e);
        }
        this.logic.set(key, valueNode);
    }

    public void remove(String key) {
        this.logic.remove(key);
    }
}

