/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.keymaster.internal;

import java.util.List;
import org.apache.syncope.common.keymaster.client.api.DomainOps;
import org.apache.syncope.common.keymaster.client.api.KeymasterProperties;
import org.apache.syncope.common.keymaster.client.api.model.Domain;
import org.apache.syncope.common.lib.types.CipherAlgorithm;
import org.apache.syncope.core.logic.DomainLogic;
import org.apache.syncope.core.spring.security.AuthContextUtils;

public class SelfKeymasterInternalDomainOps
implements DomainOps {
    protected final DomainLogic logic;
    protected final KeymasterProperties props;

    public SelfKeymasterInternalDomainOps(DomainLogic logic, KeymasterProperties props) {
        this.logic = logic;
        this.props = props;
    }

    public List<Domain> list() {
        return (List)AuthContextUtils.callAs((String)"Master", (String)this.props.getUsername(), List.of(), () -> this.logic.list());
    }

    public Domain read(String key) {
        return (Domain)AuthContextUtils.callAs((String)"Master", (String)this.props.getUsername(), List.of(), () -> this.logic.read(key));
    }

    public void create(Domain domain) {
        AuthContextUtils.callAs((String)"Master", (String)this.props.getUsername(), List.of(), () -> {
            this.logic.create(domain);
            return null;
        });
    }

    public void deployed(String key) {
        AuthContextUtils.callAs((String)"Master", (String)this.props.getUsername(), List.of(), () -> {
            this.logic.deployed(key);
            return null;
        });
    }

    public void changeAdminPassword(String key, String password, CipherAlgorithm cipherAlgorithm) {
        AuthContextUtils.callAs((String)"Master", (String)this.props.getUsername(), List.of(), () -> {
            this.logic.changeAdminPassword(key, password, cipherAlgorithm);
            return null;
        });
    }

    public void adjustPoolSize(String key, int maxPoolSize, int minIdle) {
        AuthContextUtils.callAs((String)"Master", (String)this.props.getUsername(), List.of(), () -> {
            this.logic.adjustPoolSize(this.props.getUsername(), maxPoolSize, minIdle);
            return null;
        });
    }

    public void delete(String key) {
        AuthContextUtils.callAs((String)"Master", (String)this.props.getUsername(), List.of(), () -> {
            this.logic.delete(key);
            return null;
        });
    }
}

