/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.report;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.web.BaseCasRestActuatorEndpoint;
import org.apereo.cas.web.cookie.CasCookieBuilder;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Endpoint(id="sso", enableByDefault=false)
public class SingleSignOnSessionStatusEndpoint
extends BaseCasRestActuatorEndpoint {
    private final ObjectProvider<CasCookieBuilder> ticketGrantingTicketCookieGeneratorProvider;
    private final ObjectProvider<TicketRegistrySupport> ticketRegistrySupportProvider;

    public SingleSignOnSessionStatusEndpoint(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext, ObjectProvider<CasCookieBuilder> ticketGrantingTicketCookieGeneratorProvider, ObjectProvider<TicketRegistrySupport> ticketRegistrySupportProvider) {
        super(casProperties, applicationContext);
        this.ticketGrantingTicketCookieGeneratorProvider = ticketGrantingTicketCookieGeneratorProvider;
        this.ticketRegistrySupportProvider = ticketRegistrySupportProvider;
    }

    @GetMapping(produces={"application/json"})
    @Operation(summary="Get current status of single sign-on", parameters={@Parameter(name="tgc", required=false, description="The ticket-granting ticket cookie value"), @Parameter(name="request", required=false, description="The HTTP request")})
    public ResponseEntity<Map<?, ?>> ssoStatus(@RequestParam(name="tgc", required=false, defaultValue="") String tgc, HttpServletRequest request) {
        String tgtId;
        CasCookieBuilder ticketGrantingTicketCookieGenerator = (CasCookieBuilder)this.ticketGrantingTicketCookieGeneratorProvider.getObject();
        String string = tgtId = StringUtils.isNotBlank((CharSequence)tgc) ? ticketGrantingTicketCookieGenerator.getCasCookieValueManager().obtainCookieValue(tgc, request) : ticketGrantingTicketCookieGenerator.retrieveCookieValue(request);
        if (StringUtils.isBlank((CharSequence)tgtId)) {
            return ResponseEntity.badRequest().build();
        }
        TicketRegistrySupport ticketRegistrySupport = (TicketRegistrySupport)this.ticketRegistrySupportProvider.getObject();
        Authentication auth = ticketRegistrySupport.getAuthenticationFrom(tgtId);
        if (auth == null) {
            return ResponseEntity.badRequest().build();
        }
        Ticket ticketState = ticketRegistrySupport.getTicket(tgtId);
        Map body = CollectionUtils.wrap((String)"principal", (Object)auth.getPrincipal().getId(), (String)"authenticationDate", (Object)auth.getAuthenticationDate(), (String)"ticketGrantingTicketCreationTime", (Object)ticketState.getCreationTime(), (String)"ticketGrantingTicketPreviousTimeUsed", (Object)ticketState.getPreviousTimeUsed(), (String)"ticketGrantingTicketLastTimeUsed", (Object)ticketState.getLastTimeUsed());
        return ResponseEntity.ok((Object)body);
    }
}

