/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.report;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import jakarta.servlet.http.HttpServletRequest;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceProperty;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.services.util.RegisteredServiceJsonSerializer;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.CompressionUtils;
import org.apereo.cas.util.RandomUtils;
import org.apereo.cas.util.io.TemporaryFileSystemResource;
import org.apereo.cas.util.serialization.StringSerializer;
import org.apereo.cas.web.BaseCasRestActuatorEndpoint;
import org.jooq.lambda.Unchecked;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.core.io.WritableResource;
import org.springframework.http.ContentDisposition;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;

@Endpoint(id="registeredServices", enableByDefault=false)
public class RegisteredServicesEndpoint
extends BaseCasRestActuatorEndpoint {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(RegisteredServicesEndpoint.class);
    private final ObjectProvider<ServicesManager> servicesManager;
    private final ObjectProvider<ServiceFactory<WebApplicationService>> webApplicationServiceFactory;
    private final ObjectProvider<List<? extends StringSerializer<RegisteredService>>> registeredServiceSerializers;

    public RegisteredServicesEndpoint(CasConfigurationProperties casProperties, ObjectProvider<ServicesManager> servicesManager, ObjectProvider<ServiceFactory<WebApplicationService>> webApplicationServiceFactory, ObjectProvider<List<? extends StringSerializer<RegisteredService>>> registeredServiceSerializers, ObjectProvider<ConfigurableApplicationContext> applicationContext) {
        super(casProperties, (ConfigurableApplicationContext)applicationContext.getObject());
        this.servicesManager = servicesManager;
        this.webApplicationServiceFactory = webApplicationServiceFactory;
        this.registeredServiceSerializers = registeredServiceSerializers;
    }

    @Operation(summary="Handle and produce a list of services from registry")
    @GetMapping(produces={"application/json", "application/vnd.spring-boot.actuator.v2+json", "application/vnd.spring-boot.actuator.v3+json", "application/x-www-form-urlencoded", "application/vnd.cas.services+yaml"})
    public ResponseEntity<String> handle() throws Exception {
        return ResponseEntity.ok((Object)MAPPER.writeValueAsString(((ServicesManager)this.servicesManager.getObject()).load().stream().filter(arg_0 -> ((RegisteredServiceProperty.RegisteredServiceProperties)RegisteredServiceProperty.RegisteredServiceProperties.INTERNAL_SERVICE_DEFINITION).isNotAssignedTo(arg_0)).collect(Collectors.toList())));
    }

    @Operation(summary="Fetch service either by numeric id or service id pattern")
    @GetMapping(path={"{id}"}, produces={"application/json", "application/vnd.spring-boot.actuator.v2+json", "application/vnd.spring-boot.actuator.v3+json", "application/x-www-form-urlencoded", "application/vnd.cas.services+yaml"})
    public ResponseEntity<String> fetchService(@PathVariable String id) throws Exception {
        RegisteredService service;
        RegisteredService registeredService = service = NumberUtils.isDigits((String)id) ? ((ServicesManager)this.servicesManager.getObject()).findServiceBy(Long.parseLong(id)) : ((ServicesManager)this.servicesManager.getObject()).findServiceBy(((ServiceFactory)this.webApplicationServiceFactory.getObject()).createService(id));
        if (service == null) {
            return ResponseEntity.notFound().build();
        }
        return ResponseEntity.ok((Object)MAPPER.writeValueAsString((Object)service));
    }

    @Operation(summary="Fetch services by their type")
    @GetMapping(path={"type/{type}"}, produces={"application/json", "application/vnd.spring-boot.actuator.v2+json", "application/vnd.spring-boot.actuator.v3+json", "application/x-www-form-urlencoded", "application/vnd.cas.services+yaml"})
    public ResponseEntity<String> fetchServicesByType(@PathVariable String type) throws Exception {
        Collection services = ((ServicesManager)this.servicesManager.getObject()).findServiceBy(registeredService -> registeredService.getClass().getSimpleName().equalsIgnoreCase(type));
        return ResponseEntity.ok((Object)MAPPER.writeValueAsString((Object)services));
    }

    @Operation(summary="Delete registered service by id")
    @DeleteMapping(path={"{id}"}, consumes={"application/octet-stream", "application/json", "application/vnd.spring-boot.actuator.v2+json", "application/vnd.spring-boot.actuator.v3+json", "application/vnd.cas.services+yaml"})
    public ResponseEntity<String> deleteService(@PathVariable String id) throws Exception {
        if (NumberUtils.isDigits((String)id)) {
            RegisteredService svc = ((ServicesManager)this.servicesManager.getObject()).findServiceBy(Long.parseLong(id));
            if (svc != null) {
                return ResponseEntity.ok((Object)MAPPER.writeValueAsString((Object)((ServicesManager)this.servicesManager.getObject()).delete(svc)));
            }
        } else {
            RegisteredService svc = ((ServicesManager)this.servicesManager.getObject()).findServiceBy(((ServiceFactory)this.webApplicationServiceFactory.getObject()).createService(id));
            if (svc != null) {
                return ResponseEntity.ok((Object)MAPPER.writeValueAsString((Object)((ServicesManager)this.servicesManager.getObject()).delete(svc)));
            }
        }
        LOGGER.warn("Could not locate service definition by id [{}]", (Object)id);
        return ResponseEntity.notFound().build();
    }

    @PostMapping(path={"/import"}, consumes={"application/octet-stream", "application/json", "application/vnd.spring-boot.actuator.v2+json", "application/vnd.spring-boot.actuator.v3+json", "application/vnd.cas.services+yaml"}, produces={"application/json", "application/vnd.spring-boot.actuator.v2+json", "application/vnd.spring-boot.actuator.v3+json", "application/vnd.cas.services+yaml"})
    @Operation(summary="Import registered services as a JSON document or a zip file")
    public ResponseEntity<RegisteredService> importService(HttpServletRequest request) throws Exception {
        String contentType = request.getContentType();
        if (StringUtils.equalsAnyIgnoreCase((CharSequence)"application/octet-stream", (CharSequence[])new CharSequence[]{contentType})) {
            return this.importServicesAsStream(request);
        }
        return this.importSingleService(request);
    }

    @GetMapping(path={"/export"}, produces={"application/octet-stream"})
    @ResponseBody
    @Operation(summary="Export registered services as a zip file")
    public ResponseEntity<Resource> export() {
        RegisteredServiceJsonSerializer serializer = new RegisteredServiceJsonSerializer(this.applicationContext);
        WritableResource resource = CompressionUtils.toZipFile((Stream)((ServicesManager)this.servicesManager.getObject()).stream(), (Function)Unchecked.function(entry -> {
            RegisteredService service = (RegisteredService)entry;
            String fileName = String.format("%s-%s", service.getName(), service.getId());
            File sourceFile = Files.createTempFile(fileName, ".json", new FileAttribute[0]).toFile();
            serializer.to(sourceFile, (Object)service);
            return sourceFile;
        }), (String)"services");
        HttpHeaders headers = new HttpHeaders();
        headers.setContentDisposition(ContentDisposition.attachment().filename(Objects.requireNonNull(resource.getFilename())).build());
        headers.put("Filename", List.of("services.zip"));
        return new ResponseEntity((Object)resource, (MultiValueMap)headers, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(path={"/export/{id}"}, produces={"application/octet-stream"})
    @ResponseBody
    @Operation(summary="Export registered services as a single JSON file", parameters={@Parameter(name="id", required=true, description="The id of the registered service to export", in=ParameterIn.PATH)})
    public ResponseEntity<Resource> export(@PathVariable(value="id") long id) throws Exception {
        RegisteredServiceJsonSerializer registeredServiceSerializer = new RegisteredServiceJsonSerializer(this.applicationContext);
        RegisteredService registeredService = ((ServicesManager)this.servicesManager.getObject()).findServiceBy(id);
        String fileName = String.format("%s-%s", registeredService.getName(), registeredService.getId());
        File serviceFile = Files.createTempFile(fileName, ".json", new FileAttribute[0]).toFile();
        registeredServiceSerializer.to(serviceFile, (Object)registeredService);
        HttpHeaders headers = new HttpHeaders();
        TemporaryFileSystemResource resource = new TemporaryFileSystemResource(serviceFile);
        headers.setContentDisposition(ContentDisposition.attachment().filename(Objects.requireNonNull(resource.getFilename())).build());
        headers.put("Filename", List.of(serviceFile.getName()));
        return new ResponseEntity((Object)resource, (MultiValueMap)headers, (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(consumes={"application/octet-stream", "application/json", "application/vnd.spring-boot.actuator.v2+json", "application/vnd.spring-boot.actuator.v3+json", "application/vnd.cas.services+yaml"}, produces={"application/json", "application/vnd.spring-boot.actuator.v2+json", "application/vnd.spring-boot.actuator.v3+json", "application/vnd.cas.services+yaml"})
    @ResponseBody
    @Operation(summary="Save registered service supplied in the request body", parameters={@Parameter(name="body", required=true, description="The request body to contain service definition")})
    public ResponseEntity saveService(@RequestBody String registeredServiceBody) {
        RegisteredServiceJsonSerializer registeredServiceSerializer = new RegisteredServiceJsonSerializer(this.applicationContext);
        RegisteredService registeredService = (RegisteredService)registeredServiceSerializer.from(registeredServiceBody);
        registeredService.setId((long)RandomUtils.nextInt());
        RegisteredService result = ((ServicesManager)this.servicesManager.getObject()).save(registeredService);
        return ResponseEntity.ok((Object)registeredServiceSerializer.toString((Object)result));
    }

    @PutMapping(consumes={"application/octet-stream", "application/json", "application/vnd.spring-boot.actuator.v2+json", "application/vnd.spring-boot.actuator.v3+json", "application/vnd.cas.services+yaml"}, produces={"application/json", "application/vnd.spring-boot.actuator.v2+json", "application/vnd.spring-boot.actuator.v3+json", "application/vnd.cas.services+yaml"})
    @ResponseBody
    @Operation(summary="Update registered service supplied in the request body", parameters={@Parameter(name="body", required=true, description="The request body to contain service definition")})
    public ResponseEntity updateService(@RequestBody String registeredServiceBody) {
        RegisteredServiceJsonSerializer registeredServiceSerializer = new RegisteredServiceJsonSerializer(this.applicationContext);
        RegisteredService registeredService = (RegisteredService)registeredServiceSerializer.from(registeredServiceBody);
        RegisteredService result = ((ServicesManager)this.servicesManager.getObject()).save(registeredService);
        return ResponseEntity.ok((Object)registeredServiceSerializer.toString((Object)result));
    }

    private ResponseEntity<RegisteredService> importSingleService(HttpServletRequest request) throws IOException {
        String requestBody = IOUtils.toString((InputStream)request.getInputStream(), (Charset)StandardCharsets.UTF_8);
        LOGGER.trace("Submitted registered service:\n[{}]", (Object)requestBody);
        if (StringUtils.isBlank((CharSequence)requestBody)) {
            LOGGER.warn("Could not extract registered services from request body");
            return ResponseEntity.badRequest().build();
        }
        return ((List)this.registeredServiceSerializers.getObject()).stream().map(serializer -> (RegisteredService)serializer.from(requestBody)).filter(Objects::nonNull).findFirst().map(service -> {
            LOGGER.trace("Storing registered service:\n[{}]", service);
            return ((ServicesManager)this.servicesManager.getObject()).save(service);
        }).map(service -> {
            HttpHeaders headers = new HttpHeaders();
            headers.put("id", CollectionUtils.wrapList((Object[])new String[]{String.valueOf(service.getId())}));
            return new ResponseEntity(service, (MultiValueMap)headers, (HttpStatusCode)HttpStatus.CREATED);
        }).orElseGet(() -> new ResponseEntity((HttpStatusCode)HttpStatus.BAD_REQUEST));
    }

    private ResponseEntity<RegisteredService> importServicesAsStream(HttpServletRequest request) throws IOException {
        Stream<Object> servicesToImport = Stream.empty();
        try (ByteArrayInputStream bais = new ByteArrayInputStream(IOUtils.toByteArray((InputStream)request.getInputStream()));
             ZipInputStream zipIn = new ZipInputStream(bais);){
            ZipEntry entry = zipIn.getNextEntry();
            while (entry != null) {
                if (!entry.isDirectory() && !entry.getName().contains("..") && entry.getName().endsWith(".json")) {
                    String requestBody = IOUtils.toString((InputStream)zipIn, (Charset)StandardCharsets.UTF_8);
                    servicesToImport = Stream.concat(servicesToImport, ((List)this.registeredServiceSerializers.getObject()).stream().map(serializer -> (RegisteredService)serializer.from(requestBody)).filter(Objects::nonNull));
                }
                zipIn.closeEntry();
                entry = zipIn.getNextEntry();
            }
        }
        ((ServicesManager)this.servicesManager.getObject()).save(servicesToImport);
        return ResponseEntity.ok().build();
    }
}

