/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.report;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.audit.AuditableContext;
import org.apereo.cas.audit.AuditableExecution;
import org.apereo.cas.audit.AuditableExecutionResult;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationException;
import org.apereo.cas.authentication.AuthenticationResult;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.DefaultAuthenticationBuilder;
import org.apereo.cas.authentication.credential.BasicIdentifiableCredential;
import org.apereo.cas.authentication.credential.UsernamePasswordCredential;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAccessStrategyUtils;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.web.BaseCasRestActuatorEndpoint;
import org.apereo.cas.web.support.ArgumentExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;

@Endpoint(id="serviceAccess", enableByDefault=false)
public class RegisteredServiceAccessEndpoint
extends BaseCasRestActuatorEndpoint {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(RegisteredServiceAccessEndpoint.class);
    private final ObjectProvider<ServicesManager> servicesManager;
    private final ObjectProvider<AuthenticationServiceSelectionPlan> authenticationServiceSelectionPlan;
    private final ObjectProvider<ArgumentExtractor> argumentExtractor;
    private final ObjectProvider<AuditableExecution> registeredServiceAccessStrategyEnforcer;
    private final ObjectProvider<AuthenticationSystemSupport> authenticationSystemSupport;
    private final ObjectProvider<PrincipalResolver> principalResolver;
    private final ObjectProvider<PrincipalFactory> principalFactory;

    public RegisteredServiceAccessEndpoint(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext, ObjectProvider<ServicesManager> servicesManager, ObjectProvider<AuthenticationServiceSelectionPlan> authenticationServiceSelectionPlan, ObjectProvider<ArgumentExtractor> argumentExtractor, ObjectProvider<AuditableExecution> registeredServiceAccessStrategyEnforcer, ObjectProvider<AuthenticationSystemSupport> authenticationSystemSupport, ObjectProvider<PrincipalResolver> principalResolver, ObjectProvider<PrincipalFactory> principalFactory) {
        super(casProperties, applicationContext);
        this.authenticationServiceSelectionPlan = authenticationServiceSelectionPlan;
        this.servicesManager = servicesManager;
        this.argumentExtractor = argumentExtractor;
        this.registeredServiceAccessStrategyEnforcer = registeredServiceAccessStrategyEnforcer;
        this.authenticationSystemSupport = authenticationSystemSupport;
        this.principalResolver = principalResolver;
        this.principalFactory = principalFactory;
    }

    @PostMapping(consumes={"application/x-www-form-urlencoded", "application/json"}, produces={"application/json", "application/vnd.spring-boot.actuator.v2+json", "application/vnd.spring-boot.actuator.v3+json", "application/vnd.cas.services+yaml"})
    @Operation(summary="Verify if service access can be granted to the user", parameters={@Parameter(name="username", required=true, in=ParameterIn.QUERY, description="The username to authenticate"), @Parameter(name="password", required=false, in=ParameterIn.QUERY, description="The password to authenticate the user if necessary"), @Parameter(name="service", required=false, in=ParameterIn.QUERY, description="The service to authorize access to"), @Parameter(name="client_id", required=false, in=ParameterIn.QUERY, description="The application client id for OAuth or OpenID Connect"), @Parameter(name="entityId", required=false, in=ParameterIn.QUERY, description="The entity id for SAML2 service providers")})
    public ResponseEntity authorize(HttpServletRequest request) {
        try {
            Service service = ((AuthenticationServiceSelectionPlan)this.authenticationServiceSelectionPlan.getObject()).resolveService((Service)((ArgumentExtractor)this.argumentExtractor.getObject()).extractService(request));
            RegisteredService registeredService = ((ServicesManager)this.servicesManager.getObject()).findServiceBy(service);
            RegisteredServiceAccessStrategyUtils.ensureServiceAccessIsAllowed((Service)service, (RegisteredService)registeredService);
            Authentication authentication = this.buildAuthentication(request.getParameter("username"), request.getParameter("password"), service);
            AuditableContext accessRequest = AuditableContext.builder().service(service).authentication(authentication).registeredService(registeredService).build();
            AuditableExecutionResult accessResult = ((AuditableExecution)this.registeredServiceAccessStrategyEnforcer.getObject()).execute(accessRequest);
            return accessResult.isExecutionFailure() ? ResponseEntity.status((HttpStatusCode)HttpStatus.FORBIDDEN).body((Object)"Access to %s is denied".formatted(service.getId())) : ResponseEntity.ok(Map.of("registeredService", registeredService, "authentication", authentication, "service", service));
        }
        catch (AuthenticationException e) {
            LoggingUtils.warn((Logger)LOGGER, (Throwable)e);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).build();
        }
        catch (Throwable e) {
            LoggingUtils.warn((Logger)LOGGER, (Throwable)e);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.FORBIDDEN).body((Object)e.getMessage());
        }
    }

    private Authentication buildAuthentication(String username, String password, Service selectedService) throws Throwable {
        if (StringUtils.isNotBlank((CharSequence)password)) {
            UsernamePasswordCredential credential = new UsernamePasswordCredential(username, password);
            AuthenticationResult result = ((AuthenticationSystemSupport)this.authenticationSystemSupport.getObject()).finalizeAuthenticationTransaction(selectedService, new Credential[]{credential});
            return result.getAuthentication();
        }
        Principal principal = ((PrincipalResolver)this.principalResolver.getObject()).resolve((Credential)new BasicIdentifiableCredential(username), Optional.of(((PrincipalFactory)this.principalFactory.getObject()).createPrincipal(username)), Optional.empty(), Optional.of(selectedService));
        return DefaultAuthenticationBuilder.newInstance().setPrincipal(principal).build();
    }
}

