/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.report;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlan;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.web.BaseCasActuatorEndpoint;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.annotation.Selector;

@Endpoint(id="authenticationHandlers", enableByDefault=false)
public class RegisteredAuthenticationHandlersEndpoint
extends BaseCasActuatorEndpoint {
    private final ObjectProvider<AuthenticationEventExecutionPlan> authenticationEventExecutionPlan;

    public RegisteredAuthenticationHandlersEndpoint(CasConfigurationProperties casProperties, ObjectProvider<AuthenticationEventExecutionPlan> authenticationEventExecutionPlan) {
        super(casProperties);
        this.authenticationEventExecutionPlan = authenticationEventExecutionPlan;
    }

    @ReadOperation(produces={"application/vnd.spring-boot.actuator.v2+json", "application/vnd.cas.services+yaml", "application/json"})
    @Operation(summary="Get collection of available authentication handlers")
    public Collection<AuthenticationHandlerDetails> handle() {
        return ((AuthenticationEventExecutionPlan)this.authenticationEventExecutionPlan.getObject()).getAuthenticationHandlers().stream().map(RegisteredAuthenticationHandlersEndpoint::buildHandlerDetails).sorted(Comparator.comparing(AuthenticationHandlerDetails::getOrder)).collect(Collectors.toList());
    }

    @Operation(summary="Get available authentication handler by name", parameters={@Parameter(name="name", required=true, description="The handler name")})
    @ReadOperation(produces={"application/json", "application/vnd.spring-boot.actuator.v2+json", "application/vnd.cas.services+yaml"})
    public AuthenticationHandlerDetails fetchAuthnHandler(@Selector String name) {
        return ((AuthenticationEventExecutionPlan)this.authenticationEventExecutionPlan.getObject()).getAuthenticationHandlers().stream().filter(authnHandler -> authnHandler.getName().equalsIgnoreCase(name)).findFirst().map(RegisteredAuthenticationHandlersEndpoint::buildHandlerDetails).orElse(null);
    }

    private static AuthenticationHandlerDetails buildHandlerDetails(AuthenticationHandler handler) {
        return ((AuthenticationHandlerDetails.AuthenticationHandlerDetailsBuilder)((AuthenticationHandlerDetails.AuthenticationHandlerDetailsBuilder)((AuthenticationHandlerDetails.AuthenticationHandlerDetailsBuilder)((AuthenticationHandlerDetails.AuthenticationHandlerDetailsBuilder)AuthenticationHandlerDetails.builder().name(handler.getName())).type(handler.getClass().getName())).order(handler.getOrder())).state(handler.getState().name())).build();
    }

    public static final class AuthenticationHandlerDetails
    implements Serializable {
        private static final long serialVersionUID = 6755362844006190415L;
        private final String name;
        private final String type;
        private final Integer order;
        private final String state;

        @Generated
        protected AuthenticationHandlerDetails(AuthenticationHandlerDetailsBuilder<?, ?> b) {
            this.name = b.name;
            this.type = b.type;
            this.order = b.order;
            this.state = b.state;
        }

        @Generated
        public static AuthenticationHandlerDetailsBuilder<?, ?> builder() {
            return new AuthenticationHandlerDetailsBuilderImpl();
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public Integer getOrder() {
            return this.order;
        }

        @Generated
        public String getState() {
            return this.state;
        }

        @Generated
        public static abstract class AuthenticationHandlerDetailsBuilder<C extends AuthenticationHandlerDetails, B extends AuthenticationHandlerDetailsBuilder<C, B>> {
            @Generated
            private String name;
            @Generated
            private String type;
            @Generated
            private Integer order;
            @Generated
            private String state;

            @Generated
            public B name(String name) {
                this.name = name;
                return this.self();
            }

            @Generated
            public B type(String type) {
                this.type = type;
                return this.self();
            }

            @Generated
            public B order(Integer order) {
                this.order = order;
                return this.self();
            }

            @Generated
            public B state(String state) {
                this.state = state;
                return this.self();
            }

            @Generated
            protected abstract B self();

            @Generated
            public abstract C build();

            @Generated
            public String toString() {
                return "RegisteredAuthenticationHandlersEndpoint.AuthenticationHandlerDetails.AuthenticationHandlerDetailsBuilder(name=" + this.name + ", type=" + this.type + ", order=" + this.order + ", state=" + this.state + ")";
            }
        }

        @Generated
        private static final class AuthenticationHandlerDetailsBuilderImpl
        extends AuthenticationHandlerDetailsBuilder<AuthenticationHandlerDetails, AuthenticationHandlerDetailsBuilderImpl> {
            @Generated
            private AuthenticationHandlerDetailsBuilderImpl() {
            }

            @Override
            @Generated
            protected AuthenticationHandlerDetailsBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public AuthenticationHandlerDetails build() {
                return new AuthenticationHandlerDetails(this);
            }
        }
    }
}

