/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.report;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import java.util.HashMap;
import java.util.Map;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.credential.BasicIdentifiableCredential;
import org.apereo.cas.authentication.principal.NullPrincipal;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.web.BaseCasActuatorEndpoint;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.annotation.Selector;

@Endpoint(id="resolveAttributes", enableByDefault=false)
public class CasResolveAttributesReportEndpoint
extends BaseCasActuatorEndpoint {
    private final ObjectProvider<PrincipalResolver> defaultPrincipalResolver;

    public CasResolveAttributesReportEndpoint(CasConfigurationProperties casProperties, ObjectProvider<PrincipalResolver> defaultPrincipalResolver) {
        super(casProperties);
        this.defaultPrincipalResolver = defaultPrincipalResolver;
    }

    @ReadOperation
    @Operation(summary="Resolve principal attributes for user", parameters={@Parameter(name="username", required=true, in=ParameterIn.PATH, description="The username to resolve attributes for")})
    public Map<String, Object> resolvePrincipalAttributes(@Selector String username) throws Throwable {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Principal principal = ((PrincipalResolver)this.defaultPrincipalResolver.getObject()).resolve((Credential)new BasicIdentifiableCredential(username));
        if (!(principal instanceof NullPrincipal)) {
            map.put("uid", principal.getId());
            map.put("attributes", principal.getAttributes());
        }
        return map;
    }
}

