/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.report;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationBuilder;
import org.apereo.cas.authentication.AuthenticationResult;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.DefaultAuthenticationBuilder;
import org.apereo.cas.authentication.credential.BasicIdentifiableCredential;
import org.apereo.cas.authentication.credential.UsernamePasswordCredential;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAccessStrategyUtils;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicyContext;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.validation.Assertion;
import org.apereo.cas.validation.DefaultAssertionBuilder;
import org.apereo.cas.validation.ImmutableAssertion;
import org.apereo.cas.web.BaseCasActuatorEndpoint;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.WriteOperation;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.lang.Nullable;

@Endpoint(id="releaseAttributes", enableByDefault=false)
public class CasReleaseAttributesReportEndpoint
extends BaseCasActuatorEndpoint {
    private final ObjectProvider<ServicesManager> servicesManager;
    private final ObjectProvider<AuthenticationSystemSupport> authenticationSystemSupport;
    private final ObjectProvider<ServiceFactory<WebApplicationService>> serviceFactory;
    private final ObjectProvider<PrincipalFactory> principalFactory;
    private final ObjectProvider<PrincipalResolver> principalResolver;
    private final ConfigurableApplicationContext applicationContext;

    public CasReleaseAttributesReportEndpoint(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext, ObjectProvider<ServicesManager> servicesManager, ObjectProvider<AuthenticationSystemSupport> authenticationSystemSupport, ObjectProvider<ServiceFactory<WebApplicationService>> serviceFactory, ObjectProvider<PrincipalFactory> principalFactory, ObjectProvider<PrincipalResolver> principalResolver) {
        super(casProperties);
        this.applicationContext = applicationContext;
        this.servicesManager = servicesManager;
        this.authenticationSystemSupport = authenticationSystemSupport;
        this.serviceFactory = serviceFactory;
        this.principalFactory = principalFactory;
        this.principalResolver = principalResolver;
    }

    protected Map<String, Object> releasePrincipalAttributes(String username, @Nullable String password, String service) throws Throwable {
        WebApplicationService selectedService = (WebApplicationService)((ServiceFactory)this.serviceFactory.getObject()).createService(service);
        RegisteredService registeredService = NumberUtils.isCreatable((String)service) ? ((ServicesManager)this.servicesManager.getObject()).findServiceBy(Long.parseLong(service)) : ((ServicesManager)this.servicesManager.getObject()).findServiceBy((Service)selectedService);
        RegisteredServiceAccessStrategyUtils.ensureServiceAccessIsAllowed((Service)selectedService, (RegisteredService)registeredService);
        Authentication authentication = this.buildAuthentication(username, password, selectedService);
        RegisteredServiceAttributeReleasePolicyContext context = RegisteredServiceAttributeReleasePolicyContext.builder().registeredService(registeredService).applicationContext((ApplicationContext)this.applicationContext).service((Service)selectedService).principal(authentication.getPrincipal()).build();
        Map attributesToRelease = registeredService.getAttributeReleasePolicy().getAttributes(context);
        AuthenticationBuilder builder = DefaultAuthenticationBuilder.of((ApplicationContext)this.applicationContext, (Principal)authentication.getPrincipal(), (PrincipalFactory)((PrincipalFactory)this.principalFactory.getObject()), (Map)attributesToRelease, (Service)selectedService, (RegisteredService)registeredService, (Authentication)authentication);
        Authentication finalAuthentication = builder.build();
        Assertion assertion = DefaultAssertionBuilder.builder().primaryAuthentication(finalAuthentication).service((Service)selectedService).authentications(CollectionUtils.wrap((Object)finalAuthentication)).registeredService(registeredService).build().assemble();
        LinkedHashMap<String, Object> resValidation = new LinkedHashMap<String, Object>();
        resValidation.put("assertion", assertion);
        resValidation.put("service", selectedService);
        resValidation.put("registeredService", registeredService);
        return resValidation;
    }

    private Authentication buildAuthentication(String username, String password, WebApplicationService selectedService) throws Throwable {
        if (StringUtils.isNotBlank((CharSequence)password)) {
            UsernamePasswordCredential credential = new UsernamePasswordCredential(username, password);
            AuthenticationResult result = ((AuthenticationSystemSupport)this.authenticationSystemSupport.getObject()).finalizeAuthenticationTransaction((Service)selectedService, new Credential[]{credential});
            return result.getAuthentication();
        }
        Principal principal = ((PrincipalResolver)this.principalResolver.getObject()).resolve((Credential)new BasicIdentifiableCredential(username), Optional.of(((PrincipalFactory)this.principalFactory.getObject()).createPrincipal(username)), Optional.empty(), Optional.of(selectedService));
        return DefaultAuthenticationBuilder.newInstance().setPrincipal(principal).build();
    }

    @WriteOperation
    @Operation(summary="Get collection of released attributes for the user and application", parameters={@Parameter(name="username", required=true, description="The username to authenticate"), @Parameter(name="password", required=false, description="The password to authenticate"), @Parameter(name="service", required=true, description="May be the service id or its numeric identifier")})
    public Map<String, Object> releaseAttributes(String username, @Nullable String password, String service) throws Throwable {
        Map<String, Object> map = this.releasePrincipalAttributes(username, password, service);
        ImmutableAssertion assertion = (ImmutableAssertion)map.get("assertion");
        return Map.of("username", username, "attributes", assertion.getPrimaryAuthentication().getPrincipal().getAttributes());
    }
}

