/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.report;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.web.BaseCasRestActuatorEndpoint;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

@Endpoint(id="casConfig", enableByDefault=false)
public class CasConfigurationEndpoint
extends BaseCasRestActuatorEndpoint {
    private final CipherExecutor<String, String> casConfigurationCipherExecutor;

    public CasConfigurationEndpoint(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext, CipherExecutor<String, String> casConfigurationCipherExecutor) {
        super(casProperties, applicationContext);
        this.casConfigurationCipherExecutor = casConfigurationCipherExecutor;
    }

    @PostMapping(value={"/encrypt"}, produces={"text/plain"}, consumes={"text/plain"})
    @Operation(summary="Encrypt configuration value", parameters={@Parameter(name="value", required=true, description="The value to encrypt")})
    public ResponseEntity<String> encrypt(@RequestBody String value) {
        return ResponseEntity.ok((Object)((String)this.casConfigurationCipherExecutor.encode((Object)value)));
    }

    @PostMapping(value={"/decrypt"}, produces={"text/plain"}, consumes={"text/plain"})
    @Operation(summary="Decrypt configuration value", parameters={@Parameter(name="value", required=true, description="The value to decrypt")})
    public ResponseEntity<String> decrypt(@RequestBody String value) {
        return ResponseEntity.ok((Object)((String)this.casConfigurationCipherExecutor.decode((Object)value)));
    }
}

