/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.view.json;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.SerializationFeature;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.ProtocolAttributeEncoder;
import org.apereo.cas.authentication.attribute.AttributeDefinition;
import org.apereo.cas.authentication.attribute.AttributeDefinitionStore;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.validation.AuthenticationAttributeReleasePolicy;
import org.apereo.cas.validation.CasProtocolAttributesRenderer;
import org.apereo.cas.web.view.Cas30ResponseView;
import org.apereo.cas.web.view.json.CasJsonServiceResponse;
import org.apereo.cas.web.view.json.CasJsonServiceResponseAuthenticationFailure;
import org.apereo.cas.web.view.json.CasJsonServiceResponseAuthenticationSuccess;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.json.MappingJackson2JsonView;

public class Cas30JsonResponseView
extends Cas30ResponseView {
    public static final String ATTRIBUTE_NAME_MODEL_SERVICE_RESPONSE = "serviceResponse";
    private static final MappingJackson2JsonView JSON_VIEW = new MappingJackson2JsonView();

    public Cas30JsonResponseView(boolean successResponse, ProtocolAttributeEncoder protocolAttributeEncoder, ServicesManager servicesManager, View delegatedView, AuthenticationAttributeReleasePolicy authenticationAttributeReleasePolicy, AuthenticationServiceSelectionPlan serviceSelectionStrategy, CasProtocolAttributesRenderer attributesRenderer, AttributeDefinitionStore attributeDefinitionStore) {
        super(successResponse, protocolAttributeEncoder, servicesManager, delegatedView, authenticationAttributeReleasePolicy, serviceSelectionStrategy, attributesRenderer, attributeDefinitionStore);
    }

    public Cas30JsonResponseView(boolean successResponse, ProtocolAttributeEncoder protocolAttributeEncoder, ServicesManager servicesManager, AuthenticationAttributeReleasePolicy authenticationAttributeReleasePolicy, AuthenticationServiceSelectionPlan serviceSelectionStrategy, CasProtocolAttributesRenderer attributesRenderer, AttributeDefinitionStore attributeDefinitionStore) {
        this(successResponse, protocolAttributeEncoder, servicesManager, (View)JSON_VIEW, authenticationAttributeReleasePolicy, serviceSelectionStrategy, attributesRenderer, attributeDefinitionStore);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void prepareMergedOutputModel(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CasJsonServiceResponse casResponse = new CasJsonServiceResponse();
        try {
            super.prepareMergedOutputModel(model, request, response);
            if (this.getAssertionFrom(model) != null) {
                CasJsonServiceResponseAuthenticationSuccess success = this.createAuthenticationSuccess(model);
                casResponse.setAuthenticationSuccess(success);
            } else {
                CasJsonServiceResponseAuthenticationFailure failure = this.createAuthenticationFailure(model);
                casResponse.setAuthenticationFailure(failure);
            }
        }
        catch (Exception e) {
            CasJsonServiceResponseAuthenticationFailure failure = this.createAuthenticationFailure(model);
            casResponse.setAuthenticationFailure(failure);
        }
        finally {
            HashMap<String, CasJsonServiceResponse> casModel = new HashMap<String, CasJsonServiceResponse>();
            casModel.put(ATTRIBUTE_NAME_MODEL_SERVICE_RESPONSE, casResponse);
            model.clear();
            model.putAll(casModel);
            if (LoggingUtils.isProtocolMessageLoggerEnabled()) {
                LoggingUtils.protocolMessage((String)"CAS Validation Response", (Object)JSON_VIEW.getObjectMapper().writeValueAsString(casModel));
            }
        }
    }

    protected CasJsonServiceResponseAuthenticationFailure createAuthenticationFailure(Map<String, Object> model) {
        CasJsonServiceResponseAuthenticationFailure failure = new CasJsonServiceResponseAuthenticationFailure();
        failure.setCode(this.getErrorCodeFrom(model));
        failure.setDescription(this.getErrorDescriptionFrom(model));
        return failure;
    }

    protected CasJsonServiceResponseAuthenticationSuccess createAuthenticationSuccess(Map<String, Object> model) {
        CasJsonServiceResponseAuthenticationSuccess success = new CasJsonServiceResponseAuthenticationSuccess();
        Map modelAttributes = this.getModelAttributes(model);
        Map<String, Object> processedAttributes = modelAttributes.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
            Optional<AttributeDefinition> attributeDefinition = this.attributeDefinitionStore.locateAttributeDefinition((String)entry.getKey()).or(() -> this.attributeDefinitionStore.locateAttributeDefinitionByName((String)entry.getKey()));
            return attributeDefinition.map(definition -> definition.toAttributeValue(entry.getValue())).orElseGet(entry::getValue);
        }));
        success.setAttributes(processedAttributes);
        Principal principal = this.getPrincipal(model);
        success.setUser(principal.getId());
        success.setProxyGrantingTicket(this.getProxyGrantingTicketIou(model));
        Collection chainedAuthentications = this.getChainedAuthentications(model);
        if (chainedAuthentications != null && !chainedAuthentications.isEmpty()) {
            List proxies = chainedAuthentications.stream().map(authn -> authn.getPrincipal().getId()).collect(Collectors.toList());
            success.setProxies(proxies);
        }
        return success;
    }

    @Generated
    public String toString() {
        return "Cas30JsonResponseView()";
    }

    static {
        JSON_VIEW.setPrettyPrint(true);
        JSON_VIEW.getObjectMapper().configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false).setSerializationInclusion(JsonInclude.Include.NON_NULL).findAndRegisterModules();
    }
}

