/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.v2;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.text.StringEscapeUtils;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.UnauthorizedServiceException;
import org.apereo.cas.ticket.AbstractTicketException;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.web.AbstractDelegateController;
import org.springframework.context.ApplicationContext;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;

public class ProxyController
extends AbstractDelegateController {
    private final View successView;
    private final View failureView;
    private final CentralAuthenticationService centralAuthenticationService;
    private final ServiceFactory webApplicationServiceFactory;
    private final ApplicationContext context;
    private final CasConfigurationProperties properties;

    public boolean canHandle(HttpServletRequest request, HttpServletResponse response) {
        String proxyGrantingTicket = request.getParameter("pgt");
        Service targetService = this.getTargetService(request);
        return this.properties.getSso().isProxyAuthnEnabled() && targetService != null && StringUtils.hasText((String)proxyGrantingTicket);
    }

    @GetMapping(path={"/proxy"})
    public ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Throwable {
        String proxyGrantingTicket = request.getParameter("pgt");
        Service targetService = this.getTargetService(request);
        if (!StringUtils.hasText((String)proxyGrantingTicket) || targetService == null) {
            return this.generateErrorView("INVALID_REQUEST_PROXY", null, request);
        }
        try {
            Ticket proxyTicket = this.centralAuthenticationService.grantProxyTicket(proxyGrantingTicket, targetService);
            Map model = CollectionUtils.wrap((String)"ticket", (Object)proxyTicket.getId());
            return new ModelAndView(this.successView, model);
        }
        catch (AbstractTicketException e) {
            return this.generateErrorView(e.getCode(), new Object[]{proxyGrantingTicket}, request);
        }
        catch (UnauthorizedServiceException e) {
            return this.generateErrorView("UNAUTHORIZED_SERVICE_PROXY", new Object[]{targetService}, request);
        }
    }

    private Service getTargetService(HttpServletRequest request) {
        return this.webApplicationServiceFactory.createService(request);
    }

    private ModelAndView generateErrorView(String code, Object[] args, HttpServletRequest request) {
        ModelAndView modelAndView = new ModelAndView(this.failureView);
        modelAndView.addObject("code", (Object)StringEscapeUtils.escapeHtml4((String)code));
        String desc = StringEscapeUtils.escapeHtml4((String)this.context.getMessage(code, args, code, request.getLocale()));
        modelAndView.addObject("description", (Object)desc);
        return modelAndView;
    }

    @Generated
    public View getSuccessView() {
        return this.successView;
    }

    @Generated
    public View getFailureView() {
        return this.failureView;
    }

    @Generated
    public CentralAuthenticationService getCentralAuthenticationService() {
        return this.centralAuthenticationService;
    }

    @Generated
    public ServiceFactory getWebApplicationServiceFactory() {
        return this.webApplicationServiceFactory;
    }

    @Generated
    public ApplicationContext getContext() {
        return this.context;
    }

    @Generated
    public CasConfigurationProperties getProperties() {
        return this.properties;
    }

    @Generated
    public ProxyController(View successView, View failureView, CentralAuthenticationService centralAuthenticationService, ServiceFactory webApplicationServiceFactory, ApplicationContext context, CasConfigurationProperties properties) {
        this.successView = successView;
        this.failureView = failureView;
        this.centralAuthenticationService = centralAuthenticationService;
        this.webApplicationServiceFactory = webApplicationServiceFactory;
        this.context = context;
        this.properties = properties;
    }
}

