/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.entity.user;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.persistence.UniqueConstraint;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.StateManager;
import org.apache.syncope.core.persistence.api.entity.MembershipType;
import org.apache.syncope.core.persistence.api.entity.RelationshipType;
import org.apache.syncope.core.persistence.api.entity.anyobject.AnyObject;
import org.apache.syncope.core.persistence.api.entity.user.URelationship;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.persistence.jpa.entity.AbstractGeneratedKeyEntity;
import org.apache.syncope.core.persistence.jpa.entity.JPARelationshipType;
import org.apache.syncope.core.persistence.jpa.entity.anyobject.JPAAnyObject;
import org.apache.syncope.core.persistence.jpa.entity.user.JPAUser;

@Entity
@Table(name="URelationship", uniqueConstraints={@UniqueConstraint(columnNames={"type_id", "user_id", "anyObject_id"})})
public class JPAURelationship
extends AbstractGeneratedKeyEntity
implements URelationship,
PersistenceCapable {
    private static final long serialVersionUID = 2778494939240083204L;
    public static final String TABLE = "URelationship";
    @ManyToOne(fetch=FetchType.EAGER, optional=false)
    private JPARelationshipType type;
    @ManyToOne
    @Column(name="user_id")
    private JPAUser leftEnd;
    @ManyToOne
    @Column(name="anyObject_id")
    private JPAAnyObject rightEnd;
    private static int pcInheritedFieldCount = AbstractGeneratedKeyEntity.pcGetManagedFieldCount();
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;

    public RelationshipType getType() {
        return JPAURelationship.pcGettype(this);
    }

    public void setType(RelationshipType type) {
        if (MembershipType.getInstance().getKey().equalsIgnoreCase(type.getKey())) {
            throw new IllegalArgumentException("This is not a membership");
        }
        this.checkType(type, JPARelationshipType.class);
        JPAURelationship.pcSettype(this, (JPARelationshipType)type);
    }

    public User getLeftEnd() {
        return JPAURelationship.pcGetleftEnd(this);
    }

    public void setLeftEnd(User leftEnd) {
        this.checkType(leftEnd, JPAUser.class);
        JPAURelationship.pcSetleftEnd(this, (JPAUser)leftEnd);
    }

    public AnyObject getRightEnd() {
        return JPAURelationship.pcGetrightEnd(this);
    }

    public void setRightEnd(AnyObject rightEnd) {
        this.checkType(rightEnd, JPAAnyObject.class);
        JPAURelationship.pcSetrightEnd(this, (JPAAnyObject)rightEnd);
    }

    @Override
    public int pcGetEnhancementContractVersion() {
        return 117245485;
    }

    static {
        pcPCSuperclass = AbstractGeneratedKeyEntity.class;
        pcFieldNames = new String[]{"leftEnd", "rightEnd", "type"};
        pcFieldTypes = new Class[]{JPAUser.class, JPAAnyObject.class, JPARelationshipType.class};
        pcFieldFlags = new byte[]{26, 26, 26};
        PCRegistry.register(JPAURelationship.class, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"JPAURelationship", (PersistenceCapable)new JPAURelationship());
    }

    @Override
    protected void pcClearFields() {
        super.pcClearFields();
        this.leftEnd = null;
        this.rightEnd = null;
        this.type = null;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        JPAURelationship jPAURelationship = new JPAURelationship();
        if (bl) {
            jPAURelationship.pcClearFields();
        }
        jPAURelationship.pcStateManager = stateManager;
        jPAURelationship.pcCopyKeyFieldsFromObjectId(object);
        return jPAURelationship;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        JPAURelationship jPAURelationship = new JPAURelationship();
        if (bl) {
            jPAURelationship.pcClearFields();
        }
        jPAURelationship.pcStateManager = stateManager;
        return jPAURelationship;
    }

    protected static int pcGetManagedFieldCount() {
        return 3 + AbstractGeneratedKeyEntity.pcGetManagedFieldCount();
    }

    @Override
    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcReplaceField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.leftEnd = (JPAUser)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.rightEnd = (JPAAnyObject)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.type = (JPARelationshipType)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcReplaceFields(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.pcReplaceField(nArray[i]);
        }
    }

    @Override
    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcProvideField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.leftEnd);
                return;
            }
            case 1: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.rightEnd);
                return;
            }
            case 2: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.type);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcProvideFields(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.pcProvideField(nArray[i]);
        }
    }

    protected void pcCopyField(JPAURelationship jPAURelationship, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcCopyField(jPAURelationship, n);
            return;
        }
        switch (n2) {
            case 0: {
                this.leftEnd = jPAURelationship.leftEnd;
                return;
            }
            case 1: {
                this.rightEnd = jPAURelationship.rightEnd;
                return;
            }
            case 2: {
                this.type = jPAURelationship.type;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcCopyFields(Object object, int[] nArray) {
        JPAURelationship jPAURelationship = (JPAURelationship)object;
        if (jPAURelationship.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        for (int i = 0; i < nArray.length; ++i) {
            this.pcCopyField(jPAURelationship, nArray[i]);
        }
    }

    @Override
    public Class pcGetIDOwningClass() {
        return JPAURelationship.class;
    }

    private static final JPAUser pcGetleftEnd(JPAURelationship jPAURelationship) {
        if (jPAURelationship.pcStateManager == null) {
            return jPAURelationship.leftEnd;
        }
        int n = pcInheritedFieldCount + 0;
        jPAURelationship.pcStateManager.accessingField(n);
        return jPAURelationship.leftEnd;
    }

    private static final void pcSetleftEnd(JPAURelationship jPAURelationship, JPAUser jPAUser) {
        if (jPAURelationship.pcStateManager == null) {
            jPAURelationship.leftEnd = jPAUser;
            return;
        }
        jPAURelationship.pcStateManager.settingObjectField((PersistenceCapable)jPAURelationship, pcInheritedFieldCount + 0, (Object)jPAURelationship.leftEnd, (Object)jPAUser, 0);
    }

    private static final JPAAnyObject pcGetrightEnd(JPAURelationship jPAURelationship) {
        if (jPAURelationship.pcStateManager == null) {
            return jPAURelationship.rightEnd;
        }
        int n = pcInheritedFieldCount + 1;
        jPAURelationship.pcStateManager.accessingField(n);
        return jPAURelationship.rightEnd;
    }

    private static final void pcSetrightEnd(JPAURelationship jPAURelationship, JPAAnyObject jPAAnyObject) {
        if (jPAURelationship.pcStateManager == null) {
            jPAURelationship.rightEnd = jPAAnyObject;
            return;
        }
        jPAURelationship.pcStateManager.settingObjectField((PersistenceCapable)jPAURelationship, pcInheritedFieldCount + 1, (Object)jPAURelationship.rightEnd, (Object)jPAAnyObject, 0);
    }

    private static final JPARelationshipType pcGettype(JPAURelationship jPAURelationship) {
        if (jPAURelationship.pcStateManager == null) {
            return jPAURelationship.type;
        }
        int n = pcInheritedFieldCount + 2;
        jPAURelationship.pcStateManager.accessingField(n);
        return jPAURelationship.type;
    }

    private static final void pcSettype(JPAURelationship jPAURelationship, JPARelationshipType jPARelationshipType) {
        if (jPAURelationship.pcStateManager == null) {
            jPAURelationship.type = jPARelationshipType;
            return;
        }
        jPAURelationship.pcStateManager.settingObjectField((PersistenceCapable)jPAURelationship, pcInheritedFieldCount + 2, (Object)jPAURelationship.type, (Object)jPARelationshipType, 0);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = this.pcSerializing();
        objectOutputStream.defaultWriteObject();
        if (bl) {
            this.pcSetDetachedState(null);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.pcSetDetachedState(PersistenceCapable.DESERIALIZED);
        objectInputStream.defaultReadObject();
    }
}

