/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.entity.user;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import jakarta.persistence.UniqueConstraint;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.StateManager;
import org.apache.syncope.common.keymaster.client.api.ConfParamOps;
import org.apache.syncope.common.lib.types.CipherAlgorithm;
import org.apache.syncope.core.persistence.api.entity.ExternalResource;
import org.apache.syncope.core.persistence.api.entity.Privilege;
import org.apache.syncope.core.persistence.api.entity.user.LAPlainAttr;
import org.apache.syncope.core.persistence.api.entity.user.LinkedAccount;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.persistence.jpa.entity.AbstractAttributable;
import org.apache.syncope.core.persistence.jpa.entity.AbstractGeneratedKeyEntity;
import org.apache.syncope.core.persistence.jpa.entity.JPAExternalResource;
import org.apache.syncope.core.persistence.jpa.entity.JPAPrivilege;
import org.apache.syncope.core.persistence.jpa.entity.user.JPAUser;
import org.apache.syncope.core.persistence.jpa.entity.user.JSONLAPlainAttr;
import org.apache.syncope.core.persistence.jpa.entity.user.JSONLinkedAccountListener;
import org.apache.syncope.core.spring.ApplicationContextProvider;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.apache.syncope.core.spring.security.Encryptor;

@Entity
@Table(name="LinkedAccount", uniqueConstraints={@UniqueConstraint(columnNames={"connObjectKeyValue", "resource_id"})})
@EntityListeners(value={JSONLinkedAccountListener.class})
public class JPALinkedAccount
extends AbstractAttributable<LAPlainAttr>
implements LinkedAccount {
    private static final long serialVersionUID = -5141654998687601522L;
    public static final String TABLE = "LinkedAccount";
    private static final Encryptor ENCRYPTOR = Encryptor.getInstance();
    @NotNull
    private String connObjectKeyValue;
    @ManyToOne(fetch=FetchType.EAGER)
    private JPAUser owner;
    @ManyToOne(fetch=FetchType.EAGER)
    private JPAExternalResource resource;
    private String username;
    @Enumerated(value=EnumType.STRING)
    private CipherAlgorithm cipherAlgorithm;
    @Column(nullable=true)
    private String password;
    private Boolean suspended = false;
    private String plainAttrs;
    @Transient
    private final List<JSONLAPlainAttr> plainAttrsList = new ArrayList<JSONLAPlainAttr>();
    @ManyToMany(fetch=FetchType.EAGER)
    @JoinTable(joinColumns={@JoinColumn(name="linked_account_id")}, inverseJoinColumns={@JoinColumn(name="privilege_id")}, uniqueConstraints={@UniqueConstraint(columnNames={"linked_account_id", "privilege_id"})})
    @Valid
    private Set<JPAPrivilege> privileges = new HashSet<JPAPrivilege>();
    private static int pcInheritedFieldCount = AbstractAttributable.pcGetManagedFieldCount();
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;

    public String getConnObjectKeyValue() {
        return JPALinkedAccount.pcGetconnObjectKeyValue(this);
    }

    public void setConnObjectKeyValue(String connObjectKeyValue) {
        JPALinkedAccount.pcSetconnObjectKeyValue(this, connObjectKeyValue);
    }

    public User getOwner() {
        return JPALinkedAccount.pcGetowner(this);
    }

    public void setOwner(User owner) {
        this.checkType(owner, JPAUser.class);
        JPALinkedAccount.pcSetowner(this, (JPAUser)owner);
    }

    public ExternalResource getResource() {
        return JPALinkedAccount.pcGetresource(this);
    }

    public void setResource(ExternalResource resource) {
        this.checkType(resource, JPAExternalResource.class);
        JPALinkedAccount.pcSetresource(this, (JPAExternalResource)resource);
    }

    public String getUsername() {
        return JPALinkedAccount.pcGetusername(this);
    }

    public void setUsername(String username) {
        JPALinkedAccount.pcSetusername(this, username);
    }

    public CipherAlgorithm getCipherAlgorithm() {
        return JPALinkedAccount.pcGetcipherAlgorithm(this);
    }

    public void setCipherAlgorithm(CipherAlgorithm cipherAlgorithm) {
        if (JPALinkedAccount.pcGetcipherAlgorithm(this) != null && cipherAlgorithm != null) {
            throw new IllegalArgumentException("Cannot override existing cipher algorithm");
        }
        JPALinkedAccount.pcSetcipherAlgorithm(this, cipherAlgorithm);
    }

    public boolean canDecodeSecrets() {
        return JPALinkedAccount.pcGetcipherAlgorithm(this) != null && JPALinkedAccount.pcGetcipherAlgorithm(this).isInvertible();
    }

    public String getPassword() {
        return JPALinkedAccount.pcGetpassword(this);
    }

    public void setEncodedPassword(String password, CipherAlgorithm cipherAlgoritm) {
        JPALinkedAccount.pcSetpassword(this, password);
        JPALinkedAccount.pcSetcipherAlgorithm(this, cipherAlgoritm);
    }

    public void setPassword(String password) {
        try {
            JPALinkedAccount.pcSetpassword(this, ENCRYPTOR.encode(password, JPALinkedAccount.pcGetcipherAlgorithm(this) == null ? CipherAlgorithm.valueOf((String)((String)((ConfParamOps)ApplicationContextProvider.getBeanFactory().getBean(ConfParamOps.class)).get(AuthContextUtils.getDomain(), "password.cipher.algorithm", (Object)CipherAlgorithm.AES.name(), String.class))) : JPALinkedAccount.pcGetcipherAlgorithm(this)));
        }
        catch (Exception e) {
            LOG.error("Could not encode password", (Throwable)e);
            JPALinkedAccount.pcSetpassword(this, null);
        }
    }

    public void setSuspended(Boolean suspended) {
        JPALinkedAccount.pcSetsuspended(this, suspended);
    }

    public Boolean isSuspended() {
        return JPALinkedAccount.pcGetsuspended(this);
    }

    @Override
    public List<? extends LAPlainAttr> getPlainAttrsList() {
        return this.plainAttrsList;
    }

    @Override
    public String getPlainAttrsJSON() {
        return JPALinkedAccount.pcGetplainAttrs(this);
    }

    @Override
    public void setPlainAttrsJSON(String plainAttrs) {
        JPALinkedAccount.pcSetplainAttrs(this, plainAttrs);
    }

    public boolean add(LAPlainAttr attr) {
        this.checkType(attr, JSONLAPlainAttr.class);
        return this.plainAttrsList.add((JSONLAPlainAttr)attr);
    }

    public boolean remove(LAPlainAttr attr) {
        this.checkType(attr, JSONLAPlainAttr.class);
        return this.plainAttrsList.removeIf(jsonAttr -> jsonAttr.getSchemaKey().equals(attr.getSchema().getKey()));
    }

    public Optional<? extends LAPlainAttr> getPlainAttr(String plainSchema) {
        return this.plainAttrsList.stream().filter(attr -> plainSchema.equals(attr.getSchemaKey())).findFirst();
    }

    public List<? extends LAPlainAttr> getPlainAttrs() {
        return this.plainAttrsList.stream().toList();
    }

    public boolean add(Privilege privilege) {
        this.checkType(privilege, JPAPrivilege.class);
        return JPALinkedAccount.pcGetprivileges(this).add((JPAPrivilege)privilege);
    }

    public Set<? extends Privilege> getPrivileges() {
        return JPALinkedAccount.pcGetprivileges(this);
    }

    static {
        pcPCSuperclass = AbstractGeneratedKeyEntity.class;
        pcFieldNames = new String[]{"cipherAlgorithm", "connObjectKeyValue", "owner", "password", "plainAttrs", "privileges", "resource", "suspended", "username"};
        pcFieldTypes = new Class[]{CipherAlgorithm.class, String.class, JPAUser.class, String.class, String.class, Set.class, JPAExternalResource.class, Boolean.class, String.class};
        pcFieldFlags = new byte[]{26, 26, 26, 26, 26, 10, 26, 26, 26};
        PCRegistry.register(JPALinkedAccount.class, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"JPALinkedAccount", (PersistenceCapable)new JPALinkedAccount());
    }

    @Override
    public int pcGetEnhancementContractVersion() {
        return 117245485;
    }

    @Override
    protected void pcClearFields() {
        super.pcClearFields();
        this.cipherAlgorithm = null;
        this.connObjectKeyValue = null;
        this.owner = null;
        this.password = null;
        this.plainAttrs = null;
        this.privileges = null;
        this.resource = null;
        this.suspended = null;
        this.username = null;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        JPALinkedAccount jPALinkedAccount = new JPALinkedAccount();
        if (bl) {
            jPALinkedAccount.pcClearFields();
        }
        jPALinkedAccount.pcStateManager = stateManager;
        jPALinkedAccount.pcCopyKeyFieldsFromObjectId(object);
        return jPALinkedAccount;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        JPALinkedAccount jPALinkedAccount = new JPALinkedAccount();
        if (bl) {
            jPALinkedAccount.pcClearFields();
        }
        jPALinkedAccount.pcStateManager = stateManager;
        return jPALinkedAccount;
    }

    protected static int pcGetManagedFieldCount() {
        return 9 + AbstractGeneratedKeyEntity.pcGetManagedFieldCount();
    }

    @Override
    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcReplaceField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.cipherAlgorithm = (CipherAlgorithm)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.connObjectKeyValue = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.owner = (JPAUser)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.password = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 4: {
                this.plainAttrs = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 5: {
                this.privileges = (Set)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 6: {
                this.resource = (JPAExternalResource)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 7: {
                this.suspended = (Boolean)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 8: {
                this.username = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcReplaceFields(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.pcReplaceField(nArray[i]);
        }
    }

    @Override
    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcProvideField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.cipherAlgorithm);
                return;
            }
            case 1: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.connObjectKeyValue);
                return;
            }
            case 2: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.owner);
                return;
            }
            case 3: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.password);
                return;
            }
            case 4: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.plainAttrs);
                return;
            }
            case 5: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.privileges);
                return;
            }
            case 6: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.resource);
                return;
            }
            case 7: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.suspended);
                return;
            }
            case 8: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.username);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcProvideFields(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.pcProvideField(nArray[i]);
        }
    }

    protected void pcCopyField(JPALinkedAccount jPALinkedAccount, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcCopyField(jPALinkedAccount, n);
            return;
        }
        switch (n2) {
            case 0: {
                this.cipherAlgorithm = jPALinkedAccount.cipherAlgorithm;
                return;
            }
            case 1: {
                this.connObjectKeyValue = jPALinkedAccount.connObjectKeyValue;
                return;
            }
            case 2: {
                this.owner = jPALinkedAccount.owner;
                return;
            }
            case 3: {
                this.password = jPALinkedAccount.password;
                return;
            }
            case 4: {
                this.plainAttrs = jPALinkedAccount.plainAttrs;
                return;
            }
            case 5: {
                this.privileges = jPALinkedAccount.privileges;
                return;
            }
            case 6: {
                this.resource = jPALinkedAccount.resource;
                return;
            }
            case 7: {
                this.suspended = jPALinkedAccount.suspended;
                return;
            }
            case 8: {
                this.username = jPALinkedAccount.username;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcCopyFields(Object object, int[] nArray) {
        JPALinkedAccount jPALinkedAccount = (JPALinkedAccount)object;
        if (jPALinkedAccount.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        for (int i = 0; i < nArray.length; ++i) {
            this.pcCopyField(jPALinkedAccount, nArray[i]);
        }
    }

    @Override
    public Class pcGetIDOwningClass() {
        return JPALinkedAccount.class;
    }

    private static final CipherAlgorithm pcGetcipherAlgorithm(JPALinkedAccount jPALinkedAccount) {
        if (jPALinkedAccount.pcStateManager == null) {
            return jPALinkedAccount.cipherAlgorithm;
        }
        int n = pcInheritedFieldCount + 0;
        jPALinkedAccount.pcStateManager.accessingField(n);
        return jPALinkedAccount.cipherAlgorithm;
    }

    private static final void pcSetcipherAlgorithm(JPALinkedAccount jPALinkedAccount, CipherAlgorithm cipherAlgorithm) {
        if (jPALinkedAccount.pcStateManager == null) {
            jPALinkedAccount.cipherAlgorithm = cipherAlgorithm;
            return;
        }
        jPALinkedAccount.pcStateManager.settingObjectField((PersistenceCapable)jPALinkedAccount, pcInheritedFieldCount + 0, (Object)jPALinkedAccount.cipherAlgorithm, (Object)cipherAlgorithm, 0);
    }

    private static final String pcGetconnObjectKeyValue(JPALinkedAccount jPALinkedAccount) {
        if (jPALinkedAccount.pcStateManager == null) {
            return jPALinkedAccount.connObjectKeyValue;
        }
        int n = pcInheritedFieldCount + 1;
        jPALinkedAccount.pcStateManager.accessingField(n);
        return jPALinkedAccount.connObjectKeyValue;
    }

    private static final void pcSetconnObjectKeyValue(JPALinkedAccount jPALinkedAccount, String string) {
        if (jPALinkedAccount.pcStateManager == null) {
            jPALinkedAccount.connObjectKeyValue = string;
            return;
        }
        jPALinkedAccount.pcStateManager.settingStringField((PersistenceCapable)jPALinkedAccount, pcInheritedFieldCount + 1, jPALinkedAccount.connObjectKeyValue, string, 0);
    }

    private static final JPAUser pcGetowner(JPALinkedAccount jPALinkedAccount) {
        if (jPALinkedAccount.pcStateManager == null) {
            return jPALinkedAccount.owner;
        }
        int n = pcInheritedFieldCount + 2;
        jPALinkedAccount.pcStateManager.accessingField(n);
        return jPALinkedAccount.owner;
    }

    private static final void pcSetowner(JPALinkedAccount jPALinkedAccount, JPAUser jPAUser) {
        if (jPALinkedAccount.pcStateManager == null) {
            jPALinkedAccount.owner = jPAUser;
            return;
        }
        jPALinkedAccount.pcStateManager.settingObjectField((PersistenceCapable)jPALinkedAccount, pcInheritedFieldCount + 2, (Object)jPALinkedAccount.owner, (Object)jPAUser, 0);
    }

    private static final String pcGetpassword(JPALinkedAccount jPALinkedAccount) {
        if (jPALinkedAccount.pcStateManager == null) {
            return jPALinkedAccount.password;
        }
        int n = pcInheritedFieldCount + 3;
        jPALinkedAccount.pcStateManager.accessingField(n);
        return jPALinkedAccount.password;
    }

    private static final void pcSetpassword(JPALinkedAccount jPALinkedAccount, String string) {
        if (jPALinkedAccount.pcStateManager == null) {
            jPALinkedAccount.password = string;
            return;
        }
        jPALinkedAccount.pcStateManager.settingStringField((PersistenceCapable)jPALinkedAccount, pcInheritedFieldCount + 3, jPALinkedAccount.password, string, 0);
    }

    private static final String pcGetplainAttrs(JPALinkedAccount jPALinkedAccount) {
        if (jPALinkedAccount.pcStateManager == null) {
            return jPALinkedAccount.plainAttrs;
        }
        int n = pcInheritedFieldCount + 4;
        jPALinkedAccount.pcStateManager.accessingField(n);
        return jPALinkedAccount.plainAttrs;
    }

    private static final void pcSetplainAttrs(JPALinkedAccount jPALinkedAccount, String string) {
        if (jPALinkedAccount.pcStateManager == null) {
            jPALinkedAccount.plainAttrs = string;
            return;
        }
        jPALinkedAccount.pcStateManager.settingStringField((PersistenceCapable)jPALinkedAccount, pcInheritedFieldCount + 4, jPALinkedAccount.plainAttrs, string, 0);
    }

    private static final Set pcGetprivileges(JPALinkedAccount jPALinkedAccount) {
        if (jPALinkedAccount.pcStateManager == null) {
            return jPALinkedAccount.privileges;
        }
        int n = pcInheritedFieldCount + 5;
        jPALinkedAccount.pcStateManager.accessingField(n);
        return jPALinkedAccount.privileges;
    }

    private static final void pcSetprivileges(JPALinkedAccount jPALinkedAccount, Set set) {
        if (jPALinkedAccount.pcStateManager == null) {
            jPALinkedAccount.privileges = set;
            return;
        }
        jPALinkedAccount.pcStateManager.settingObjectField((PersistenceCapable)jPALinkedAccount, pcInheritedFieldCount + 5, jPALinkedAccount.privileges, (Object)set, 0);
    }

    private static final JPAExternalResource pcGetresource(JPALinkedAccount jPALinkedAccount) {
        if (jPALinkedAccount.pcStateManager == null) {
            return jPALinkedAccount.resource;
        }
        int n = pcInheritedFieldCount + 6;
        jPALinkedAccount.pcStateManager.accessingField(n);
        return jPALinkedAccount.resource;
    }

    private static final void pcSetresource(JPALinkedAccount jPALinkedAccount, JPAExternalResource jPAExternalResource) {
        if (jPALinkedAccount.pcStateManager == null) {
            jPALinkedAccount.resource = jPAExternalResource;
            return;
        }
        jPALinkedAccount.pcStateManager.settingObjectField((PersistenceCapable)jPALinkedAccount, pcInheritedFieldCount + 6, (Object)jPALinkedAccount.resource, (Object)jPAExternalResource, 0);
    }

    private static final Boolean pcGetsuspended(JPALinkedAccount jPALinkedAccount) {
        if (jPALinkedAccount.pcStateManager == null) {
            return jPALinkedAccount.suspended;
        }
        int n = pcInheritedFieldCount + 7;
        jPALinkedAccount.pcStateManager.accessingField(n);
        return jPALinkedAccount.suspended;
    }

    private static final void pcSetsuspended(JPALinkedAccount jPALinkedAccount, Boolean bl) {
        if (jPALinkedAccount.pcStateManager == null) {
            jPALinkedAccount.suspended = bl;
            return;
        }
        jPALinkedAccount.pcStateManager.settingObjectField((PersistenceCapable)jPALinkedAccount, pcInheritedFieldCount + 7, (Object)jPALinkedAccount.suspended, (Object)bl, 0);
    }

    private static final String pcGetusername(JPALinkedAccount jPALinkedAccount) {
        if (jPALinkedAccount.pcStateManager == null) {
            return jPALinkedAccount.username;
        }
        int n = pcInheritedFieldCount + 8;
        jPALinkedAccount.pcStateManager.accessingField(n);
        return jPALinkedAccount.username;
    }

    private static final void pcSetusername(JPALinkedAccount jPALinkedAccount, String string) {
        if (jPALinkedAccount.pcStateManager == null) {
            jPALinkedAccount.username = string;
            return;
        }
        jPALinkedAccount.pcStateManager.settingStringField((PersistenceCapable)jPALinkedAccount, pcInheritedFieldCount + 8, jPALinkedAccount.username, string, 0);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = this.pcSerializing();
        objectOutputStream.defaultWriteObject();
        if (bl) {
            this.pcSetDetachedState(null);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.pcSetDetachedState(PersistenceCapable.DESERIALIZED);
        objectInputStream.defaultReadObject();
    }
}

