/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.entity.task;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import jakarta.persistence.UniqueConstraint;
import jakarta.validation.constraints.NotNull;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.StateManager;
import org.apache.syncope.common.lib.types.PullMode;
import org.apache.syncope.core.persistence.api.entity.Implementation;
import org.apache.syncope.core.persistence.api.entity.task.AnyTemplatePullTask;
import org.apache.syncope.core.persistence.api.entity.task.PullTask;
import org.apache.syncope.core.persistence.api.entity.task.SchedTask;
import org.apache.syncope.core.persistence.api.entity.task.TaskExec;
import org.apache.syncope.core.persistence.jpa.entity.JPAImplementation;
import org.apache.syncope.core.persistence.jpa.entity.task.AbstractInboundTask;
import org.apache.syncope.core.persistence.jpa.entity.task.JPAAnyTemplatePullTask;
import org.apache.syncope.core.persistence.jpa.entity.task.JPAPullTaskExec;

@Entity
@Table(name="PullTask")
public class JPAPullTask
extends AbstractInboundTask<PullTask>
implements PullTask {
    private static final long serialVersionUID = -4141057723006682563L;
    public static final String TABLE = "PullTask";
    @Enumerated(value=EnumType.STRING)
    @NotNull
    private PullMode pullMode;
    @OneToOne
    private JPAImplementation reconFilterBuilder;
    @ManyToMany(fetch=FetchType.EAGER)
    @JoinTable(name="PullTaskAction", joinColumns={@JoinColumn(name="task_id")}, inverseJoinColumns={@JoinColumn(name="implementation_id")}, uniqueConstraints={@UniqueConstraint(columnNames={"task_id", "implementation_id"})})
    private List<JPAImplementation> actions = new ArrayList<JPAImplementation>();
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.EAGER, mappedBy="pullTask")
    private List<JPAAnyTemplatePullTask> templates = new ArrayList<JPAAnyTemplatePullTask>();
    @OneToMany(targetEntity=JPAPullTaskExec.class, cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="task")
    private List<TaskExec<SchedTask>> executions = new ArrayList<TaskExec<SchedTask>>();
    private static int pcInheritedFieldCount = AbstractInboundTask.pcGetManagedFieldCount();
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;

    public PullMode getPullMode() {
        return JPAPullTask.pcGetpullMode(this);
    }

    public void setPullMode(PullMode pullMode) {
        JPAPullTask.pcSetpullMode(this, pullMode);
    }

    public Implementation getReconFilterBuilder() {
        return JPAPullTask.pcGetreconFilterBuilder(this);
    }

    public void setReconFilterBuilder(Implementation reconFilterBuilder) {
        this.checkType(reconFilterBuilder, JPAImplementation.class);
        this.checkImplementationType(reconFilterBuilder, "RECON_FILTER_BUILDER");
        JPAPullTask.pcSetreconFilterBuilder(this, (JPAImplementation)reconFilterBuilder);
    }

    public boolean add(Implementation action) {
        this.checkType(action, JPAImplementation.class);
        this.checkImplementationType(action, "INBOUND_ACTIONS");
        return JPAPullTask.pcGetactions(this).contains((JPAImplementation)action) || JPAPullTask.pcGetactions(this).add((JPAImplementation)action);
    }

    public List<? extends Implementation> getActions() {
        return JPAPullTask.pcGetactions(this);
    }

    public boolean add(AnyTemplatePullTask template) {
        this.checkType(template, JPAAnyTemplatePullTask.class);
        return JPAPullTask.pcGettemplates(this).add((JPAAnyTemplatePullTask)template);
    }

    public Optional<? extends AnyTemplatePullTask> getTemplate(String anyType) {
        return JPAPullTask.pcGettemplates(this).stream().filter(template -> anyType != null && anyType.equals(template.getAnyType().getKey())).findFirst();
    }

    public List<? extends AnyTemplatePullTask> getTemplates() {
        return JPAPullTask.pcGettemplates(this);
    }

    @Override
    protected Class<? extends TaskExec<SchedTask>> executionClass() {
        return JPAPullTaskExec.class;
    }

    @Override
    protected List<TaskExec<SchedTask>> executions() {
        return JPAPullTask.pcGetexecutions(this);
    }

    @Override
    public int pcGetEnhancementContractVersion() {
        return 117245485;
    }

    static {
        pcPCSuperclass = AbstractInboundTask.class;
        pcFieldNames = new String[]{"actions", "executions", "pullMode", "reconFilterBuilder", "templates"};
        pcFieldTypes = new Class[]{List.class, List.class, PullMode.class, JPAImplementation.class, List.class};
        pcFieldFlags = new byte[]{10, 5, 26, 26, 10};
        PCRegistry.register(JPAPullTask.class, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"JPAPullTask", (PersistenceCapable)new JPAPullTask());
    }

    @Override
    protected void pcClearFields() {
        super.pcClearFields();
        this.actions = null;
        this.executions = null;
        this.pullMode = null;
        this.reconFilterBuilder = null;
        this.templates = null;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        JPAPullTask jPAPullTask = new JPAPullTask();
        if (bl) {
            jPAPullTask.pcClearFields();
        }
        jPAPullTask.pcStateManager = stateManager;
        jPAPullTask.pcCopyKeyFieldsFromObjectId(object);
        return jPAPullTask;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        JPAPullTask jPAPullTask = new JPAPullTask();
        if (bl) {
            jPAPullTask.pcClearFields();
        }
        jPAPullTask.pcStateManager = stateManager;
        return jPAPullTask;
    }

    protected static int pcGetManagedFieldCount() {
        return 5 + AbstractInboundTask.pcGetManagedFieldCount();
    }

    @Override
    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcReplaceField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.actions = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.executions = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.pullMode = (PullMode)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.reconFilterBuilder = (JPAImplementation)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 4: {
                this.templates = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcReplaceFields(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.pcReplaceField(nArray[i]);
        }
    }

    @Override
    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcProvideField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.actions);
                return;
            }
            case 1: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.executions);
                return;
            }
            case 2: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.pullMode);
                return;
            }
            case 3: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.reconFilterBuilder);
                return;
            }
            case 4: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.templates);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcProvideFields(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.pcProvideField(nArray[i]);
        }
    }

    protected void pcCopyField(JPAPullTask jPAPullTask, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcCopyField(jPAPullTask, n);
            return;
        }
        switch (n2) {
            case 0: {
                this.actions = jPAPullTask.actions;
                return;
            }
            case 1: {
                this.executions = jPAPullTask.executions;
                return;
            }
            case 2: {
                this.pullMode = jPAPullTask.pullMode;
                return;
            }
            case 3: {
                this.reconFilterBuilder = jPAPullTask.reconFilterBuilder;
                return;
            }
            case 4: {
                this.templates = jPAPullTask.templates;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcCopyFields(Object object, int[] nArray) {
        JPAPullTask jPAPullTask = (JPAPullTask)object;
        if (jPAPullTask.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        for (int i = 0; i < nArray.length; ++i) {
            this.pcCopyField(jPAPullTask, nArray[i]);
        }
    }

    @Override
    public Class pcGetIDOwningClass() {
        return JPAPullTask.class;
    }

    private static final List pcGetactions(JPAPullTask jPAPullTask) {
        if (jPAPullTask.pcStateManager == null) {
            return jPAPullTask.actions;
        }
        int n = pcInheritedFieldCount + 0;
        jPAPullTask.pcStateManager.accessingField(n);
        return jPAPullTask.actions;
    }

    private static final void pcSetactions(JPAPullTask jPAPullTask, List list) {
        if (jPAPullTask.pcStateManager == null) {
            jPAPullTask.actions = list;
            return;
        }
        jPAPullTask.pcStateManager.settingObjectField((PersistenceCapable)jPAPullTask, pcInheritedFieldCount + 0, jPAPullTask.actions, (Object)list, 0);
    }

    private static final List pcGetexecutions(JPAPullTask jPAPullTask) {
        if (jPAPullTask.pcStateManager == null) {
            return jPAPullTask.executions;
        }
        int n = pcInheritedFieldCount + 1;
        jPAPullTask.pcStateManager.accessingField(n);
        return jPAPullTask.executions;
    }

    private static final void pcSetexecutions(JPAPullTask jPAPullTask, List list) {
        if (jPAPullTask.pcStateManager == null) {
            jPAPullTask.executions = list;
            return;
        }
        jPAPullTask.pcStateManager.settingObjectField((PersistenceCapable)jPAPullTask, pcInheritedFieldCount + 1, jPAPullTask.executions, (Object)list, 0);
    }

    private static final PullMode pcGetpullMode(JPAPullTask jPAPullTask) {
        if (jPAPullTask.pcStateManager == null) {
            return jPAPullTask.pullMode;
        }
        int n = pcInheritedFieldCount + 2;
        jPAPullTask.pcStateManager.accessingField(n);
        return jPAPullTask.pullMode;
    }

    private static final void pcSetpullMode(JPAPullTask jPAPullTask, PullMode pullMode) {
        if (jPAPullTask.pcStateManager == null) {
            jPAPullTask.pullMode = pullMode;
            return;
        }
        jPAPullTask.pcStateManager.settingObjectField((PersistenceCapable)jPAPullTask, pcInheritedFieldCount + 2, (Object)jPAPullTask.pullMode, (Object)pullMode, 0);
    }

    private static final JPAImplementation pcGetreconFilterBuilder(JPAPullTask jPAPullTask) {
        if (jPAPullTask.pcStateManager == null) {
            return jPAPullTask.reconFilterBuilder;
        }
        int n = pcInheritedFieldCount + 3;
        jPAPullTask.pcStateManager.accessingField(n);
        return jPAPullTask.reconFilterBuilder;
    }

    private static final void pcSetreconFilterBuilder(JPAPullTask jPAPullTask, JPAImplementation jPAImplementation) {
        if (jPAPullTask.pcStateManager == null) {
            jPAPullTask.reconFilterBuilder = jPAImplementation;
            return;
        }
        jPAPullTask.pcStateManager.settingObjectField((PersistenceCapable)jPAPullTask, pcInheritedFieldCount + 3, (Object)jPAPullTask.reconFilterBuilder, (Object)jPAImplementation, 0);
    }

    private static final List pcGettemplates(JPAPullTask jPAPullTask) {
        if (jPAPullTask.pcStateManager == null) {
            return jPAPullTask.templates;
        }
        int n = pcInheritedFieldCount + 4;
        jPAPullTask.pcStateManager.accessingField(n);
        return jPAPullTask.templates;
    }

    private static final void pcSettemplates(JPAPullTask jPAPullTask, List list) {
        if (jPAPullTask.pcStateManager == null) {
            jPAPullTask.templates = list;
            return;
        }
        jPAPullTask.pcStateManager.settingObjectField((PersistenceCapable)jPAPullTask, pcInheritedFieldCount + 4, jPAPullTask.templates, (Object)list, 0);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = this.pcSerializing();
        objectOutputStream.defaultWriteObject();
        if (bl) {
            this.pcSetDetachedState(null);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.pcSetDetachedState(PersistenceCapable.DESERIALIZED);
        objectInputStream.defaultReadObject();
    }
}

