/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.entity.task;

import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.Lob;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import jakarta.validation.constraints.NotNull;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Optional;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.StateManager;
import org.apache.openjpa.util.UserException;
import org.apache.syncope.common.lib.types.MatchingRule;
import org.apache.syncope.common.lib.types.ThreadPoolSettings;
import org.apache.syncope.common.lib.types.UnmatchingRule;
import org.apache.syncope.core.persistence.api.entity.ExternalResource;
import org.apache.syncope.core.persistence.api.entity.task.ProvisioningTask;
import org.apache.syncope.core.persistence.api.entity.task.SchedTask;
import org.apache.syncope.core.persistence.common.validation.ProvisioningTaskCheck;
import org.apache.syncope.core.persistence.jpa.entity.JPAExternalResource;
import org.apache.syncope.core.persistence.jpa.entity.task.JPASchedTask;
import org.apache.syncope.core.provisioning.api.serialization.POJOHelper;

@MappedSuperclass
@ProvisioningTaskCheck
public abstract class AbstractProvisioningTask<T extends SchedTask>
extends JPASchedTask
implements ProvisioningTask<T> {
    private static final long serialVersionUID = -4141057723006682562L;
    @ManyToOne
    private JPAExternalResource resource;
    @NotNull
    private Boolean performCreate = false;
    @NotNull
    private Boolean performUpdate = false;
    @NotNull
    private Boolean performDelete = false;
    @NotNull
    private Boolean syncStatus = false;
    @NotNull
    @Enumerated(value=EnumType.STRING)
    protected UnmatchingRule unmatchingRule;
    @NotNull
    @Enumerated(value=EnumType.STRING)
    protected MatchingRule matchingRule;
    @Lob
    protected String concurrentSettings;
    private static int pcInheritedFieldCount = JPASchedTask.pcGetManagedFieldCount();
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;

    public ExternalResource getResource() {
        return AbstractProvisioningTask.pcGetresource(this);
    }

    public void setResource(ExternalResource resource) {
        this.checkType(resource, JPAExternalResource.class);
        AbstractProvisioningTask.pcSetresource(this, (JPAExternalResource)resource);
    }

    public boolean isPerformCreate() {
        return AbstractProvisioningTask.pcGetperformCreate(this);
    }

    public void setPerformCreate(boolean performCreate) {
        AbstractProvisioningTask.pcSetperformCreate(this, performCreate);
    }

    public boolean isPerformUpdate() {
        return AbstractProvisioningTask.pcGetperformUpdate(this);
    }

    public void setPerformUpdate(boolean performUpdate) {
        AbstractProvisioningTask.pcSetperformUpdate(this, performUpdate);
    }

    public boolean isPerformDelete() {
        return AbstractProvisioningTask.pcGetperformDelete(this);
    }

    public void setPerformDelete(boolean performDelete) {
        AbstractProvisioningTask.pcSetperformDelete(this, performDelete);
    }

    public boolean isSyncStatus() {
        return AbstractProvisioningTask.pcGetsyncStatus(this);
    }

    public void setSyncStatus(boolean syncStatus) {
        AbstractProvisioningTask.pcSetsyncStatus(this, syncStatus);
    }

    public UnmatchingRule getUnmatchingRule() {
        return AbstractProvisioningTask.pcGetunmatchingRule(this);
    }

    public void setUnmatchingRule(UnmatchingRule unmatchigRule) {
        AbstractProvisioningTask.pcSetunmatchingRule(this, unmatchigRule);
    }

    public MatchingRule getMatchingRule() {
        return AbstractProvisioningTask.pcGetmatchingRule(this);
    }

    public void setMatchingRule(MatchingRule matchigRule) {
        AbstractProvisioningTask.pcSetmatchingRule(this, matchigRule);
    }

    public ThreadPoolSettings getConcurrentSettings() {
        return Optional.ofNullable(AbstractProvisioningTask.pcGetconcurrentSettings(this)).map(s -> (ThreadPoolSettings)POJOHelper.deserialize((String)s, ThreadPoolSettings.class)).orElse(null);
    }

    public void setConcurrentSettings(ThreadPoolSettings settings) {
        AbstractProvisioningTask.pcSetconcurrentSettings(this, Optional.ofNullable(settings).map(POJOHelper::serialize).orElse(null));
    }

    @Override
    public int pcGetEnhancementContractVersion() {
        return 117245485;
    }

    static {
        pcPCSuperclass = JPASchedTask.class;
        pcFieldNames = new String[]{"concurrentSettings", "matchingRule", "performCreate", "performDelete", "performUpdate", "resource", "syncStatus", "unmatchingRule"};
        pcFieldTypes = new Class[]{String.class, MatchingRule.class, Boolean.class, Boolean.class, Boolean.class, JPAExternalResource.class, Boolean.class, UnmatchingRule.class};
        pcFieldFlags = new byte[]{26, 26, 26, 26, 26, 26, 26, 26};
        PCRegistry.register(AbstractProvisioningTask.class, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"AbstractProvisioningTask", null);
    }

    @Override
    protected void pcClearFields() {
        super.pcClearFields();
        this.concurrentSettings = null;
        this.matchingRule = null;
        this.performCreate = null;
        this.performDelete = null;
        this.performUpdate = null;
        this.resource = null;
        this.syncStatus = null;
        this.unmatchingRule = null;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        throw new UserException();
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        throw new UserException();
    }

    protected static int pcGetManagedFieldCount() {
        return 8 + JPASchedTask.pcGetManagedFieldCount();
    }

    @Override
    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcReplaceField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.concurrentSettings = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.matchingRule = (MatchingRule)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.performCreate = (Boolean)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.performDelete = (Boolean)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 4: {
                this.performUpdate = (Boolean)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 5: {
                this.resource = (JPAExternalResource)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 6: {
                this.syncStatus = (Boolean)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 7: {
                this.unmatchingRule = (UnmatchingRule)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcReplaceFields(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.pcReplaceField(nArray[i]);
        }
    }

    @Override
    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcProvideField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.concurrentSettings);
                return;
            }
            case 1: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.matchingRule);
                return;
            }
            case 2: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.performCreate);
                return;
            }
            case 3: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.performDelete);
                return;
            }
            case 4: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.performUpdate);
                return;
            }
            case 5: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.resource);
                return;
            }
            case 6: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.syncStatus);
                return;
            }
            case 7: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.unmatchingRule);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcProvideFields(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.pcProvideField(nArray[i]);
        }
    }

    protected void pcCopyField(AbstractProvisioningTask abstractProvisioningTask, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcCopyField(abstractProvisioningTask, n);
            return;
        }
        switch (n2) {
            case 0: {
                this.concurrentSettings = abstractProvisioningTask.concurrentSettings;
                return;
            }
            case 1: {
                this.matchingRule = abstractProvisioningTask.matchingRule;
                return;
            }
            case 2: {
                this.performCreate = abstractProvisioningTask.performCreate;
                return;
            }
            case 3: {
                this.performDelete = abstractProvisioningTask.performDelete;
                return;
            }
            case 4: {
                this.performUpdate = abstractProvisioningTask.performUpdate;
                return;
            }
            case 5: {
                this.resource = abstractProvisioningTask.resource;
                return;
            }
            case 6: {
                this.syncStatus = abstractProvisioningTask.syncStatus;
                return;
            }
            case 7: {
                this.unmatchingRule = abstractProvisioningTask.unmatchingRule;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcCopyFields(Object object, int[] nArray) {
        AbstractProvisioningTask abstractProvisioningTask = (AbstractProvisioningTask)object;
        if (abstractProvisioningTask.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        for (int i = 0; i < nArray.length; ++i) {
            this.pcCopyField(abstractProvisioningTask, nArray[i]);
        }
    }

    @Override
    public Class pcGetIDOwningClass() {
        return AbstractProvisioningTask.class;
    }

    protected static final String pcGetconcurrentSettings(AbstractProvisioningTask abstractProvisioningTask) {
        if (abstractProvisioningTask.pcStateManager == null) {
            return abstractProvisioningTask.concurrentSettings;
        }
        int n = pcInheritedFieldCount + 0;
        abstractProvisioningTask.pcStateManager.accessingField(n);
        return abstractProvisioningTask.concurrentSettings;
    }

    protected static final void pcSetconcurrentSettings(AbstractProvisioningTask abstractProvisioningTask, String string) {
        if (abstractProvisioningTask.pcStateManager == null) {
            abstractProvisioningTask.concurrentSettings = string;
            return;
        }
        abstractProvisioningTask.pcStateManager.settingStringField((PersistenceCapable)abstractProvisioningTask, pcInheritedFieldCount + 0, abstractProvisioningTask.concurrentSettings, string, 0);
    }

    protected static final MatchingRule pcGetmatchingRule(AbstractProvisioningTask abstractProvisioningTask) {
        if (abstractProvisioningTask.pcStateManager == null) {
            return abstractProvisioningTask.matchingRule;
        }
        int n = pcInheritedFieldCount + 1;
        abstractProvisioningTask.pcStateManager.accessingField(n);
        return abstractProvisioningTask.matchingRule;
    }

    protected static final void pcSetmatchingRule(AbstractProvisioningTask abstractProvisioningTask, MatchingRule matchingRule) {
        if (abstractProvisioningTask.pcStateManager == null) {
            abstractProvisioningTask.matchingRule = matchingRule;
            return;
        }
        abstractProvisioningTask.pcStateManager.settingObjectField((PersistenceCapable)abstractProvisioningTask, pcInheritedFieldCount + 1, (Object)abstractProvisioningTask.matchingRule, (Object)matchingRule, 0);
    }

    private static final Boolean pcGetperformCreate(AbstractProvisioningTask abstractProvisioningTask) {
        if (abstractProvisioningTask.pcStateManager == null) {
            return abstractProvisioningTask.performCreate;
        }
        int n = pcInheritedFieldCount + 2;
        abstractProvisioningTask.pcStateManager.accessingField(n);
        return abstractProvisioningTask.performCreate;
    }

    private static final void pcSetperformCreate(AbstractProvisioningTask abstractProvisioningTask, Boolean bl) {
        if (abstractProvisioningTask.pcStateManager == null) {
            abstractProvisioningTask.performCreate = bl;
            return;
        }
        abstractProvisioningTask.pcStateManager.settingObjectField((PersistenceCapable)abstractProvisioningTask, pcInheritedFieldCount + 2, (Object)abstractProvisioningTask.performCreate, (Object)bl, 0);
    }

    private static final Boolean pcGetperformDelete(AbstractProvisioningTask abstractProvisioningTask) {
        if (abstractProvisioningTask.pcStateManager == null) {
            return abstractProvisioningTask.performDelete;
        }
        int n = pcInheritedFieldCount + 3;
        abstractProvisioningTask.pcStateManager.accessingField(n);
        return abstractProvisioningTask.performDelete;
    }

    private static final void pcSetperformDelete(AbstractProvisioningTask abstractProvisioningTask, Boolean bl) {
        if (abstractProvisioningTask.pcStateManager == null) {
            abstractProvisioningTask.performDelete = bl;
            return;
        }
        abstractProvisioningTask.pcStateManager.settingObjectField((PersistenceCapable)abstractProvisioningTask, pcInheritedFieldCount + 3, (Object)abstractProvisioningTask.performDelete, (Object)bl, 0);
    }

    private static final Boolean pcGetperformUpdate(AbstractProvisioningTask abstractProvisioningTask) {
        if (abstractProvisioningTask.pcStateManager == null) {
            return abstractProvisioningTask.performUpdate;
        }
        int n = pcInheritedFieldCount + 4;
        abstractProvisioningTask.pcStateManager.accessingField(n);
        return abstractProvisioningTask.performUpdate;
    }

    private static final void pcSetperformUpdate(AbstractProvisioningTask abstractProvisioningTask, Boolean bl) {
        if (abstractProvisioningTask.pcStateManager == null) {
            abstractProvisioningTask.performUpdate = bl;
            return;
        }
        abstractProvisioningTask.pcStateManager.settingObjectField((PersistenceCapable)abstractProvisioningTask, pcInheritedFieldCount + 4, (Object)abstractProvisioningTask.performUpdate, (Object)bl, 0);
    }

    private static final JPAExternalResource pcGetresource(AbstractProvisioningTask abstractProvisioningTask) {
        if (abstractProvisioningTask.pcStateManager == null) {
            return abstractProvisioningTask.resource;
        }
        int n = pcInheritedFieldCount + 5;
        abstractProvisioningTask.pcStateManager.accessingField(n);
        return abstractProvisioningTask.resource;
    }

    private static final void pcSetresource(AbstractProvisioningTask abstractProvisioningTask, JPAExternalResource jPAExternalResource) {
        if (abstractProvisioningTask.pcStateManager == null) {
            abstractProvisioningTask.resource = jPAExternalResource;
            return;
        }
        abstractProvisioningTask.pcStateManager.settingObjectField((PersistenceCapable)abstractProvisioningTask, pcInheritedFieldCount + 5, (Object)abstractProvisioningTask.resource, (Object)jPAExternalResource, 0);
    }

    private static final Boolean pcGetsyncStatus(AbstractProvisioningTask abstractProvisioningTask) {
        if (abstractProvisioningTask.pcStateManager == null) {
            return abstractProvisioningTask.syncStatus;
        }
        int n = pcInheritedFieldCount + 6;
        abstractProvisioningTask.pcStateManager.accessingField(n);
        return abstractProvisioningTask.syncStatus;
    }

    private static final void pcSetsyncStatus(AbstractProvisioningTask abstractProvisioningTask, Boolean bl) {
        if (abstractProvisioningTask.pcStateManager == null) {
            abstractProvisioningTask.syncStatus = bl;
            return;
        }
        abstractProvisioningTask.pcStateManager.settingObjectField((PersistenceCapable)abstractProvisioningTask, pcInheritedFieldCount + 6, (Object)abstractProvisioningTask.syncStatus, (Object)bl, 0);
    }

    protected static final UnmatchingRule pcGetunmatchingRule(AbstractProvisioningTask abstractProvisioningTask) {
        if (abstractProvisioningTask.pcStateManager == null) {
            return abstractProvisioningTask.unmatchingRule;
        }
        int n = pcInheritedFieldCount + 7;
        abstractProvisioningTask.pcStateManager.accessingField(n);
        return abstractProvisioningTask.unmatchingRule;
    }

    protected static final void pcSetunmatchingRule(AbstractProvisioningTask abstractProvisioningTask, UnmatchingRule unmatchingRule) {
        if (abstractProvisioningTask.pcStateManager == null) {
            abstractProvisioningTask.unmatchingRule = unmatchingRule;
            return;
        }
        abstractProvisioningTask.pcStateManager.settingObjectField((PersistenceCapable)abstractProvisioningTask, pcInheritedFieldCount + 7, (Object)abstractProvisioningTask.unmatchingRule, (Object)unmatchingRule, 0);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = this.pcSerializing();
        objectOutputStream.defaultWriteObject();
        if (bl) {
            this.pcSetDetachedState(null);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.pcSetDetachedState(PersistenceCapable.DESERIALIZED);
        objectInputStream.defaultReadObject();
    }
}

