/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.entity.policy;

import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.Table;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Optional;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.StateManager;
import org.apache.syncope.common.lib.types.BackOffStrategy;
import org.apache.syncope.core.persistence.api.entity.policy.PropagationPolicy;
import org.apache.syncope.core.persistence.jpa.entity.policy.AbstractPolicy;

@Entity
@Table(name="PropagationPolicy")
public class JPAPropagationPolicy
extends AbstractPolicy
implements PropagationPolicy,
PersistenceCapable {
    private static final long serialVersionUID = 17400846199535L;
    public static final String TABLE = "PropagationPolicy";
    @NotNull
    private Boolean fetchAroundProvisioning = true;
    @NotNull
    private Boolean updateDelta = false;
    @Enumerated(value=EnumType.STRING)
    @NotNull
    private BackOffStrategy backOffStrategy;
    private String backOffParams;
    @Min(value=1L)
    @NotNull
    private @Min(value=1L) @NotNull Integer maxAttempts = 3;
    private static int pcInheritedFieldCount = AbstractPolicy.pcGetManagedFieldCount();
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;

    public boolean isFetchAroundProvisioning() {
        return JPAPropagationPolicy.pcGetfetchAroundProvisioning(this);
    }

    public void setFetchAroundProvisioning(boolean fetchAroundProvisioning) {
        JPAPropagationPolicy.pcSetfetchAroundProvisioning(this, fetchAroundProvisioning);
    }

    public boolean isUpdateDelta() {
        return JPAPropagationPolicy.pcGetupdateDelta(this);
    }

    public void setUpdateDelta(boolean updateDelta) {
        JPAPropagationPolicy.pcSetupdateDelta(this, updateDelta);
    }

    public BackOffStrategy getBackOffStrategy() {
        return JPAPropagationPolicy.pcGetbackOffStrategy(this);
    }

    public void setBackOffStrategy(BackOffStrategy backOffStrategy) {
        JPAPropagationPolicy.pcSetbackOffStrategy(this, backOffStrategy);
    }

    public String getBackOffParams() {
        return JPAPropagationPolicy.pcGetbackOffParams(this);
    }

    public void setBackOffParams(String backOffParams) {
        JPAPropagationPolicy.pcSetbackOffParams(this, backOffParams);
    }

    public int getMaxAttempts() {
        return Optional.ofNullable(JPAPropagationPolicy.pcGetmaxAttempts(this)).orElse(3);
    }

    public void setMaxAttempts(int maxAttempts) {
        JPAPropagationPolicy.pcSetmaxAttempts(this, maxAttempts);
    }

    @Override
    public int pcGetEnhancementContractVersion() {
        return 117245485;
    }

    static {
        pcPCSuperclass = AbstractPolicy.class;
        pcFieldNames = new String[]{"backOffParams", "backOffStrategy", "fetchAroundProvisioning", "maxAttempts", "updateDelta"};
        pcFieldTypes = new Class[]{String.class, BackOffStrategy.class, Boolean.class, Integer.class, Boolean.class};
        pcFieldFlags = new byte[]{26, 26, 26, 26, 26};
        PCRegistry.register(JPAPropagationPolicy.class, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"JPAPropagationPolicy", (PersistenceCapable)new JPAPropagationPolicy());
    }

    @Override
    protected void pcClearFields() {
        super.pcClearFields();
        this.backOffParams = null;
        this.backOffStrategy = null;
        this.fetchAroundProvisioning = null;
        this.maxAttempts = null;
        this.updateDelta = null;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        JPAPropagationPolicy jPAPropagationPolicy = new JPAPropagationPolicy();
        if (bl) {
            jPAPropagationPolicy.pcClearFields();
        }
        jPAPropagationPolicy.pcStateManager = stateManager;
        jPAPropagationPolicy.pcCopyKeyFieldsFromObjectId(object);
        return jPAPropagationPolicy;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        JPAPropagationPolicy jPAPropagationPolicy = new JPAPropagationPolicy();
        if (bl) {
            jPAPropagationPolicy.pcClearFields();
        }
        jPAPropagationPolicy.pcStateManager = stateManager;
        return jPAPropagationPolicy;
    }

    protected static int pcGetManagedFieldCount() {
        return 5 + AbstractPolicy.pcGetManagedFieldCount();
    }

    @Override
    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcReplaceField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.backOffParams = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.backOffStrategy = (BackOffStrategy)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.fetchAroundProvisioning = (Boolean)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.maxAttempts = (Integer)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 4: {
                this.updateDelta = (Boolean)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcReplaceFields(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.pcReplaceField(nArray[i]);
        }
    }

    @Override
    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcProvideField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.backOffParams);
                return;
            }
            case 1: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.backOffStrategy);
                return;
            }
            case 2: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.fetchAroundProvisioning);
                return;
            }
            case 3: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.maxAttempts);
                return;
            }
            case 4: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.updateDelta);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcProvideFields(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.pcProvideField(nArray[i]);
        }
    }

    protected void pcCopyField(JPAPropagationPolicy jPAPropagationPolicy, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcCopyField(jPAPropagationPolicy, n);
            return;
        }
        switch (n2) {
            case 0: {
                this.backOffParams = jPAPropagationPolicy.backOffParams;
                return;
            }
            case 1: {
                this.backOffStrategy = jPAPropagationPolicy.backOffStrategy;
                return;
            }
            case 2: {
                this.fetchAroundProvisioning = jPAPropagationPolicy.fetchAroundProvisioning;
                return;
            }
            case 3: {
                this.maxAttempts = jPAPropagationPolicy.maxAttempts;
                return;
            }
            case 4: {
                this.updateDelta = jPAPropagationPolicy.updateDelta;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcCopyFields(Object object, int[] nArray) {
        JPAPropagationPolicy jPAPropagationPolicy = (JPAPropagationPolicy)object;
        if (jPAPropagationPolicy.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        for (int i = 0; i < nArray.length; ++i) {
            this.pcCopyField(jPAPropagationPolicy, nArray[i]);
        }
    }

    @Override
    public Class pcGetIDOwningClass() {
        return JPAPropagationPolicy.class;
    }

    private static final String pcGetbackOffParams(JPAPropagationPolicy jPAPropagationPolicy) {
        if (jPAPropagationPolicy.pcStateManager == null) {
            return jPAPropagationPolicy.backOffParams;
        }
        int n = pcInheritedFieldCount + 0;
        jPAPropagationPolicy.pcStateManager.accessingField(n);
        return jPAPropagationPolicy.backOffParams;
    }

    private static final void pcSetbackOffParams(JPAPropagationPolicy jPAPropagationPolicy, String string) {
        if (jPAPropagationPolicy.pcStateManager == null) {
            jPAPropagationPolicy.backOffParams = string;
            return;
        }
        jPAPropagationPolicy.pcStateManager.settingStringField((PersistenceCapable)jPAPropagationPolicy, pcInheritedFieldCount + 0, jPAPropagationPolicy.backOffParams, string, 0);
    }

    private static final BackOffStrategy pcGetbackOffStrategy(JPAPropagationPolicy jPAPropagationPolicy) {
        if (jPAPropagationPolicy.pcStateManager == null) {
            return jPAPropagationPolicy.backOffStrategy;
        }
        int n = pcInheritedFieldCount + 1;
        jPAPropagationPolicy.pcStateManager.accessingField(n);
        return jPAPropagationPolicy.backOffStrategy;
    }

    private static final void pcSetbackOffStrategy(JPAPropagationPolicy jPAPropagationPolicy, BackOffStrategy backOffStrategy) {
        if (jPAPropagationPolicy.pcStateManager == null) {
            jPAPropagationPolicy.backOffStrategy = backOffStrategy;
            return;
        }
        jPAPropagationPolicy.pcStateManager.settingObjectField((PersistenceCapable)jPAPropagationPolicy, pcInheritedFieldCount + 1, (Object)jPAPropagationPolicy.backOffStrategy, (Object)backOffStrategy, 0);
    }

    private static final Boolean pcGetfetchAroundProvisioning(JPAPropagationPolicy jPAPropagationPolicy) {
        if (jPAPropagationPolicy.pcStateManager == null) {
            return jPAPropagationPolicy.fetchAroundProvisioning;
        }
        int n = pcInheritedFieldCount + 2;
        jPAPropagationPolicy.pcStateManager.accessingField(n);
        return jPAPropagationPolicy.fetchAroundProvisioning;
    }

    private static final void pcSetfetchAroundProvisioning(JPAPropagationPolicy jPAPropagationPolicy, Boolean bl) {
        if (jPAPropagationPolicy.pcStateManager == null) {
            jPAPropagationPolicy.fetchAroundProvisioning = bl;
            return;
        }
        jPAPropagationPolicy.pcStateManager.settingObjectField((PersistenceCapable)jPAPropagationPolicy, pcInheritedFieldCount + 2, (Object)jPAPropagationPolicy.fetchAroundProvisioning, (Object)bl, 0);
    }

    private static final Integer pcGetmaxAttempts(JPAPropagationPolicy jPAPropagationPolicy) {
        if (jPAPropagationPolicy.pcStateManager == null) {
            return jPAPropagationPolicy.maxAttempts;
        }
        int n = pcInheritedFieldCount + 3;
        jPAPropagationPolicy.pcStateManager.accessingField(n);
        return jPAPropagationPolicy.maxAttempts;
    }

    private static final void pcSetmaxAttempts(JPAPropagationPolicy jPAPropagationPolicy, Integer n) {
        if (jPAPropagationPolicy.pcStateManager == null) {
            jPAPropagationPolicy.maxAttempts = n;
            return;
        }
        jPAPropagationPolicy.pcStateManager.settingObjectField((PersistenceCapable)jPAPropagationPolicy, pcInheritedFieldCount + 3, (Object)jPAPropagationPolicy.maxAttempts, (Object)n, 0);
    }

    private static final Boolean pcGetupdateDelta(JPAPropagationPolicy jPAPropagationPolicy) {
        if (jPAPropagationPolicy.pcStateManager == null) {
            return jPAPropagationPolicy.updateDelta;
        }
        int n = pcInheritedFieldCount + 4;
        jPAPropagationPolicy.pcStateManager.accessingField(n);
        return jPAPropagationPolicy.updateDelta;
    }

    private static final void pcSetupdateDelta(JPAPropagationPolicy jPAPropagationPolicy, Boolean bl) {
        if (jPAPropagationPolicy.pcStateManager == null) {
            jPAPropagationPolicy.updateDelta = bl;
            return;
        }
        jPAPropagationPolicy.pcStateManager.settingObjectField((PersistenceCapable)jPAPropagationPolicy, pcInheritedFieldCount + 4, (Object)jPAPropagationPolicy.updateDelta, (Object)bl, 0);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = this.pcSerializing();
        objectOutputStream.defaultWriteObject();
        if (bl) {
            this.pcSetDetachedState(null);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.pcSetDetachedState(PersistenceCapable.DESERIALIZED);
        objectInputStream.defaultReadObject();
    }
}

