/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.entity.group;

import jakarta.persistence.Cacheable;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import jakarta.persistence.UniqueConstraint;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.StateManager;
import org.apache.syncope.core.persistence.api.dao.AnyTypeDAO;
import org.apache.syncope.core.persistence.api.entity.AnyType;
import org.apache.syncope.core.persistence.api.entity.AnyTypeClass;
import org.apache.syncope.core.persistence.api.entity.ExternalResource;
import org.apache.syncope.core.persistence.api.entity.anyobject.ADynGroupMembership;
import org.apache.syncope.core.persistence.api.entity.group.GPlainAttr;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.persistence.api.entity.group.TypeExtension;
import org.apache.syncope.core.persistence.api.entity.user.UDynGroupMembership;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.persistence.common.validation.GroupCheck;
import org.apache.syncope.core.persistence.jpa.entity.AbstractAny;
import org.apache.syncope.core.persistence.jpa.entity.JPAAnyTypeClass;
import org.apache.syncope.core.persistence.jpa.entity.JPAExternalResource;
import org.apache.syncope.core.persistence.jpa.entity.anyobject.JPAADynGroupMembership;
import org.apache.syncope.core.persistence.jpa.entity.group.JPATypeExtension;
import org.apache.syncope.core.persistence.jpa.entity.group.JSONGPlainAttr;
import org.apache.syncope.core.persistence.jpa.entity.group.JSONGroupListener;
import org.apache.syncope.core.persistence.jpa.entity.user.JPAUDynGroupMembership;
import org.apache.syncope.core.persistence.jpa.entity.user.JPAUser;
import org.apache.syncope.core.spring.ApplicationContextProvider;

@Entity
@Table(name="SyncopeGroup")
@EntityListeners(value={JSONGroupListener.class})
@Cacheable
@GroupCheck
public class JPAGroup
extends AbstractAny<GPlainAttr>
implements Group {
    private static final long serialVersionUID = -5281258853142421875L;
    public static final String TABLE = "SyncopeGroup";
    @Column(unique=true)
    @NotNull
    private String name;
    @ManyToOne
    private JPAUser userOwner;
    @ManyToOne
    private JPAGroup groupOwner;
    private String plainAttrs;
    @Transient
    private final List<JSONGPlainAttr> plainAttrsList = new ArrayList<JSONGPlainAttr>();
    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(joinColumns={@JoinColumn(name="group_id")}, inverseJoinColumns={@JoinColumn(name="resource_id")}, uniqueConstraints={@UniqueConstraint(columnNames={"group_id", "resource_id"})})
    private List<JPAExternalResource> resources = new ArrayList<JPAExternalResource>();
    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(joinColumns={@JoinColumn(name="group_id")}, inverseJoinColumns={@JoinColumn(name="anyTypeClass_id")}, uniqueConstraints={@UniqueConstraint(columnNames={"group_id", "anyTypeClass_id"})})
    private List<JPAAnyTypeClass> auxClasses = new ArrayList<JPAAnyTypeClass>();
    @OneToOne(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="group")
    @Valid
    private JPAUDynGroupMembership uDynMembership;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.EAGER, mappedBy="group")
    private List<JPAADynGroupMembership> aDynMemberships = new ArrayList<JPAADynGroupMembership>();
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.EAGER, mappedBy="group")
    private List<JPATypeExtension> typeExtensions = new ArrayList<JPATypeExtension>();
    private static int pcInheritedFieldCount = AbstractAny.pcGetManagedFieldCount();
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;

    public String getName() {
        return JPAGroup.pcGetname(this);
    }

    public void setName(String name) {
        JPAGroup.pcSetname(this, name);
    }

    public AnyType getType() {
        return ((AnyTypeDAO)ApplicationContextProvider.getBeanFactory().getBean(AnyTypeDAO.class)).getGroup();
    }

    public void setType(AnyType type) {
    }

    public boolean add(ExternalResource resource) {
        this.checkType(resource, JPAExternalResource.class);
        return JPAGroup.pcGetresources(this).contains((JPAExternalResource)resource) || JPAGroup.pcGetresources(this).add((JPAExternalResource)resource);
    }

    public List<? extends ExternalResource> getResources() {
        return JPAGroup.pcGetresources(this);
    }

    public User getUserOwner() {
        return JPAGroup.pcGetuserOwner(this);
    }

    public void setUserOwner(User userOwner) {
        this.checkType(userOwner, JPAUser.class);
        JPAGroup.pcSetuserOwner(this, (JPAUser)userOwner);
    }

    public Group getGroupOwner() {
        return JPAGroup.pcGetgroupOwner(this);
    }

    public void setGroupOwner(Group group) {
        this.checkType(group, JPAGroup.class);
        JPAGroup.pcSetgroupOwner(this, (JPAGroup)group);
    }

    @Override
    public List<? extends GPlainAttr> getPlainAttrsList() {
        return this.plainAttrsList;
    }

    @Override
    public String getPlainAttrsJSON() {
        return JPAGroup.pcGetplainAttrs(this);
    }

    @Override
    public void setPlainAttrsJSON(String plainAttrs) {
        JPAGroup.pcSetplainAttrs(this, plainAttrs);
    }

    public boolean add(GPlainAttr attr) {
        this.checkType(attr, JSONGPlainAttr.class);
        return this.plainAttrsList.add((JSONGPlainAttr)attr);
    }

    public boolean remove(GPlainAttr attr) {
        this.checkType(attr, JSONGPlainAttr.class);
        return this.plainAttrsList.removeIf(a -> a.getSchemaKey().equals(attr.getSchema().getKey()));
    }

    public Optional<? extends GPlainAttr> getPlainAttr(String plainSchema) {
        return this.plainAttrsList.stream().filter(attr -> plainSchema.equals(attr.getSchemaKey())).findFirst();
    }

    public List<? extends GPlainAttr> getPlainAttrs() {
        return this.plainAttrsList.stream().toList();
    }

    public UDynGroupMembership getUDynMembership() {
        return JPAGroup.pcGetuDynMembership(this);
    }

    public void setUDynMembership(UDynGroupMembership uDynMembership) {
        this.checkType(uDynMembership, JPAUDynGroupMembership.class);
        JPAGroup.pcSetuDynMembership(this, (JPAUDynGroupMembership)uDynMembership);
    }

    public boolean add(AnyTypeClass auxClass) {
        this.checkType(auxClass, JPAAnyTypeClass.class);
        return JPAGroup.pcGetauxClasses(this).contains((JPAAnyTypeClass)auxClass) || JPAGroup.pcGetauxClasses(this).add((JPAAnyTypeClass)auxClass);
    }

    public List<? extends AnyTypeClass> getAuxClasses() {
        return JPAGroup.pcGetauxClasses(this);
    }

    public boolean add(ADynGroupMembership dynGroupMembership) {
        this.checkType(dynGroupMembership, JPAADynGroupMembership.class);
        return JPAGroup.pcGetaDynMemberships(this).add((JPAADynGroupMembership)dynGroupMembership);
    }

    public Optional<? extends ADynGroupMembership> getADynMembership(AnyType anyType) {
        return JPAGroup.pcGetaDynMemberships(this).stream().filter(dynGroupMembership -> anyType != null && anyType.equals((Object)dynGroupMembership.getAnyType())).findFirst();
    }

    public List<? extends ADynGroupMembership> getADynMemberships() {
        return JPAGroup.pcGetaDynMemberships(this);
    }

    public boolean add(TypeExtension typeExtension) {
        this.checkType(typeExtension, JPATypeExtension.class);
        return JPAGroup.pcGettypeExtensions(this).add((JPATypeExtension)typeExtension);
    }

    public Optional<? extends TypeExtension> getTypeExtension(AnyType anyType) {
        return JPAGroup.pcGettypeExtensions(this).stream().filter(typeExtension -> typeExtension.getAnyType().equals((Object)anyType)).findFirst();
    }

    public List<? extends TypeExtension> getTypeExtensions() {
        return JPAGroup.pcGettypeExtensions(this);
    }

    @Override
    public int pcGetEnhancementContractVersion() {
        return 117245485;
    }

    static {
        pcPCSuperclass = AbstractAny.class;
        pcFieldNames = new String[]{"aDynMemberships", "auxClasses", "groupOwner", "name", "plainAttrs", "resources", "typeExtensions", "uDynMembership", "userOwner"};
        pcFieldTypes = new Class[]{List.class, List.class, JPAGroup.class, String.class, String.class, List.class, List.class, JPAUDynGroupMembership.class, JPAUser.class};
        pcFieldFlags = new byte[]{10, 5, 26, 26, 26, 5, 10, 26, 26};
        PCRegistry.register(JPAGroup.class, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"JPAGroup", (PersistenceCapable)new JPAGroup());
    }

    @Override
    protected void pcClearFields() {
        super.pcClearFields();
        this.aDynMemberships = null;
        this.auxClasses = null;
        this.groupOwner = null;
        this.name = null;
        this.plainAttrs = null;
        this.resources = null;
        this.typeExtensions = null;
        this.uDynMembership = null;
        this.userOwner = null;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        JPAGroup jPAGroup = new JPAGroup();
        if (bl) {
            jPAGroup.pcClearFields();
        }
        jPAGroup.pcStateManager = stateManager;
        jPAGroup.pcCopyKeyFieldsFromObjectId(object);
        return jPAGroup;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        JPAGroup jPAGroup = new JPAGroup();
        if (bl) {
            jPAGroup.pcClearFields();
        }
        jPAGroup.pcStateManager = stateManager;
        return jPAGroup;
    }

    protected static int pcGetManagedFieldCount() {
        return 9 + AbstractAny.pcGetManagedFieldCount();
    }

    @Override
    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcReplaceField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.aDynMemberships = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.auxClasses = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.groupOwner = (JPAGroup)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.name = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 4: {
                this.plainAttrs = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 5: {
                this.resources = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 6: {
                this.typeExtensions = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 7: {
                this.uDynMembership = (JPAUDynGroupMembership)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 8: {
                this.userOwner = (JPAUser)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcReplaceFields(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.pcReplaceField(nArray[i]);
        }
    }

    @Override
    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcProvideField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.aDynMemberships);
                return;
            }
            case 1: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.auxClasses);
                return;
            }
            case 2: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.groupOwner);
                return;
            }
            case 3: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.name);
                return;
            }
            case 4: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.plainAttrs);
                return;
            }
            case 5: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.resources);
                return;
            }
            case 6: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.typeExtensions);
                return;
            }
            case 7: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.uDynMembership);
                return;
            }
            case 8: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.userOwner);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcProvideFields(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.pcProvideField(nArray[i]);
        }
    }

    protected void pcCopyField(JPAGroup jPAGroup, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcCopyField(jPAGroup, n);
            return;
        }
        switch (n2) {
            case 0: {
                this.aDynMemberships = jPAGroup.aDynMemberships;
                return;
            }
            case 1: {
                this.auxClasses = jPAGroup.auxClasses;
                return;
            }
            case 2: {
                this.groupOwner = jPAGroup.groupOwner;
                return;
            }
            case 3: {
                this.name = jPAGroup.name;
                return;
            }
            case 4: {
                this.plainAttrs = jPAGroup.plainAttrs;
                return;
            }
            case 5: {
                this.resources = jPAGroup.resources;
                return;
            }
            case 6: {
                this.typeExtensions = jPAGroup.typeExtensions;
                return;
            }
            case 7: {
                this.uDynMembership = jPAGroup.uDynMembership;
                return;
            }
            case 8: {
                this.userOwner = jPAGroup.userOwner;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcCopyFields(Object object, int[] nArray) {
        JPAGroup jPAGroup = (JPAGroup)object;
        if (jPAGroup.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        for (int i = 0; i < nArray.length; ++i) {
            this.pcCopyField(jPAGroup, nArray[i]);
        }
    }

    @Override
    public Class pcGetIDOwningClass() {
        return JPAGroup.class;
    }

    private static final List pcGetaDynMemberships(JPAGroup jPAGroup) {
        if (jPAGroup.pcStateManager == null) {
            return jPAGroup.aDynMemberships;
        }
        int n = pcInheritedFieldCount + 0;
        jPAGroup.pcStateManager.accessingField(n);
        return jPAGroup.aDynMemberships;
    }

    private static final void pcSetaDynMemberships(JPAGroup jPAGroup, List list) {
        if (jPAGroup.pcStateManager == null) {
            jPAGroup.aDynMemberships = list;
            return;
        }
        jPAGroup.pcStateManager.settingObjectField((PersistenceCapable)jPAGroup, pcInheritedFieldCount + 0, jPAGroup.aDynMemberships, (Object)list, 0);
    }

    private static final List pcGetauxClasses(JPAGroup jPAGroup) {
        if (jPAGroup.pcStateManager == null) {
            return jPAGroup.auxClasses;
        }
        int n = pcInheritedFieldCount + 1;
        jPAGroup.pcStateManager.accessingField(n);
        return jPAGroup.auxClasses;
    }

    private static final void pcSetauxClasses(JPAGroup jPAGroup, List list) {
        if (jPAGroup.pcStateManager == null) {
            jPAGroup.auxClasses = list;
            return;
        }
        jPAGroup.pcStateManager.settingObjectField((PersistenceCapable)jPAGroup, pcInheritedFieldCount + 1, jPAGroup.auxClasses, (Object)list, 0);
    }

    private static final JPAGroup pcGetgroupOwner(JPAGroup jPAGroup) {
        if (jPAGroup.pcStateManager == null) {
            return jPAGroup.groupOwner;
        }
        int n = pcInheritedFieldCount + 2;
        jPAGroup.pcStateManager.accessingField(n);
        return jPAGroup.groupOwner;
    }

    private static final void pcSetgroupOwner(JPAGroup jPAGroup, JPAGroup jPAGroup2) {
        if (jPAGroup.pcStateManager == null) {
            jPAGroup.groupOwner = jPAGroup2;
            return;
        }
        jPAGroup.pcStateManager.settingObjectField((PersistenceCapable)jPAGroup, pcInheritedFieldCount + 2, (Object)jPAGroup.groupOwner, (Object)jPAGroup2, 0);
    }

    private static final String pcGetname(JPAGroup jPAGroup) {
        if (jPAGroup.pcStateManager == null) {
            return jPAGroup.name;
        }
        int n = pcInheritedFieldCount + 3;
        jPAGroup.pcStateManager.accessingField(n);
        return jPAGroup.name;
    }

    private static final void pcSetname(JPAGroup jPAGroup, String string) {
        if (jPAGroup.pcStateManager == null) {
            jPAGroup.name = string;
            return;
        }
        jPAGroup.pcStateManager.settingStringField((PersistenceCapable)jPAGroup, pcInheritedFieldCount + 3, jPAGroup.name, string, 0);
    }

    private static final String pcGetplainAttrs(JPAGroup jPAGroup) {
        if (jPAGroup.pcStateManager == null) {
            return jPAGroup.plainAttrs;
        }
        int n = pcInheritedFieldCount + 4;
        jPAGroup.pcStateManager.accessingField(n);
        return jPAGroup.plainAttrs;
    }

    private static final void pcSetplainAttrs(JPAGroup jPAGroup, String string) {
        if (jPAGroup.pcStateManager == null) {
            jPAGroup.plainAttrs = string;
            return;
        }
        jPAGroup.pcStateManager.settingStringField((PersistenceCapable)jPAGroup, pcInheritedFieldCount + 4, jPAGroup.plainAttrs, string, 0);
    }

    private static final List pcGetresources(JPAGroup jPAGroup) {
        if (jPAGroup.pcStateManager == null) {
            return jPAGroup.resources;
        }
        int n = pcInheritedFieldCount + 5;
        jPAGroup.pcStateManager.accessingField(n);
        return jPAGroup.resources;
    }

    private static final void pcSetresources(JPAGroup jPAGroup, List list) {
        if (jPAGroup.pcStateManager == null) {
            jPAGroup.resources = list;
            return;
        }
        jPAGroup.pcStateManager.settingObjectField((PersistenceCapable)jPAGroup, pcInheritedFieldCount + 5, jPAGroup.resources, (Object)list, 0);
    }

    private static final List pcGettypeExtensions(JPAGroup jPAGroup) {
        if (jPAGroup.pcStateManager == null) {
            return jPAGroup.typeExtensions;
        }
        int n = pcInheritedFieldCount + 6;
        jPAGroup.pcStateManager.accessingField(n);
        return jPAGroup.typeExtensions;
    }

    private static final void pcSettypeExtensions(JPAGroup jPAGroup, List list) {
        if (jPAGroup.pcStateManager == null) {
            jPAGroup.typeExtensions = list;
            return;
        }
        jPAGroup.pcStateManager.settingObjectField((PersistenceCapable)jPAGroup, pcInheritedFieldCount + 6, jPAGroup.typeExtensions, (Object)list, 0);
    }

    private static final JPAUDynGroupMembership pcGetuDynMembership(JPAGroup jPAGroup) {
        if (jPAGroup.pcStateManager == null) {
            return jPAGroup.uDynMembership;
        }
        int n = pcInheritedFieldCount + 7;
        jPAGroup.pcStateManager.accessingField(n);
        return jPAGroup.uDynMembership;
    }

    private static final void pcSetuDynMembership(JPAGroup jPAGroup, JPAUDynGroupMembership jPAUDynGroupMembership) {
        if (jPAGroup.pcStateManager == null) {
            jPAGroup.uDynMembership = jPAUDynGroupMembership;
            return;
        }
        jPAGroup.pcStateManager.settingObjectField((PersistenceCapable)jPAGroup, pcInheritedFieldCount + 7, (Object)jPAGroup.uDynMembership, (Object)jPAUDynGroupMembership, 0);
    }

    private static final JPAUser pcGetuserOwner(JPAGroup jPAGroup) {
        if (jPAGroup.pcStateManager == null) {
            return jPAGroup.userOwner;
        }
        int n = pcInheritedFieldCount + 8;
        jPAGroup.pcStateManager.accessingField(n);
        return jPAGroup.userOwner;
    }

    private static final void pcSetuserOwner(JPAGroup jPAGroup, JPAUser jPAUser) {
        if (jPAGroup.pcStateManager == null) {
            jPAGroup.userOwner = jPAUser;
            return;
        }
        jPAGroup.pcStateManager.settingObjectField((PersistenceCapable)jPAGroup, pcInheritedFieldCount + 8, (Object)jPAGroup.userOwner, (Object)jPAUser, 0);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = this.pcSerializing();
        objectOutputStream.defaultWriteObject();
        if (bl) {
            this.pcSetDetachedState(null);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.pcSetDetachedState(PersistenceCapable.DESERIALIZED);
        objectInputStream.defaultReadObject();
    }
}

