/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.entity.am;

import com.fasterxml.jackson.core.type.TypeReference;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Lob;
import jakarta.persistence.Table;
import jakarta.persistence.UniqueConstraint;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.StateManager;
import org.apache.syncope.common.lib.wa.GoogleMfaAuthAccount;
import org.apache.syncope.common.lib.wa.GoogleMfaAuthToken;
import org.apache.syncope.common.lib.wa.ImpersonationAccount;
import org.apache.syncope.common.lib.wa.MfaTrustedDevice;
import org.apache.syncope.common.lib.wa.WebAuthnDeviceCredential;
import org.apache.syncope.core.persistence.api.entity.am.AuthProfile;
import org.apache.syncope.core.persistence.jpa.entity.AbstractGeneratedKeyEntity;
import org.apache.syncope.core.provisioning.api.serialization.POJOHelper;

@Entity
@Table(name="AuthProfile", uniqueConstraints={@UniqueConstraint(columnNames={"owner"})})
public class JPAAuthProfile
extends AbstractGeneratedKeyEntity
implements AuthProfile,
PersistenceCapable {
    private static final long serialVersionUID = 57352617217394093L;
    public static final String TABLE = "AuthProfile";
    protected static final TypeReference<List<GoogleMfaAuthToken>> GOOGLE_MFA_TOKENS_TYPEREF = new TypeReference<List<GoogleMfaAuthToken>>(){};
    protected static final TypeReference<List<GoogleMfaAuthAccount>> GOOGLE_MFA_ACCOUNTS_TYPEREF = new TypeReference<List<GoogleMfaAuthAccount>>(){};
    protected static final TypeReference<List<MfaTrustedDevice>> MFA_TRUSTED_DEVICE_TYPEREF = new TypeReference<List<MfaTrustedDevice>>(){};
    protected static final TypeReference<List<ImpersonationAccount>> IMPERSONATION_TYPEREF = new TypeReference<List<ImpersonationAccount>>(){};
    protected static final TypeReference<List<WebAuthnDeviceCredential>> WEBAUTHN_TYPEREF = new TypeReference<List<WebAuthnDeviceCredential>>(){};
    @Column(nullable=false)
    private String owner;
    @Lob
    private String impersonationAccounts;
    @Lob
    private String googleMfaAuthAccounts;
    @Lob
    private String googleMfaAuthTokens;
    @Lob
    private String mfaTrustedDevices;
    @Lob
    private String webAuthnDeviceCredentials;
    private static int pcInheritedFieldCount = AbstractGeneratedKeyEntity.pcGetManagedFieldCount();
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;

    public String getOwner() {
        return JPAAuthProfile.pcGetowner(this);
    }

    public void setOwner(String owner) {
        JPAAuthProfile.pcSetowner(this, owner);
    }

    public List<GoogleMfaAuthToken> getGoogleMfaAuthTokens() {
        return Optional.ofNullable(JPAAuthProfile.pcGetgoogleMfaAuthTokens(this)).map(v -> (List)POJOHelper.deserialize((String)v, GOOGLE_MFA_TOKENS_TYPEREF)).orElseGet(() -> new ArrayList(0));
    }

    public void setGoogleMfaAuthTokens(List<GoogleMfaAuthToken> tokens) {
        JPAAuthProfile.pcSetgoogleMfaAuthTokens(this, POJOHelper.serialize(tokens));
    }

    public List<GoogleMfaAuthAccount> getGoogleMfaAuthAccounts() {
        return Optional.ofNullable(JPAAuthProfile.pcGetgoogleMfaAuthAccounts(this)).map(v -> (List)POJOHelper.deserialize((String)v, GOOGLE_MFA_ACCOUNTS_TYPEREF)).orElseGet(() -> new ArrayList(0));
    }

    public void setGoogleMfaAuthAccounts(List<GoogleMfaAuthAccount> accounts) {
        JPAAuthProfile.pcSetgoogleMfaAuthAccounts(this, POJOHelper.serialize(accounts));
    }

    public List<MfaTrustedDevice> getMfaTrustedDevices() {
        return Optional.ofNullable(JPAAuthProfile.pcGetmfaTrustedDevices(this)).map(v -> (List)POJOHelper.deserialize((String)v, MFA_TRUSTED_DEVICE_TYPEREF)).orElseGet(() -> new ArrayList(0));
    }

    public void setMfaTrustedDevices(List<MfaTrustedDevice> devices) {
        JPAAuthProfile.pcSetmfaTrustedDevices(this, POJOHelper.serialize(devices));
    }

    public List<ImpersonationAccount> getImpersonationAccounts() {
        return Optional.ofNullable(JPAAuthProfile.pcGetimpersonationAccounts(this)).map(v -> (List)POJOHelper.deserialize((String)v, IMPERSONATION_TYPEREF)).orElseGet(() -> new ArrayList(0));
    }

    public void setImpersonationAccounts(List<ImpersonationAccount> accounts) {
        JPAAuthProfile.pcSetimpersonationAccounts(this, POJOHelper.serialize(accounts));
    }

    public List<WebAuthnDeviceCredential> getWebAuthnDeviceCredentials() {
        return Optional.ofNullable(JPAAuthProfile.pcGetwebAuthnDeviceCredentials(this)).map(v -> (List)POJOHelper.deserialize((String)v, WEBAUTHN_TYPEREF)).orElseGet(() -> new ArrayList(0));
    }

    public void setWebAuthnDeviceCredentials(List<WebAuthnDeviceCredential> credentials) {
        JPAAuthProfile.pcSetwebAuthnDeviceCredentials(this, POJOHelper.serialize(credentials));
    }

    static {
        pcPCSuperclass = AbstractGeneratedKeyEntity.class;
        pcFieldNames = new String[]{"googleMfaAuthAccounts", "googleMfaAuthTokens", "impersonationAccounts", "mfaTrustedDevices", "owner", "webAuthnDeviceCredentials"};
        pcFieldTypes = new Class[]{String.class, String.class, String.class, String.class, String.class, String.class};
        pcFieldFlags = new byte[]{26, 26, 26, 26, 26, 26};
        PCRegistry.register(JPAAuthProfile.class, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"JPAAuthProfile", (PersistenceCapable)new JPAAuthProfile());
    }

    @Override
    public int pcGetEnhancementContractVersion() {
        return 117245485;
    }

    @Override
    protected void pcClearFields() {
        super.pcClearFields();
        this.googleMfaAuthAccounts = null;
        this.googleMfaAuthTokens = null;
        this.impersonationAccounts = null;
        this.mfaTrustedDevices = null;
        this.owner = null;
        this.webAuthnDeviceCredentials = null;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        JPAAuthProfile jPAAuthProfile = new JPAAuthProfile();
        if (bl) {
            jPAAuthProfile.pcClearFields();
        }
        jPAAuthProfile.pcStateManager = stateManager;
        jPAAuthProfile.pcCopyKeyFieldsFromObjectId(object);
        return jPAAuthProfile;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        JPAAuthProfile jPAAuthProfile = new JPAAuthProfile();
        if (bl) {
            jPAAuthProfile.pcClearFields();
        }
        jPAAuthProfile.pcStateManager = stateManager;
        return jPAAuthProfile;
    }

    protected static int pcGetManagedFieldCount() {
        return 6 + AbstractGeneratedKeyEntity.pcGetManagedFieldCount();
    }

    @Override
    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcReplaceField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.googleMfaAuthAccounts = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.googleMfaAuthTokens = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.impersonationAccounts = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.mfaTrustedDevices = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 4: {
                this.owner = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 5: {
                this.webAuthnDeviceCredentials = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcReplaceFields(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.pcReplaceField(nArray[i]);
        }
    }

    @Override
    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcProvideField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.googleMfaAuthAccounts);
                return;
            }
            case 1: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.googleMfaAuthTokens);
                return;
            }
            case 2: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.impersonationAccounts);
                return;
            }
            case 3: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.mfaTrustedDevices);
                return;
            }
            case 4: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.owner);
                return;
            }
            case 5: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.webAuthnDeviceCredentials);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcProvideFields(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.pcProvideField(nArray[i]);
        }
    }

    protected void pcCopyField(JPAAuthProfile jPAAuthProfile, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcCopyField(jPAAuthProfile, n);
            return;
        }
        switch (n2) {
            case 0: {
                this.googleMfaAuthAccounts = jPAAuthProfile.googleMfaAuthAccounts;
                return;
            }
            case 1: {
                this.googleMfaAuthTokens = jPAAuthProfile.googleMfaAuthTokens;
                return;
            }
            case 2: {
                this.impersonationAccounts = jPAAuthProfile.impersonationAccounts;
                return;
            }
            case 3: {
                this.mfaTrustedDevices = jPAAuthProfile.mfaTrustedDevices;
                return;
            }
            case 4: {
                this.owner = jPAAuthProfile.owner;
                return;
            }
            case 5: {
                this.webAuthnDeviceCredentials = jPAAuthProfile.webAuthnDeviceCredentials;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcCopyFields(Object object, int[] nArray) {
        JPAAuthProfile jPAAuthProfile = (JPAAuthProfile)object;
        if (jPAAuthProfile.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        for (int i = 0; i < nArray.length; ++i) {
            this.pcCopyField(jPAAuthProfile, nArray[i]);
        }
    }

    @Override
    public Class pcGetIDOwningClass() {
        return JPAAuthProfile.class;
    }

    private static final String pcGetgoogleMfaAuthAccounts(JPAAuthProfile jPAAuthProfile) {
        if (jPAAuthProfile.pcStateManager == null) {
            return jPAAuthProfile.googleMfaAuthAccounts;
        }
        int n = pcInheritedFieldCount + 0;
        jPAAuthProfile.pcStateManager.accessingField(n);
        return jPAAuthProfile.googleMfaAuthAccounts;
    }

    private static final void pcSetgoogleMfaAuthAccounts(JPAAuthProfile jPAAuthProfile, String string) {
        if (jPAAuthProfile.pcStateManager == null) {
            jPAAuthProfile.googleMfaAuthAccounts = string;
            return;
        }
        jPAAuthProfile.pcStateManager.settingStringField((PersistenceCapable)jPAAuthProfile, pcInheritedFieldCount + 0, jPAAuthProfile.googleMfaAuthAccounts, string, 0);
    }

    private static final String pcGetgoogleMfaAuthTokens(JPAAuthProfile jPAAuthProfile) {
        if (jPAAuthProfile.pcStateManager == null) {
            return jPAAuthProfile.googleMfaAuthTokens;
        }
        int n = pcInheritedFieldCount + 1;
        jPAAuthProfile.pcStateManager.accessingField(n);
        return jPAAuthProfile.googleMfaAuthTokens;
    }

    private static final void pcSetgoogleMfaAuthTokens(JPAAuthProfile jPAAuthProfile, String string) {
        if (jPAAuthProfile.pcStateManager == null) {
            jPAAuthProfile.googleMfaAuthTokens = string;
            return;
        }
        jPAAuthProfile.pcStateManager.settingStringField((PersistenceCapable)jPAAuthProfile, pcInheritedFieldCount + 1, jPAAuthProfile.googleMfaAuthTokens, string, 0);
    }

    private static final String pcGetimpersonationAccounts(JPAAuthProfile jPAAuthProfile) {
        if (jPAAuthProfile.pcStateManager == null) {
            return jPAAuthProfile.impersonationAccounts;
        }
        int n = pcInheritedFieldCount + 2;
        jPAAuthProfile.pcStateManager.accessingField(n);
        return jPAAuthProfile.impersonationAccounts;
    }

    private static final void pcSetimpersonationAccounts(JPAAuthProfile jPAAuthProfile, String string) {
        if (jPAAuthProfile.pcStateManager == null) {
            jPAAuthProfile.impersonationAccounts = string;
            return;
        }
        jPAAuthProfile.pcStateManager.settingStringField((PersistenceCapable)jPAAuthProfile, pcInheritedFieldCount + 2, jPAAuthProfile.impersonationAccounts, string, 0);
    }

    private static final String pcGetmfaTrustedDevices(JPAAuthProfile jPAAuthProfile) {
        if (jPAAuthProfile.pcStateManager == null) {
            return jPAAuthProfile.mfaTrustedDevices;
        }
        int n = pcInheritedFieldCount + 3;
        jPAAuthProfile.pcStateManager.accessingField(n);
        return jPAAuthProfile.mfaTrustedDevices;
    }

    private static final void pcSetmfaTrustedDevices(JPAAuthProfile jPAAuthProfile, String string) {
        if (jPAAuthProfile.pcStateManager == null) {
            jPAAuthProfile.mfaTrustedDevices = string;
            return;
        }
        jPAAuthProfile.pcStateManager.settingStringField((PersistenceCapable)jPAAuthProfile, pcInheritedFieldCount + 3, jPAAuthProfile.mfaTrustedDevices, string, 0);
    }

    private static final String pcGetowner(JPAAuthProfile jPAAuthProfile) {
        if (jPAAuthProfile.pcStateManager == null) {
            return jPAAuthProfile.owner;
        }
        int n = pcInheritedFieldCount + 4;
        jPAAuthProfile.pcStateManager.accessingField(n);
        return jPAAuthProfile.owner;
    }

    private static final void pcSetowner(JPAAuthProfile jPAAuthProfile, String string) {
        if (jPAAuthProfile.pcStateManager == null) {
            jPAAuthProfile.owner = string;
            return;
        }
        jPAAuthProfile.pcStateManager.settingStringField((PersistenceCapable)jPAAuthProfile, pcInheritedFieldCount + 4, jPAAuthProfile.owner, string, 0);
    }

    private static final String pcGetwebAuthnDeviceCredentials(JPAAuthProfile jPAAuthProfile) {
        if (jPAAuthProfile.pcStateManager == null) {
            return jPAAuthProfile.webAuthnDeviceCredentials;
        }
        int n = pcInheritedFieldCount + 5;
        jPAAuthProfile.pcStateManager.accessingField(n);
        return jPAAuthProfile.webAuthnDeviceCredentials;
    }

    private static final void pcSetwebAuthnDeviceCredentials(JPAAuthProfile jPAAuthProfile, String string) {
        if (jPAAuthProfile.pcStateManager == null) {
            jPAAuthProfile.webAuthnDeviceCredentials = string;
            return;
        }
        jPAAuthProfile.pcStateManager.settingStringField((PersistenceCapable)jPAAuthProfile, pcInheritedFieldCount + 5, jPAAuthProfile.webAuthnDeviceCredentials, string, 0);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = this.pcSerializing();
        objectOutputStream.defaultWriteObject();
        if (bl) {
            this.pcSetDetachedState(null);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.pcSetDetachedState(PersistenceCapable.DESERIALIZED);
        objectInputStream.defaultReadObject();
    }
}

