/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.entity;

import java.util.List;
import java.util.Optional;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.PlainAttr;
import org.apache.syncope.core.persistence.api.entity.user.LAPlainAttr;
import org.apache.syncope.core.persistence.api.entity.user.LinkedAccount;
import org.apache.syncope.core.persistence.jpa.entity.AbstractAttributable;
import org.apache.syncope.core.provisioning.api.serialization.POJOHelper;

public abstract class JSONEntityListener<A extends Any<?>, P extends PlainAttr<A>> {
    protected abstract List<? extends P> getAttrs(String var1);

    protected void json2list(AbstractAttributable<P> entity, boolean clearFirst) {
        if (clearFirst) {
            entity.getPlainAttrsList().clear();
        }
        if (entity.getPlainAttrsJSON() != null) {
            this.getAttrs(entity.getPlainAttrsJSON()).stream().filter(attr -> attr.getSchema() != null).map(attr -> {
                if (entity instanceof Any) {
                    attr.setOwner((Any)entity);
                } else if (entity instanceof LinkedAccount) {
                    LinkedAccount linkedAccount = (LinkedAccount)entity;
                    attr.setOwner((Any)linkedAccount.getOwner());
                    ((LAPlainAttr)attr).setAccount(linkedAccount);
                }
                attr.getValues().forEach(value -> value.setAttr(attr));
                Optional.ofNullable(attr.getUniqueValue()).ifPresent(value -> value.setAttr(attr));
                return attr;
            }).forEach(attr -> entity.add((PlainAttr)attr));
        }
    }

    protected void list2json(AbstractAttributable<P> entity) {
        entity.setPlainAttrsJSON(entity.getPlainAttrsList().isEmpty() ? "[]" : POJOHelper.serialize(entity.getPlainAttrsList()));
    }
}

