/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.entity;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.Lob;
import jakarta.persistence.Table;
import jakarta.validation.constraints.NotNull;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.StateManager;
import org.apache.syncope.common.lib.types.SRARouteFilter;
import org.apache.syncope.common.lib.types.SRARoutePredicate;
import org.apache.syncope.common.lib.types.SRARouteType;
import org.apache.syncope.core.persistence.api.entity.SRARoute;
import org.apache.syncope.core.persistence.common.validation.SRARouteCheck;
import org.apache.syncope.core.persistence.jpa.entity.AbstractGeneratedKeyEntity;
import org.apache.syncope.core.provisioning.api.serialization.POJOHelper;

@Entity
@Table(name="SRARoute")
@SRARouteCheck
public class JPASRARoute
extends AbstractGeneratedKeyEntity
implements SRARoute,
PersistenceCapable {
    private static final long serialVersionUID = -8718852361106840530L;
    public static final String TABLE = "SRARoute";
    @Column(unique=true, nullable=false)
    private String name;
    @NotNull
    private String target;
    private String error;
    @NotNull
    @Enumerated(value=EnumType.STRING)
    private SRARouteType routeType;
    @NotNull
    private Boolean logout = false;
    private String postLogout;
    @NotNull
    private Boolean csrf = true;
    private Integer routeOrder;
    @Lob
    private String predicates;
    @Lob
    private String filters;
    private static int pcInheritedFieldCount = AbstractGeneratedKeyEntity.pcGetManagedFieldCount();
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;

    public String getName() {
        return JPASRARoute.pcGetname(this);
    }

    public void setName(String name) {
        JPASRARoute.pcSetname(this, name);
    }

    public URI getTarget() {
        return Optional.ofNullable(JPASRARoute.pcGettarget(this)).map(URI::create).orElse(null);
    }

    public void setTarget(URI target) {
        JPASRARoute.pcSettarget(this, Optional.ofNullable(target).map(URI::toASCIIString).orElse(null));
    }

    public URI getError() {
        return Optional.ofNullable(JPASRARoute.pcGeterror(this)).map(URI::create).orElse(null);
    }

    public void setError(URI error) {
        JPASRARoute.pcSeterror(this, Optional.ofNullable(error).map(URI::toASCIIString).orElse(null));
    }

    public SRARouteType getType() {
        return JPASRARoute.pcGetrouteType(this);
    }

    public void setType(SRARouteType type) {
        JPASRARoute.pcSetrouteType(this, type);
    }

    public boolean isLogout() {
        return BooleanUtils.isNotFalse((Boolean)JPASRARoute.pcGetlogout(this));
    }

    public void setLogout(boolean logout) {
        JPASRARoute.pcSetlogout(this, logout);
    }

    public URI getPostLogout() {
        return Optional.ofNullable(JPASRARoute.pcGetpostLogout(this)).map(URI::create).orElse(null);
    }

    public void setPostLogout(URI postLogout) {
        JPASRARoute.pcSetpostLogout(this, Optional.ofNullable(postLogout).map(URI::toASCIIString).orElse(null));
    }

    public boolean isCsrf() {
        return JPASRARoute.pcGetcsrf(this);
    }

    public void setCsrf(boolean csrf) {
        JPASRARoute.pcSetcsrf(this, csrf);
    }

    public int getOrder() {
        return Optional.ofNullable(JPASRARoute.pcGetrouteOrder(this)).orElse(0);
    }

    public void setOrder(int order) {
        JPASRARoute.pcSetrouteOrder(this, order);
    }

    public List<SRARouteFilter> getFilters() {
        return Optional.ofNullable(JPASRARoute.pcGetfilters(this)).map(f -> List.of((SRARouteFilter[])POJOHelper.deserialize((String)f, SRARouteFilter[].class))).orElse(List.of());
    }

    public void setFilters(List<SRARouteFilter> filters) {
        JPASRARoute.pcSetfilters(this, POJOHelper.serialize(filters));
    }

    public List<SRARoutePredicate> getPredicates() {
        return Optional.ofNullable(JPASRARoute.pcGetpredicates(this)).map(f -> List.of((SRARoutePredicate[])POJOHelper.deserialize((String)f, SRARoutePredicate[].class))).orElse(List.of());
    }

    public void setPredicates(List<SRARoutePredicate> predicates) {
        JPASRARoute.pcSetpredicates(this, POJOHelper.serialize(predicates));
    }

    @Override
    public int pcGetEnhancementContractVersion() {
        return 117245485;
    }

    static {
        pcPCSuperclass = AbstractGeneratedKeyEntity.class;
        pcFieldNames = new String[]{"csrf", "error", "filters", "logout", "name", "postLogout", "predicates", "routeOrder", "routeType", "target"};
        pcFieldTypes = new Class[]{Boolean.class, String.class, String.class, Boolean.class, String.class, String.class, String.class, Integer.class, SRARouteType.class, String.class};
        pcFieldFlags = new byte[]{26, 26, 26, 26, 26, 26, 26, 26, 26, 26};
        PCRegistry.register(JPASRARoute.class, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"JPASRARoute", (PersistenceCapable)new JPASRARoute());
    }

    @Override
    protected void pcClearFields() {
        super.pcClearFields();
        this.csrf = null;
        this.error = null;
        this.filters = null;
        this.logout = null;
        this.name = null;
        this.postLogout = null;
        this.predicates = null;
        this.routeOrder = null;
        this.routeType = null;
        this.target = null;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        JPASRARoute jPASRARoute = new JPASRARoute();
        if (bl) {
            jPASRARoute.pcClearFields();
        }
        jPASRARoute.pcStateManager = stateManager;
        jPASRARoute.pcCopyKeyFieldsFromObjectId(object);
        return jPASRARoute;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        JPASRARoute jPASRARoute = new JPASRARoute();
        if (bl) {
            jPASRARoute.pcClearFields();
        }
        jPASRARoute.pcStateManager = stateManager;
        return jPASRARoute;
    }

    protected static int pcGetManagedFieldCount() {
        return 10 + AbstractGeneratedKeyEntity.pcGetManagedFieldCount();
    }

    @Override
    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcReplaceField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.csrf = (Boolean)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.error = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.filters = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.logout = (Boolean)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 4: {
                this.name = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 5: {
                this.postLogout = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 6: {
                this.predicates = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 7: {
                this.routeOrder = (Integer)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 8: {
                this.routeType = (SRARouteType)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 9: {
                this.target = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcReplaceFields(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.pcReplaceField(nArray[i]);
        }
    }

    @Override
    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcProvideField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.csrf);
                return;
            }
            case 1: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.error);
                return;
            }
            case 2: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.filters);
                return;
            }
            case 3: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.logout);
                return;
            }
            case 4: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.name);
                return;
            }
            case 5: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.postLogout);
                return;
            }
            case 6: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.predicates);
                return;
            }
            case 7: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.routeOrder);
                return;
            }
            case 8: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.routeType);
                return;
            }
            case 9: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.target);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcProvideFields(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.pcProvideField(nArray[i]);
        }
    }

    protected void pcCopyField(JPASRARoute jPASRARoute, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcCopyField(jPASRARoute, n);
            return;
        }
        switch (n2) {
            case 0: {
                this.csrf = jPASRARoute.csrf;
                return;
            }
            case 1: {
                this.error = jPASRARoute.error;
                return;
            }
            case 2: {
                this.filters = jPASRARoute.filters;
                return;
            }
            case 3: {
                this.logout = jPASRARoute.logout;
                return;
            }
            case 4: {
                this.name = jPASRARoute.name;
                return;
            }
            case 5: {
                this.postLogout = jPASRARoute.postLogout;
                return;
            }
            case 6: {
                this.predicates = jPASRARoute.predicates;
                return;
            }
            case 7: {
                this.routeOrder = jPASRARoute.routeOrder;
                return;
            }
            case 8: {
                this.routeType = jPASRARoute.routeType;
                return;
            }
            case 9: {
                this.target = jPASRARoute.target;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcCopyFields(Object object, int[] nArray) {
        JPASRARoute jPASRARoute = (JPASRARoute)object;
        if (jPASRARoute.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        for (int i = 0; i < nArray.length; ++i) {
            this.pcCopyField(jPASRARoute, nArray[i]);
        }
    }

    @Override
    public Class pcGetIDOwningClass() {
        return JPASRARoute.class;
    }

    private static final Boolean pcGetcsrf(JPASRARoute jPASRARoute) {
        if (jPASRARoute.pcStateManager == null) {
            return jPASRARoute.csrf;
        }
        int n = pcInheritedFieldCount + 0;
        jPASRARoute.pcStateManager.accessingField(n);
        return jPASRARoute.csrf;
    }

    private static final void pcSetcsrf(JPASRARoute jPASRARoute, Boolean bl) {
        if (jPASRARoute.pcStateManager == null) {
            jPASRARoute.csrf = bl;
            return;
        }
        jPASRARoute.pcStateManager.settingObjectField((PersistenceCapable)jPASRARoute, pcInheritedFieldCount + 0, (Object)jPASRARoute.csrf, (Object)bl, 0);
    }

    private static final String pcGeterror(JPASRARoute jPASRARoute) {
        if (jPASRARoute.pcStateManager == null) {
            return jPASRARoute.error;
        }
        int n = pcInheritedFieldCount + 1;
        jPASRARoute.pcStateManager.accessingField(n);
        return jPASRARoute.error;
    }

    private static final void pcSeterror(JPASRARoute jPASRARoute, String string) {
        if (jPASRARoute.pcStateManager == null) {
            jPASRARoute.error = string;
            return;
        }
        jPASRARoute.pcStateManager.settingStringField((PersistenceCapable)jPASRARoute, pcInheritedFieldCount + 1, jPASRARoute.error, string, 0);
    }

    private static final String pcGetfilters(JPASRARoute jPASRARoute) {
        if (jPASRARoute.pcStateManager == null) {
            return jPASRARoute.filters;
        }
        int n = pcInheritedFieldCount + 2;
        jPASRARoute.pcStateManager.accessingField(n);
        return jPASRARoute.filters;
    }

    private static final void pcSetfilters(JPASRARoute jPASRARoute, String string) {
        if (jPASRARoute.pcStateManager == null) {
            jPASRARoute.filters = string;
            return;
        }
        jPASRARoute.pcStateManager.settingStringField((PersistenceCapable)jPASRARoute, pcInheritedFieldCount + 2, jPASRARoute.filters, string, 0);
    }

    private static final Boolean pcGetlogout(JPASRARoute jPASRARoute) {
        if (jPASRARoute.pcStateManager == null) {
            return jPASRARoute.logout;
        }
        int n = pcInheritedFieldCount + 3;
        jPASRARoute.pcStateManager.accessingField(n);
        return jPASRARoute.logout;
    }

    private static final void pcSetlogout(JPASRARoute jPASRARoute, Boolean bl) {
        if (jPASRARoute.pcStateManager == null) {
            jPASRARoute.logout = bl;
            return;
        }
        jPASRARoute.pcStateManager.settingObjectField((PersistenceCapable)jPASRARoute, pcInheritedFieldCount + 3, (Object)jPASRARoute.logout, (Object)bl, 0);
    }

    private static final String pcGetname(JPASRARoute jPASRARoute) {
        if (jPASRARoute.pcStateManager == null) {
            return jPASRARoute.name;
        }
        int n = pcInheritedFieldCount + 4;
        jPASRARoute.pcStateManager.accessingField(n);
        return jPASRARoute.name;
    }

    private static final void pcSetname(JPASRARoute jPASRARoute, String string) {
        if (jPASRARoute.pcStateManager == null) {
            jPASRARoute.name = string;
            return;
        }
        jPASRARoute.pcStateManager.settingStringField((PersistenceCapable)jPASRARoute, pcInheritedFieldCount + 4, jPASRARoute.name, string, 0);
    }

    private static final String pcGetpostLogout(JPASRARoute jPASRARoute) {
        if (jPASRARoute.pcStateManager == null) {
            return jPASRARoute.postLogout;
        }
        int n = pcInheritedFieldCount + 5;
        jPASRARoute.pcStateManager.accessingField(n);
        return jPASRARoute.postLogout;
    }

    private static final void pcSetpostLogout(JPASRARoute jPASRARoute, String string) {
        if (jPASRARoute.pcStateManager == null) {
            jPASRARoute.postLogout = string;
            return;
        }
        jPASRARoute.pcStateManager.settingStringField((PersistenceCapable)jPASRARoute, pcInheritedFieldCount + 5, jPASRARoute.postLogout, string, 0);
    }

    private static final String pcGetpredicates(JPASRARoute jPASRARoute) {
        if (jPASRARoute.pcStateManager == null) {
            return jPASRARoute.predicates;
        }
        int n = pcInheritedFieldCount + 6;
        jPASRARoute.pcStateManager.accessingField(n);
        return jPASRARoute.predicates;
    }

    private static final void pcSetpredicates(JPASRARoute jPASRARoute, String string) {
        if (jPASRARoute.pcStateManager == null) {
            jPASRARoute.predicates = string;
            return;
        }
        jPASRARoute.pcStateManager.settingStringField((PersistenceCapable)jPASRARoute, pcInheritedFieldCount + 6, jPASRARoute.predicates, string, 0);
    }

    private static final Integer pcGetrouteOrder(JPASRARoute jPASRARoute) {
        if (jPASRARoute.pcStateManager == null) {
            return jPASRARoute.routeOrder;
        }
        int n = pcInheritedFieldCount + 7;
        jPASRARoute.pcStateManager.accessingField(n);
        return jPASRARoute.routeOrder;
    }

    private static final void pcSetrouteOrder(JPASRARoute jPASRARoute, Integer n) {
        if (jPASRARoute.pcStateManager == null) {
            jPASRARoute.routeOrder = n;
            return;
        }
        jPASRARoute.pcStateManager.settingObjectField((PersistenceCapable)jPASRARoute, pcInheritedFieldCount + 7, (Object)jPASRARoute.routeOrder, (Object)n, 0);
    }

    private static final SRARouteType pcGetrouteType(JPASRARoute jPASRARoute) {
        if (jPASRARoute.pcStateManager == null) {
            return jPASRARoute.routeType;
        }
        int n = pcInheritedFieldCount + 8;
        jPASRARoute.pcStateManager.accessingField(n);
        return jPASRARoute.routeType;
    }

    private static final void pcSetrouteType(JPASRARoute jPASRARoute, SRARouteType sRARouteType) {
        if (jPASRARoute.pcStateManager == null) {
            jPASRARoute.routeType = sRARouteType;
            return;
        }
        jPASRARoute.pcStateManager.settingObjectField((PersistenceCapable)jPASRARoute, pcInheritedFieldCount + 8, (Object)jPASRARoute.routeType, (Object)sRARouteType, 0);
    }

    private static final String pcGettarget(JPASRARoute jPASRARoute) {
        if (jPASRARoute.pcStateManager == null) {
            return jPASRARoute.target;
        }
        int n = pcInheritedFieldCount + 9;
        jPASRARoute.pcStateManager.accessingField(n);
        return jPASRARoute.target;
    }

    private static final void pcSettarget(JPASRARoute jPASRARoute, String string) {
        if (jPASRARoute.pcStateManager == null) {
            jPASRARoute.target = string;
            return;
        }
        jPASRARoute.pcStateManager.settingStringField((PersistenceCapable)jPASRARoute, pcInheritedFieldCount + 9, jPASRARoute.target, string, 0);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = this.pcSerializing();
        objectOutputStream.defaultWriteObject();
        if (bl) {
            this.pcSetDetachedState(null);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.pcSetDetachedState(PersistenceCapable.DESERIALIZED);
        objectInputStream.defaultReadObject();
    }
}

