/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.entity;

import jakarta.persistence.Cacheable;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.persistence.UniqueConstraint;
import jakarta.validation.constraints.NotNull;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.time.OffsetDateTime;
import java.util.HashSet;
import java.util.Set;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.StateManager;
import org.apache.syncope.core.persistence.api.entity.Delegation;
import org.apache.syncope.core.persistence.api.entity.Role;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.persistence.common.validation.DelegationCheck;
import org.apache.syncope.core.persistence.jpa.entity.AbstractGeneratedKeyEntity;
import org.apache.syncope.core.persistence.jpa.entity.JPARole;
import org.apache.syncope.core.persistence.jpa.entity.user.JPAUser;

@Entity
@Table(name="Delegation", uniqueConstraints={@UniqueConstraint(columnNames={"delegating_id", "delegated_id"})})
@Cacheable
@DelegationCheck
public class JPADelegation
extends AbstractGeneratedKeyEntity
implements Delegation,
PersistenceCapable {
    private static final long serialVersionUID = 17988340419552L;
    public static final String TABLE = "Delegation";
    @ManyToOne(optional=false)
    private JPAUser delegating;
    @ManyToOne(optional=false)
    private JPAUser delegated;
    @NotNull
    @Column(nullable=false)
    private OffsetDateTime startDate;
    private OffsetDateTime endDate;
    @OneToMany
    private Set<JPARole> roles = new HashSet<JPARole>();
    private static int pcInheritedFieldCount = AbstractGeneratedKeyEntity.pcGetManagedFieldCount();
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;

    public User getDelegating() {
        return JPADelegation.pcGetdelegating(this);
    }

    public void setDelegating(User delegating) {
        this.checkType(delegating, JPAUser.class);
        JPADelegation.pcSetdelegating(this, (JPAUser)delegating);
    }

    public User getDelegated() {
        return JPADelegation.pcGetdelegated(this);
    }

    public void setDelegated(User delegated) {
        this.checkType(delegated, JPAUser.class);
        JPADelegation.pcSetdelegated(this, (JPAUser)delegated);
    }

    public OffsetDateTime getStart() {
        return JPADelegation.pcGetstartDate(this);
    }

    public void setStart(OffsetDateTime start) {
        JPADelegation.pcSetstartDate(this, start);
    }

    public OffsetDateTime getEnd() {
        return JPADelegation.pcGetendDate(this);
    }

    public void setEnd(OffsetDateTime end) {
        JPADelegation.pcSetendDate(this, end);
    }

    public boolean add(Role role) {
        this.checkType(role, JPARole.class);
        return JPADelegation.pcGetroles(this).add((JPARole)role);
    }

    public Set<? extends Role> getRoles() {
        return JPADelegation.pcGetroles(this);
    }

    @Override
    public int pcGetEnhancementContractVersion() {
        return 117245485;
    }

    static {
        pcPCSuperclass = AbstractGeneratedKeyEntity.class;
        pcFieldNames = new String[]{"delegated", "delegating", "endDate", "roles", "startDate"};
        pcFieldTypes = new Class[]{JPAUser.class, JPAUser.class, OffsetDateTime.class, Set.class, OffsetDateTime.class};
        pcFieldFlags = new byte[]{26, 26, 26, 5, 26};
        PCRegistry.register(JPADelegation.class, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"JPADelegation", (PersistenceCapable)new JPADelegation());
    }

    @Override
    protected void pcClearFields() {
        super.pcClearFields();
        this.delegated = null;
        this.delegating = null;
        this.endDate = null;
        this.roles = null;
        this.startDate = null;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        JPADelegation jPADelegation = new JPADelegation();
        if (bl) {
            jPADelegation.pcClearFields();
        }
        jPADelegation.pcStateManager = stateManager;
        jPADelegation.pcCopyKeyFieldsFromObjectId(object);
        return jPADelegation;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        JPADelegation jPADelegation = new JPADelegation();
        if (bl) {
            jPADelegation.pcClearFields();
        }
        jPADelegation.pcStateManager = stateManager;
        return jPADelegation;
    }

    protected static int pcGetManagedFieldCount() {
        return 5 + AbstractGeneratedKeyEntity.pcGetManagedFieldCount();
    }

    @Override
    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcReplaceField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.delegated = (JPAUser)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.delegating = (JPAUser)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.endDate = (OffsetDateTime)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.roles = (Set)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 4: {
                this.startDate = (OffsetDateTime)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcReplaceFields(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.pcReplaceField(nArray[i]);
        }
    }

    @Override
    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcProvideField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.delegated);
                return;
            }
            case 1: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.delegating);
                return;
            }
            case 2: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.endDate);
                return;
            }
            case 3: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.roles);
                return;
            }
            case 4: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.startDate);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcProvideFields(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.pcProvideField(nArray[i]);
        }
    }

    protected void pcCopyField(JPADelegation jPADelegation, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcCopyField(jPADelegation, n);
            return;
        }
        switch (n2) {
            case 0: {
                this.delegated = jPADelegation.delegated;
                return;
            }
            case 1: {
                this.delegating = jPADelegation.delegating;
                return;
            }
            case 2: {
                this.endDate = jPADelegation.endDate;
                return;
            }
            case 3: {
                this.roles = jPADelegation.roles;
                return;
            }
            case 4: {
                this.startDate = jPADelegation.startDate;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcCopyFields(Object object, int[] nArray) {
        JPADelegation jPADelegation = (JPADelegation)object;
        if (jPADelegation.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        for (int i = 0; i < nArray.length; ++i) {
            this.pcCopyField(jPADelegation, nArray[i]);
        }
    }

    @Override
    public Class pcGetIDOwningClass() {
        return JPADelegation.class;
    }

    private static final JPAUser pcGetdelegated(JPADelegation jPADelegation) {
        if (jPADelegation.pcStateManager == null) {
            return jPADelegation.delegated;
        }
        int n = pcInheritedFieldCount + 0;
        jPADelegation.pcStateManager.accessingField(n);
        return jPADelegation.delegated;
    }

    private static final void pcSetdelegated(JPADelegation jPADelegation, JPAUser jPAUser) {
        if (jPADelegation.pcStateManager == null) {
            jPADelegation.delegated = jPAUser;
            return;
        }
        jPADelegation.pcStateManager.settingObjectField((PersistenceCapable)jPADelegation, pcInheritedFieldCount + 0, (Object)jPADelegation.delegated, (Object)jPAUser, 0);
    }

    private static final JPAUser pcGetdelegating(JPADelegation jPADelegation) {
        if (jPADelegation.pcStateManager == null) {
            return jPADelegation.delegating;
        }
        int n = pcInheritedFieldCount + 1;
        jPADelegation.pcStateManager.accessingField(n);
        return jPADelegation.delegating;
    }

    private static final void pcSetdelegating(JPADelegation jPADelegation, JPAUser jPAUser) {
        if (jPADelegation.pcStateManager == null) {
            jPADelegation.delegating = jPAUser;
            return;
        }
        jPADelegation.pcStateManager.settingObjectField((PersistenceCapable)jPADelegation, pcInheritedFieldCount + 1, (Object)jPADelegation.delegating, (Object)jPAUser, 0);
    }

    private static final OffsetDateTime pcGetendDate(JPADelegation jPADelegation) {
        if (jPADelegation.pcStateManager == null) {
            return jPADelegation.endDate;
        }
        int n = pcInheritedFieldCount + 2;
        jPADelegation.pcStateManager.accessingField(n);
        return jPADelegation.endDate;
    }

    private static final void pcSetendDate(JPADelegation jPADelegation, OffsetDateTime offsetDateTime) {
        if (jPADelegation.pcStateManager == null) {
            jPADelegation.endDate = offsetDateTime;
            return;
        }
        jPADelegation.pcStateManager.settingObjectField((PersistenceCapable)jPADelegation, pcInheritedFieldCount + 2, (Object)jPADelegation.endDate, (Object)offsetDateTime, 0);
    }

    private static final Set pcGetroles(JPADelegation jPADelegation) {
        if (jPADelegation.pcStateManager == null) {
            return jPADelegation.roles;
        }
        int n = pcInheritedFieldCount + 3;
        jPADelegation.pcStateManager.accessingField(n);
        return jPADelegation.roles;
    }

    private static final void pcSetroles(JPADelegation jPADelegation, Set set) {
        if (jPADelegation.pcStateManager == null) {
            jPADelegation.roles = set;
            return;
        }
        jPADelegation.pcStateManager.settingObjectField((PersistenceCapable)jPADelegation, pcInheritedFieldCount + 3, jPADelegation.roles, (Object)set, 0);
    }

    private static final OffsetDateTime pcGetstartDate(JPADelegation jPADelegation) {
        if (jPADelegation.pcStateManager == null) {
            return jPADelegation.startDate;
        }
        int n = pcInheritedFieldCount + 4;
        jPADelegation.pcStateManager.accessingField(n);
        return jPADelegation.startDate;
    }

    private static final void pcSetstartDate(JPADelegation jPADelegation, OffsetDateTime offsetDateTime) {
        if (jPADelegation.pcStateManager == null) {
            jPADelegation.startDate = offsetDateTime;
            return;
        }
        jPADelegation.pcStateManager.settingObjectField((PersistenceCapable)jPADelegation, pcInheritedFieldCount + 4, (Object)jPADelegation.startDate, (Object)offsetDateTime, 0);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = this.pcSerializing();
        objectOutputStream.defaultWriteObject();
        if (bl) {
            this.pcSetDetachedState(null);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.pcSetDetachedState(PersistenceCapable.DESERIALIZED);
        objectInputStream.defaultReadObject();
    }
}

