/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.entity;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.StateManager;
import org.apache.syncope.core.persistence.api.entity.Application;
import org.apache.syncope.core.persistence.api.entity.Privilege;
import org.apache.syncope.core.persistence.common.validation.ApplicationCheck;
import org.apache.syncope.core.persistence.jpa.entity.AbstractProvidedKeyEntity;
import org.apache.syncope.core.persistence.jpa.entity.JPAPrivilege;

@Entity
@Table(name="Application")
@ApplicationCheck
public class JPAApplication
extends AbstractProvidedKeyEntity
implements Application,
PersistenceCapable {
    private static final long serialVersionUID = -5951400197744722305L;
    public static final String TABLE = "Application";
    private String description;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.EAGER, mappedBy="application")
    private List<JPAPrivilege> privileges = new ArrayList<JPAPrivilege>();
    private static int pcInheritedFieldCount = AbstractProvidedKeyEntity.pcGetManagedFieldCount();
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;

    public String getDescription() {
        return JPAApplication.pcGetdescription(this);
    }

    public void setDescription(String description) {
        JPAApplication.pcSetdescription(this, description);
    }

    public boolean add(Privilege privilege) {
        this.checkType(privilege, JPAPrivilege.class);
        return JPAApplication.pcGetprivileges(this).contains((JPAPrivilege)privilege) || JPAApplication.pcGetprivileges(this).add((JPAPrivilege)privilege);
    }

    public Optional<? extends Privilege> getPrivilege(String key) {
        return JPAApplication.pcGetprivileges(this).stream().filter(privilege -> privilege.getKey().equals(key)).findFirst();
    }

    public List<? extends Privilege> getPrivileges() {
        return JPAApplication.pcGetprivileges(this);
    }

    @Override
    public int pcGetEnhancementContractVersion() {
        return 117245485;
    }

    static {
        pcPCSuperclass = AbstractProvidedKeyEntity.class;
        pcFieldNames = new String[]{"description", "privileges"};
        pcFieldTypes = new Class[]{String.class, List.class};
        pcFieldFlags = new byte[]{26, 10};
        PCRegistry.register(JPAApplication.class, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"JPAApplication", (PersistenceCapable)new JPAApplication());
    }

    @Override
    protected void pcClearFields() {
        super.pcClearFields();
        this.description = null;
        this.privileges = null;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        JPAApplication jPAApplication = new JPAApplication();
        if (bl) {
            jPAApplication.pcClearFields();
        }
        jPAApplication.pcStateManager = stateManager;
        jPAApplication.pcCopyKeyFieldsFromObjectId(object);
        return jPAApplication;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        JPAApplication jPAApplication = new JPAApplication();
        if (bl) {
            jPAApplication.pcClearFields();
        }
        jPAApplication.pcStateManager = stateManager;
        return jPAApplication;
    }

    protected static int pcGetManagedFieldCount() {
        return 2 + AbstractProvidedKeyEntity.pcGetManagedFieldCount();
    }

    @Override
    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcReplaceField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.description = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.privileges = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcReplaceFields(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.pcReplaceField(nArray[i]);
        }
    }

    @Override
    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcProvideField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.description);
                return;
            }
            case 1: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.privileges);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcProvideFields(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.pcProvideField(nArray[i]);
        }
    }

    protected void pcCopyField(JPAApplication jPAApplication, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcCopyField(jPAApplication, n);
            return;
        }
        switch (n2) {
            case 0: {
                this.description = jPAApplication.description;
                return;
            }
            case 1: {
                this.privileges = jPAApplication.privileges;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcCopyFields(Object object, int[] nArray) {
        JPAApplication jPAApplication = (JPAApplication)object;
        if (jPAApplication.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        for (int i = 0; i < nArray.length; ++i) {
            this.pcCopyField(jPAApplication, nArray[i]);
        }
    }

    @Override
    public Class pcGetIDOwningClass() {
        return JPAApplication.class;
    }

    private static final String pcGetdescription(JPAApplication jPAApplication) {
        if (jPAApplication.pcStateManager == null) {
            return jPAApplication.description;
        }
        int n = pcInheritedFieldCount + 0;
        jPAApplication.pcStateManager.accessingField(n);
        return jPAApplication.description;
    }

    private static final void pcSetdescription(JPAApplication jPAApplication, String string) {
        if (jPAApplication.pcStateManager == null) {
            jPAApplication.description = string;
            return;
        }
        jPAApplication.pcStateManager.settingStringField((PersistenceCapable)jPAApplication, pcInheritedFieldCount + 0, jPAApplication.description, string, 0);
    }

    private static final List pcGetprivileges(JPAApplication jPAApplication) {
        if (jPAApplication.pcStateManager == null) {
            return jPAApplication.privileges;
        }
        int n = pcInheritedFieldCount + 1;
        jPAApplication.pcStateManager.accessingField(n);
        return jPAApplication.privileges;
    }

    private static final void pcSetprivileges(JPAApplication jPAApplication, List list) {
        if (jPAApplication.pcStateManager == null) {
            jPAApplication.privileges = list;
            return;
        }
        jPAApplication.pcStateManager.settingObjectField((PersistenceCapable)jPAApplication, pcInheritedFieldCount + 1, jPAApplication.privileges, (Object)list, 0);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = this.pcSerializing();
        objectOutputStream.defaultWriteObject();
        if (bl) {
            this.pcSetDetachedState(null);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.pcSetDetachedState(PersistenceCapable.DESERIALIZED);
        objectInputStream.defaultReadObject();
    }
}

