/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.time.OffsetDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.Base64;
import java.util.Optional;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.syncope.common.lib.types.AttrSchemaType;
import org.apache.syncope.core.persistence.api.attrvalue.ParsingValidationException;
import org.apache.syncope.core.persistence.api.entity.PlainAttrValue;
import org.apache.syncope.core.persistence.api.entity.PlainSchema;
import org.apache.syncope.core.persistence.api.utils.FormatUtils;
import org.apache.syncope.core.spring.ApplicationContextProvider;
import org.apache.syncope.core.spring.security.Encryptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(value={"valueAsString", "value"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public abstract class AbstractPlainAttrValue
implements PlainAttrValue {
    private static final long serialVersionUID = -9141923816611244785L;
    protected static final Logger LOG = LoggerFactory.getLogger(PlainAttrValue.class);
    private static final Pattern SPRING_ENV_PROPERTY = Pattern.compile("^\\$\\{.*\\}$");
    private String stringValue;
    private OffsetDateTime dateValue;
    private Boolean booleanValue;
    private Long longValue;
    private Double doubleValue;
    private byte[] binaryValue;

    @JsonIgnore
    public String getKey() {
        return null;
    }

    public Boolean getBooleanValue() {
        return this.booleanValue;
    }

    public void setBooleanValue(Boolean booleanValue) {
        this.booleanValue = booleanValue;
    }

    public OffsetDateTime getDateValue() {
        return this.dateValue;
    }

    public void setDateValue(OffsetDateTime dateValue) {
        this.dateValue = dateValue;
    }

    public Double getDoubleValue() {
        return this.doubleValue;
    }

    public void setDoubleValue(Double doubleValue) {
        this.doubleValue = doubleValue;
    }

    public Long getLongValue() {
        return this.longValue;
    }

    public void setLongValue(Long longValue) {
        this.longValue = longValue;
    }

    public String getStringValue() {
        return this.dateValue == null && this.booleanValue == null && this.longValue == null && this.doubleValue == null && this.binaryValue == null && this.stringValue == null ? "" : this.stringValue;
    }

    public void setStringValue(String stringValue) {
        this.stringValue = stringValue;
    }

    public byte[] getBinaryValue() {
        return this.binaryValue;
    }

    public void setBinaryValue(byte[] binaryValue) {
        this.binaryValue = ArrayUtils.clone((byte[])binaryValue);
    }

    protected String getSecretKey(PlainSchema schema) {
        return SPRING_ENV_PROPERTY.matcher(schema.getSecretKey()).matches() ? ApplicationContextProvider.getApplicationContext().getEnvironment().getProperty(StringUtils.substringBetween((String)schema.getSecretKey(), (String)"${", (String)"}")) : schema.getSecretKey();
    }

    public void parseValue(PlainSchema schema, String value) {
        Exception exception = null;
        switch (schema.getType()) {
            case Boolean: {
                this.setBooleanValue(Boolean.valueOf(value));
                break;
            }
            case Long: {
                try {
                    this.setLongValue(schema.getConversionPattern() == null ? Long.valueOf(value).longValue() : FormatUtils.parseNumber((String)value, (String)schema.getConversionPattern()).longValue());
                }
                catch (Exception pe) {
                    exception = pe;
                }
                break;
            }
            case Double: {
                try {
                    this.setDoubleValue(schema.getConversionPattern() == null ? Double.valueOf(value).doubleValue() : FormatUtils.parseNumber((String)value, (String)schema.getConversionPattern()).doubleValue());
                }
                catch (Exception pe) {
                    exception = pe;
                }
                break;
            }
            case Date: {
                try {
                    this.setDateValue(schema.getConversionPattern() == null ? FormatUtils.parseDate((String)value) : FormatUtils.parseDate((String)value, (String)schema.getConversionPattern()));
                }
                catch (Exception pe) {
                    exception = pe;
                }
                break;
            }
            case Encrypted: {
                try {
                    this.setStringValue(Encryptor.getInstance((String)this.getSecretKey(schema)).encode(value, schema.getCipherAlgorithm()));
                }
                catch (Exception pe) {
                    exception = pe;
                }
                break;
            }
            case Binary: {
                this.setBinaryValue(Base64.getDecoder().decode(value));
                break;
            }
            default: {
                this.setStringValue(value);
            }
        }
        if (exception != null) {
            throw new ParsingValidationException("While trying to parse '" + value + "' as " + schema.getKey(), (Throwable)exception);
        }
    }

    public <T> T getValue() {
        return (T)(this.booleanValue != null ? this.getBooleanValue() : (this.dateValue != null ? this.getDateValue() : (this.doubleValue != null ? this.getDoubleValue() : (this.longValue != null ? this.getLongValue() : (this.binaryValue != null ? (Object)this.getBinaryValue() : this.getStringValue())))));
    }

    private Object getValue(AttrSchemaType type) {
        return switch (type) {
            case AttrSchemaType.Boolean -> this.getBooleanValue();
            case AttrSchemaType.Long -> this.getLongValue();
            case AttrSchemaType.Double -> this.getDoubleValue();
            case AttrSchemaType.Date -> this.getDateValue();
            case AttrSchemaType.Binary -> this.getBinaryValue();
            case AttrSchemaType.Encrypted, AttrSchemaType.String, AttrSchemaType.Dropdown, AttrSchemaType.Enum -> this.getStringValue();
            default -> null;
        };
    }

    private String getValueAsString(AttrSchemaType type, PlainSchema schema) {
        if (this.getValue(type) == null) {
            LOG.warn("Could not find expected value for type {} in {}, reverting to getValue().toString()", (Object)type, (Object)this);
            Object value = this.getValue();
            return Optional.ofNullable(value).map(Object::toString).orElse(null);
        }
        return switch (type) {
            case AttrSchemaType.Boolean -> this.getBooleanValue().toString();
            case AttrSchemaType.Long -> schema == null || schema.getConversionPattern() == null ? this.getLongValue().toString() : FormatUtils.format((long)this.getLongValue(), (String)schema.getConversionPattern());
            case AttrSchemaType.Double -> schema == null || schema.getConversionPattern() == null ? this.getDoubleValue().toString() : FormatUtils.format((double)this.getDoubleValue(), (String)schema.getConversionPattern());
            case AttrSchemaType.Date -> schema == null || schema.getConversionPattern() == null ? FormatUtils.format((TemporalAccessor)this.getDateValue()) : FormatUtils.format((TemporalAccessor)this.getDateValue(), (String)schema.getConversionPattern());
            case AttrSchemaType.Binary -> Base64.getEncoder().encodeToString(this.getBinaryValue());
            case AttrSchemaType.Encrypted -> {
                if (schema == null || !"ENCRYPTED_DECODE_CONVERSION_PATTERN".equals(schema.getConversionPattern()) || !schema.getCipherAlgorithm().isInvertible()) {
                    yield this.getStringValue();
                }
                try {
                    yield Encryptor.getInstance((String)this.getSecretKey(schema)).decode(this.getStringValue(), schema.getCipherAlgorithm());
                }
                catch (Exception e) {
                    LOG.error("Could not decode encrypted value {} for schema {}", new Object[]{this.getStringValue(), schema, e});
                    yield this.getStringValue();
                }
            }
            default -> this.getStringValue();
        };
    }

    public String getValueAsString() {
        PlainSchema schema = this.getAttr() == null || this.getAttr().getSchema() == null ? null : this.getAttr().getSchema();
        AttrSchemaType type = schema == null || schema.getType() == null ? AttrSchemaType.String : this.getAttr().getSchema().getType();
        return this.getValueAsString(type, schema);
    }

    public String getValueAsString(AttrSchemaType type) {
        return this.getValueAsString(type, this.getAttr() == null || this.getAttr().getSchema() == null ? null : this.getAttr().getSchema());
    }

    public String getValueAsString(PlainSchema schema) {
        return this.getValueAsString(schema.getType(), schema);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append((Object)this.getKey()).append((Object)this.stringValue).append((Object)this.dateValue).append((Object)this.booleanValue).append((Object)this.longValue).append((Object)this.doubleValue).append(this.binaryValue).build();
    }
}

