/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.entity;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import jakarta.validation.constraints.NotNull;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.syncope.core.persistence.api.attrvalue.PlainAttrValidationManager;
import org.apache.syncope.core.persistence.api.dao.PlainSchemaDAO;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyUtils;
import org.apache.syncope.core.persistence.api.entity.PlainAttr;
import org.apache.syncope.core.persistence.api.entity.PlainAttrUniqueValue;
import org.apache.syncope.core.persistence.api.entity.PlainAttrValue;
import org.apache.syncope.core.persistence.api.entity.PlainSchema;
import org.apache.syncope.core.persistence.jpa.entity.JPAPlainSchema;
import org.apache.syncope.core.spring.ApplicationContextProvider;

@JsonIgnoreProperties(value={"valuesAsStrings"})
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public abstract class AbstractPlainAttr<O extends Any<?>>
implements PlainAttr<O> {
    private static final long serialVersionUID = -9115431608821806124L;
    @JsonProperty(value="schema")
    @NotNull
    private String schemaKey;

    @JsonIgnore
    public String getKey() {
        return null;
    }

    @JsonGetter(value="schema")
    public String getSchemaKey() {
        return this.schemaKey;
    }

    @JsonIgnore
    public JPAPlainSchema getSchema() {
        return Optional.ofNullable(this.schemaKey).flatMap(s -> ((PlainSchemaDAO)ApplicationContextProvider.getBeanFactory().getBean(PlainSchemaDAO.class)).findById(s)).map(JPAPlainSchema.class::cast).orElse(null);
    }

    @JsonIgnore
    public void setSchema(PlainSchema schema) {
        if (schema != null) {
            this.schemaKey = schema.getKey();
        }
    }

    @JsonSetter(value="schema")
    public void setSchema(String schemaKey) {
        this.schemaKey = schemaKey;
    }

    protected abstract boolean addForMultiValue(PlainAttrValue var1);

    public void add(PlainAttrValue attrValue) {
        this.addForMultiValue(attrValue);
    }

    private void checkNonNullSchema() {
        if (this.getSchema() == null) {
            throw new IllegalStateException("First set owner then schema and finally add values");
        }
    }

    public void add(PlainAttrValidationManager validator, String value, PlainAttrValue attrValue) {
        this.checkNonNullSchema();
        attrValue.setAttr((PlainAttr)this);
        validator.validate((PlainSchema)this.getSchema(), value, attrValue);
        if (this.getSchema().isUniqueConstraint()) {
            this.setUniqueValue((PlainAttrUniqueValue)attrValue);
        } else {
            if (!this.getSchema().isMultivalue()) {
                this.getValues().clear();
            }
            this.addForMultiValue(attrValue);
        }
    }

    public void add(PlainAttrValidationManager validator, String value, AnyUtils anyUtils) {
        PlainAttrUniqueValue attrValue;
        this.checkNonNullSchema();
        if (this.getSchema().isUniqueConstraint()) {
            attrValue = anyUtils.newPlainAttrUniqueValue();
            attrValue.setSchema((PlainSchema)this.getSchema());
        } else {
            attrValue = anyUtils.newPlainAttrValue();
        }
        this.add(validator, value, (PlainAttrValue)attrValue);
    }

    public List<String> getValuesAsStrings() {
        List<String> result = this.getUniqueValue() == null ? this.getValues().stream().map(PlainAttrValue::getValueAsString).toList() : List.of(this.getUniqueValue().getValueAsString());
        return Collections.unmodifiableList(result);
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.schemaKey).build();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractPlainAttr other = (AbstractPlainAttr)obj;
        return new EqualsBuilder().append((Object)this.schemaKey, (Object)other.schemaKey).build();
    }
}

