/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.entity;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.GroupablePlainAttr;
import org.apache.syncope.core.persistence.api.entity.GroupableRelatable;
import org.apache.syncope.core.persistence.api.entity.Membership;
import org.apache.syncope.core.persistence.api.entity.Relationship;
import org.apache.syncope.core.persistence.api.entity.RelationshipType;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.persistence.jpa.entity.AbstractAny;

public abstract class AbstractGroupableRelatable<L extends Any<P>, M extends Membership<L>, P extends GroupablePlainAttr<L, M>, R extends Any<?>, REL extends Relationship<L, R>>
extends AbstractAny<P>
implements GroupableRelatable<L, M, P, R, REL> {
    private static final long serialVersionUID = -2269285197388729673L;

    public List<? extends P> getPlainAttrs() {
        return this.getPlainAttrsList().stream().filter(attr -> attr.getMembershipKey() == null).toList();
    }

    public Optional<? extends P> getPlainAttr(String plainSchema) {
        return this.getPlainAttrsList().stream().filter(attr -> attr.getMembershipKey() == null && plainSchema.equals(attr.getSchemaKey())).findFirst();
    }

    public Optional<? extends P> getPlainAttr(String plainSchema, Membership<?> membership) {
        return this.getPlainAttrsList().stream().filter(attr -> plainSchema.equals(attr.getSchemaKey()) && membership.getKey().equals(attr.getMembershipKey())).findFirst();
    }

    public Collection<? extends P> getPlainAttrs(String plainSchema) {
        return this.getPlainAttrsList().stream().filter(attr -> plainSchema.equals(attr.getSchemaKey())).toList();
    }

    public Collection<? extends P> getPlainAttrs(Membership<?> membership) {
        return this.getPlainAttrsList().stream().filter(attr -> membership.getKey().equals(attr.getMembershipKey())).toList();
    }

    public Optional<? extends M> getMembership(String groupKey) {
        return this.getMemberships().stream().filter(membership -> groupKey.equals(((Group)membership.getRightEnd()).getKey())).findFirst();
    }

    public Collection<? extends REL> getRelationships(RelationshipType relationshipType) {
        return this.getRelationships().stream().filter(relationship -> relationshipType.equals((Object)relationship.getType())).toList();
    }

    public Collection<? extends REL> getRelationships(String otherEndKey) {
        return this.getRelationships().stream().filter(relationship -> otherEndKey.equals(relationship.getRightEnd().getKey())).toList();
    }
}

