/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao.repo;

import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.syncope.core.persistence.api.dao.ExternalResourceDAO;
import org.apache.syncope.core.persistence.api.entity.AnyTypeClass;
import org.apache.syncope.core.persistence.api.entity.VirSchema;
import org.apache.syncope.core.persistence.jpa.dao.repo.AbstractSchemaRepoExt;
import org.apache.syncope.core.persistence.jpa.dao.repo.VirSchemaRepoExt;
import org.apache.syncope.core.persistence.jpa.entity.JPAVirSchema;

public class VirSchemaRepoExtImpl
extends AbstractSchemaRepoExt
implements VirSchemaRepoExt {
    protected final ExternalResourceDAO resourceDAO;

    public VirSchemaRepoExtImpl(ExternalResourceDAO resourceDAO, EntityManager entityManager) {
        super(entityManager);
        this.resourceDAO = resourceDAO;
    }

    @Override
    public List<? extends VirSchema> findByAnyTypeClasses(Collection<AnyTypeClass> anyTypeClasses) {
        return this.findByAnyTypeClasses(anyTypeClasses, JPAVirSchema.class.getSimpleName(), VirSchema.class);
    }

    @Override
    public List<VirSchema> findByResourceAndAnyType(String resource, String anyType) {
        Query query = this.entityManager.createNativeQuery("SELECT id FROM VirSchema e WHERE e.resource_id=? AND e.anyType_id=?");
        query.setParameter(1, (Object)resource);
        query.setParameter(2, (Object)anyType);
        List results = query.getResultList();
        return results.stream().map(row -> (JPAVirSchema)this.entityManager.find(JPAVirSchema.class, (Object)row.toString())).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public VirSchema save(VirSchema schema) {
        ((JPAVirSchema)schema).map2json();
        VirSchema merged = (VirSchema)this.entityManager.merge((Object)schema);
        ((JPAVirSchema)merged).postSave();
        return merged;
    }

    @Override
    public void deleteById(String key) {
        Optional.ofNullable((JPAVirSchema)this.entityManager.find(JPAVirSchema.class, (Object)key)).ifPresent(this::delete);
    }

    @Override
    public void delete(VirSchema schema) {
        this.resourceDAO.deleteMapping(schema.getKey());
        Optional.ofNullable(schema.getAnyTypeClass()).ifPresent(anyTypeClass -> anyTypeClass.getVirSchemas().remove(schema));
        this.entityManager.remove((Object)schema);
    }
}

