/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao.repo;

import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.core.persistence.api.dao.AccessTokenDAO;
import org.apache.syncope.core.persistence.api.dao.DelegationDAO;
import org.apache.syncope.core.persistence.api.dao.DynRealmDAO;
import org.apache.syncope.core.persistence.api.dao.FIQLQueryDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.RoleDAO;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyUtilsFactory;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.ExternalResource;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.api.entity.Relationship;
import org.apache.syncope.core.persistence.api.entity.Role;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.persistence.api.entity.user.UMembership;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.persistence.api.utils.RealmUtils;
import org.apache.syncope.core.persistence.jpa.dao.AnyFinder;
import org.apache.syncope.core.persistence.jpa.dao.repo.AbstractAnyRepoExt;
import org.apache.syncope.core.persistence.jpa.dao.repo.UserRepoExt;
import org.apache.syncope.core.persistence.jpa.entity.user.JPAUMembership;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.apache.syncope.core.spring.security.DelegatedAdministrationException;
import org.apache.syncope.core.spring.security.SecurityProperties;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public class UserRepoExtImpl
extends AbstractAnyRepoExt<User>
implements UserRepoExt {
    protected final RoleDAO roleDAO;
    protected final AccessTokenDAO accessTokenDAO;
    protected final GroupDAO groupDAO;
    protected final DelegationDAO delegationDAO;
    protected final FIQLQueryDAO fiqlQueryDAO;
    protected final SecurityProperties securityProperties;

    public UserRepoExtImpl(AnyUtilsFactory anyUtilsFactory, DynRealmDAO dynRealmDAO, RoleDAO roleDAO, AccessTokenDAO accessTokenDAO, GroupDAO groupDAO, DelegationDAO delegationDAO, FIQLQueryDAO fiqlQueryDAO, SecurityProperties securityProperties, EntityManager entityManager, AnyFinder anyFinder) {
        super(dynRealmDAO, entityManager, anyFinder, anyUtilsFactory.getInstance(AnyTypeKind.USER));
        this.roleDAO = roleDAO;
        this.accessTokenDAO = accessTokenDAO;
        this.groupDAO = groupDAO;
        this.delegationDAO = delegationDAO;
        this.fiqlQueryDAO = fiqlQueryDAO;
        this.securityProperties = securityProperties;
    }

    @Override
    public Map<String, Long> countByRealm() {
        Query query = this.entityManager.createQuery("SELECT e.realm, COUNT(e) FROM " + this.anyUtils.anyClass().getSimpleName() + " e GROUP BY e.realm");
        List results = query.getResultList();
        return results.stream().collect(Collectors.toMap(result -> ((Realm)result[0]).getFullPath(), result -> ((Number)result[1]).longValue()));
    }

    @Override
    public Map<String, Long> countByStatus() {
        Query query = this.entityManager.createQuery("SELECT e.status, COUNT(e) FROM " + this.anyUtils.anyClass().getSimpleName() + " e GROUP BY e.status");
        List results = query.getResultList();
        return results.stream().collect(Collectors.toMap(result -> (String)result[0], result -> ((Number)result[1]).longValue()));
    }

    @Override
    @Transactional(readOnly=true)
    public void securityChecks(Set<String> authRealms, String key, String realm, Collection<String> groups) {
        boolean authorized = authRealms.stream().map(authRealm -> RealmUtils.parseGroupOwnerRealm((String)authRealm).orElse(null)).filter(Objects::nonNull).anyMatch(pair -> groups.contains(pair.getRight()));
        if (!authorized && key != null) {
            authorized = this.findDynRealms(key).stream().anyMatch(authRealms::contains);
        }
        if (!authorized) {
            authorized = authRealms.stream().anyMatch(realm::startsWith);
        }
        if (!authorized) {
            throw new DelegatedAdministrationException(realm, AnyTypeKind.USER.name(), key);
        }
    }

    @Override
    protected void securityChecks(User user) {
        if (!AuthContextUtils.getUsername().equals(this.securityProperties.getAnonymousUser()) && !AuthContextUtils.getUsername().equals(user.getUsername())) {
            Set<String> authRealms = AuthContextUtils.getAuthorizations().getOrDefault("USER_READ", Set.of());
            this.securityChecks(authRealms, user.getKey(), user.getRealm().getFullPath(), this.findAllGroupKeys(user));
        }
    }

    @Override
    public UMembership findMembership(String key) {
        return (UMembership)this.entityManager.find(JPAUMembership.class, (Object)key);
    }

    @Override
    public void deleteMembership(UMembership membership) {
        this.entityManager.remove((Object)membership);
    }

    protected Pair<User, Pair<Set<String>, Set<String>>> doSave(User user) {
        this.entityManager.flush();
        User merged = (User)this.entityManager.merge((Object)user);
        this.entityManager.flush();
        this.roleDAO.refreshDynMemberships(merged);
        Pair dynGroupMembs = this.groupDAO.refreshDynMemberships(merged);
        this.dynRealmDAO.refreshDynMemberships((Any)merged);
        return Pair.of((Object)merged, (Object)dynGroupMembs);
    }

    @Override
    public <S extends User> S save(S user) {
        this.checkBeforeSave(user);
        return (S)((User)this.doSave(user).getLeft());
    }

    @Override
    public Pair<Set<String>, Set<String>> saveAndGetDynGroupMembs(User user) {
        this.checkBeforeSave(user);
        return (Pair)this.doSave(user).getRight();
    }

    @Override
    public void delete(User user) {
        this.roleDAO.removeDynMemberships(user.getKey());
        this.groupDAO.removeDynMemberships(user);
        this.dynRealmDAO.removeDynMemberships(user.getKey());
        this.delegationDAO.findByDelegating(user).forEach(arg_0 -> ((DelegationDAO)this.delegationDAO).delete(arg_0));
        this.delegationDAO.findByDelegated(user).forEach(arg_0 -> ((DelegationDAO)this.delegationDAO).delete(arg_0));
        this.fiqlQueryDAO.findByOwner(user, null).forEach(arg_0 -> ((FIQLQueryDAO)this.fiqlQueryDAO).delete(arg_0));
        this.accessTokenDAO.findByOwner(user.getUsername()).ifPresent(arg_0 -> ((AccessTokenDAO)this.accessTokenDAO).delete(arg_0));
        this.entityManager.remove((Object)user);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW, readOnly=true)
    public Collection<Role> findAllRoles(User user) {
        HashSet<Role> result = new HashSet<Role>();
        result.addAll(user.getRoles());
        result.addAll(this.findDynRoles(user.getKey()));
        return result;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW, readOnly=true)
    public List<Role> findDynRoles(String key) {
        Query query = this.entityManager.createNativeQuery("SELECT role_id FROM DynRoleMembers WHERE any_id=?");
        query.setParameter(1, (Object)key);
        List result = query.getResultList();
        return result.stream().map(roleKey -> this.roleDAO.findById(roleKey.toString())).flatMap(Optional::stream).distinct().collect(Collectors.toList());
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW, readOnly=true)
    public List<Group> findDynGroups(String key) {
        Query query = this.entityManager.createNativeQuery("SELECT group_id FROM UDynGroupMembers WHERE any_id=?");
        query.setParameter(1, (Object)key);
        List result = query.getResultList();
        return result.stream().map(groupKey -> this.groupDAO.findById(groupKey.toString())).flatMap(Optional::stream).distinct().collect(Collectors.toList());
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW, readOnly=true)
    public Collection<Group> findAllGroups(User user) {
        HashSet<Group> result = new HashSet<Group>();
        result.addAll(user.getMemberships().stream().map(Relationship::getRightEnd).collect(Collectors.toSet()));
        result.addAll(this.findDynGroups(user.getKey()));
        return result;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW, readOnly=true)
    public Collection<String> findAllGroupKeys(User user) {
        return this.findAllGroups(user).stream().map(Entity::getKey).toList();
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW, readOnly=true)
    public Collection<String> findAllGroupNames(User user) {
        return this.findAllGroups(user).stream().map(Group::getName).toList();
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW, readOnly=true)
    public Collection<ExternalResource> findAllResources(User user) {
        HashSet<ExternalResource> result = new HashSet<ExternalResource>();
        result.addAll(user.getResources());
        this.findAllGroups(user).forEach(group -> result.addAll(group.getResources()));
        return result;
    }

    @Override
    @Transactional(readOnly=true)
    public Collection<String> findAllResourceKeys(String key) {
        return this.findAllResources((User)this.authFind(key)).stream().map(Entity::getKey).toList();
    }

    @Override
    @Transactional(readOnly=true)
    public boolean linkedAccountExists(String userKey, String connObjectKeyValue) {
        Query query = this.entityManager.createNativeQuery("SELECT COUNT(id) FROM LinkedAccount WHERE owner_id=? AND connObjectKeyValue=?");
        query.setParameter(1, (Object)userKey);
        query.setParameter(2, (Object)connObjectKeyValue);
        return ((Number)query.getSingleResult()).longValue() > 0L;
    }
}

