/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao.repo;

import java.util.List;
import java.util.Optional;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.entity.ExternalResource;
import org.apache.syncope.core.persistence.api.entity.Privilege;
import org.apache.syncope.core.persistence.api.entity.user.LinkedAccount;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.persistence.jpa.dao.repo.UserRepoExt;
import org.apache.syncope.core.persistence.jpa.entity.user.JPAUser;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.PagingAndSortingRepository;
import org.springframework.data.repository.query.Param;

public interface UserRepo
extends PagingAndSortingRepository<JPAUser, String>,
UserRepoExt,
UserDAO {
    @Query(value="SELECT e.id FROM #{#entityName} e WHERE e.username = :username")
    public Optional<String> findKey(@Param(value="username") String var1);

    @Query(value="SELECT e.username FROM #{#entityName} e WHERE e.id = :key")
    public Optional<String> findUsername(@Param(value="key") String var1);

    @Query(value="SELECT e FROM #{#entityName} e WHERE e.token LIKE :token")
    public Optional<? extends User> findByToken(@Param(value="token") String var1);

    @Query(value="SELECT e FROM #{#entityName} e WHERE e.id IN (:keys)")
    public List<User> findByKeys(@Param(value="keys") List<String> var1);

    @Query(value="SELECT e FROM JPALinkedAccount e WHERE e.resource = :resource AND e.connObjectKeyValue = :connObjectKeyValue")
    public Optional<? extends LinkedAccount> findLinkedAccount(@Param(value="resource") ExternalResource var1, @Param(value="connObjectKeyValue") String var2);

    @Query(value="SELECT e FROM JPALinkedAccount e WHERE e.owner.id = :userKey")
    public List<LinkedAccount> findLinkedAccounts(@Param(value="userKey") String var1);

    @Query(value="SELECT e FROM JPALinkedAccount e WHERE :privilege MEMBER OF e.privileges")
    public List<LinkedAccount> findLinkedAccountsByPrivilege(@Param(value="privilege") Privilege var1);

    @Query(value="SELECT e FROM JPALinkedAccount e WHERE e.resource = :resource")
    public List<LinkedAccount> findLinkedAccountsByResource(@Param(value="resource") ExternalResource var1);
}

