/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao.repo;

import jakarta.persistence.EntityManager;
import java.util.Optional;
import org.apache.syncope.core.persistence.api.dao.RoleDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.entity.Application;
import org.apache.syncope.core.persistence.api.entity.Privilege;
import org.apache.syncope.core.persistence.jpa.dao.repo.ApplicationRepoExt;
import org.apache.syncope.core.persistence.jpa.entity.JPAPrivilege;

public class ApplicationRepoExtImpl
implements ApplicationRepoExt {
    protected final RoleDAO roleDAO;
    protected final UserDAO userDAO;
    protected final EntityManager entityManager;

    public ApplicationRepoExtImpl(RoleDAO roleDAO, UserDAO userDAO, EntityManager entityManager) {
        this.roleDAO = roleDAO;
        this.userDAO = userDAO;
        this.entityManager = entityManager;
    }

    @Override
    public Optional<? extends Privilege> findPrivilege(String key) {
        return Optional.ofNullable((JPAPrivilege)this.entityManager.find(JPAPrivilege.class, (Object)key));
    }

    @Override
    public void delete(Application application) {
        application.getPrivileges().forEach(privilege -> {
            this.roleDAO.findByPrivileges(privilege).forEach(role -> role.getPrivileges().remove(privilege));
            this.userDAO.findLinkedAccountsByPrivilege(privilege).forEach(account -> account.getPrivileges().remove(privilege));
            privilege.setApplication(null);
        });
        application.getPrivileges().clear();
        this.entityManager.remove((Object)application);
    }
}

