/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao.repo;

import jakarta.persistence.EntityManager;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.core.persistence.api.dao.ExternalResourceDAO;
import org.apache.syncope.core.persistence.api.entity.AnyTypeClass;
import org.apache.syncope.core.persistence.api.entity.AnyUtilsFactory;
import org.apache.syncope.core.persistence.api.entity.PlainAttr;
import org.apache.syncope.core.persistence.api.entity.PlainSchema;
import org.apache.syncope.core.persistence.api.entity.anyobject.APlainAttr;
import org.apache.syncope.core.persistence.api.entity.group.GPlainAttr;
import org.apache.syncope.core.persistence.jpa.dao.repo.AbstractSchemaRepoExt;
import org.apache.syncope.core.persistence.jpa.dao.repo.PlainSchemaRepoExt;
import org.apache.syncope.core.persistence.jpa.entity.AbstractSchema;
import org.apache.syncope.core.persistence.jpa.entity.JPAPlainSchema;

abstract class AbstractPlainSchemaRepoExt
extends AbstractSchemaRepoExt
implements PlainSchemaRepoExt {
    protected final AnyUtilsFactory anyUtilsFactory;
    protected final ExternalResourceDAO resourceDAO;

    protected static <T extends PlainAttr<?>> AnyTypeKind getAnyTypeKind(Class<T> plainAttrClass) {
        if (GPlainAttr.class.isAssignableFrom(plainAttrClass)) {
            return AnyTypeKind.GROUP;
        }
        if (APlainAttr.class.isAssignableFrom(plainAttrClass)) {
            return AnyTypeKind.ANY_OBJECT;
        }
        return AnyTypeKind.USER;
    }

    protected AbstractPlainSchemaRepoExt(AnyUtilsFactory anyUtilsFactory, ExternalResourceDAO resourceDAO, EntityManager entityManager) {
        super(entityManager);
        this.anyUtilsFactory = anyUtilsFactory;
        this.resourceDAO = resourceDAO;
    }

    @Override
    public List<? extends PlainSchema> findByAnyTypeClasses(Collection<AnyTypeClass> anyTypeClasses) {
        return this.findByAnyTypeClasses(anyTypeClasses, JPAPlainSchema.class.getSimpleName(), PlainSchema.class);
    }

    @Override
    public PlainSchema save(PlainSchema schema) {
        ((AbstractSchema)schema).map2json();
        PlainSchema merged = (PlainSchema)this.entityManager.merge((Object)schema);
        ((AbstractSchema)merged).postSave();
        return merged;
    }

    @Override
    public void deleteById(String key) {
        PlainSchema schema = (PlainSchema)this.entityManager.find(JPAPlainSchema.class, (Object)key);
        if (schema == null) {
            return;
        }
        this.resourceDAO.deleteMapping(key);
        Optional.ofNullable(schema.getAnyTypeClass()).ifPresent(c -> c.getPlainSchemas().remove(schema));
        this.entityManager.remove((Object)schema);
    }

    @Override
    public <T extends PlainAttr<?>> void delete(T plainAttr) {
        if (plainAttr.getOwner() != null) {
            plainAttr.getOwner().remove(plainAttr);
        }
    }
}

