/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao;

import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.Query;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.SyncopeConstants;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.AttrSchemaType;
import org.apache.syncope.core.persistence.api.attrvalue.PlainAttrValidationManager;
import org.apache.syncope.core.persistence.api.dao.AnyObjectDAO;
import org.apache.syncope.core.persistence.api.dao.DynRealmDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.PlainSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.RealmSearchDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.dao.search.AnyCond;
import org.apache.syncope.core.persistence.api.dao.search.AnyTypeCond;
import org.apache.syncope.core.persistence.api.dao.search.AttrCond;
import org.apache.syncope.core.persistence.api.dao.search.AuxClassCond;
import org.apache.syncope.core.persistence.api.dao.search.DynRealmCond;
import org.apache.syncope.core.persistence.api.dao.search.MemberCond;
import org.apache.syncope.core.persistence.api.dao.search.MembershipCond;
import org.apache.syncope.core.persistence.api.dao.search.PrivilegeCond;
import org.apache.syncope.core.persistence.api.dao.search.RelationshipCond;
import org.apache.syncope.core.persistence.api.dao.search.RelationshipTypeCond;
import org.apache.syncope.core.persistence.api.dao.search.ResourceCond;
import org.apache.syncope.core.persistence.api.dao.search.RoleCond;
import org.apache.syncope.core.persistence.api.dao.search.SearchCond;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyUtils;
import org.apache.syncope.core.persistence.api.entity.AnyUtilsFactory;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.PlainAttrValue;
import org.apache.syncope.core.persistence.api.entity.PlainSchema;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.jpa.dao.AbstractJPAAnySearchDAO;
import org.apache.syncope.core.persistence.jpa.dao.OrderBySupport;
import org.apache.syncope.core.persistence.jpa.dao.SearchSupport;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

public class PGJPAAnySearchDAO
extends AbstractJPAAnySearchDAO {
    protected static final String ALWAYS_FALSE_ASSERTION = "1=2";
    protected static final String REGEX_CHARS = "!$()*+.:<=>?[\\]^{|}-";

    protected static String escapeForLikeRegex(String input) {
        String output = input;
        for (char toEscape : REGEX_CHARS.toCharArray()) {
            output = output.replace(String.valueOf(toEscape), "\\" + toEscape);
        }
        return output.replace("'", "''");
    }

    protected static String escapeIfString(String value, boolean isStr) {
        return isStr ? '\"' + value.replace("'", "''") + '\"' : value;
    }

    public PGJPAAnySearchDAO(RealmSearchDAO realmSearchDAO, DynRealmDAO dynRealmDAO, UserDAO userDAO, GroupDAO groupDAO, AnyObjectDAO anyObjectDAO, PlainSchemaDAO schemaDAO, EntityFactory entityFactory, AnyUtilsFactory anyUtilsFactory, PlainAttrValidationManager validator, EntityManagerFactory entityManagerFactory, EntityManager entityManager) {
        super(realmSearchDAO, dynRealmDAO, userDAO, groupDAO, anyObjectDAO, schemaDAO, entityFactory, anyUtilsFactory, validator, entityManagerFactory, entityManager);
    }

    @Override
    protected void parseOrderByForPlainSchema(SearchSupport svs, OrderBySupport obs, OrderBySupport.Item item, Sort.Order clause, PlainSchema schema, String fieldName) {
        obs.nonMandatorySchemas = !"true".equals(schema.getMandatoryCondition());
        obs.views.add(svs.table());
        item.select = fieldName + " -> 0 AS " + fieldName;
        item.where = "";
        item.orderBy = fieldName + " " + clause.getDirection().name();
    }

    @Override
    protected void parseOrderByForField(SearchSupport svs, OrderBySupport.Item item, String fieldName, Sort.Order clause) {
        item.select = svs.table().alias() + "." + fieldName;
        item.where = "";
        item.orderBy = svs.table().alias() + "." + fieldName + " " + clause.getDirection().name();
    }

    protected void fillAttrQuery(AnyUtils anyUtils, StringBuilder query, PlainAttrValue attrValue, PlainSchema schema, AttrCond cond, boolean not, SearchSupport svs) {
        if (not && cond.getType() == AttrCond.Type.ISNULL) {
            cond.setType(AttrCond.Type.ISNOTNULL);
            this.fillAttrQuery(anyUtils, query, attrValue, schema, cond, true, svs);
        } else if (not) {
            query.append("NOT (");
            this.fillAttrQuery(anyUtils, query, attrValue, schema, cond, false, svs);
            query.append(')');
        } else {
            String key = PGJPAAnySearchDAO.key((AttrSchemaType)schema.getType());
            String value = Optional.ofNullable(attrValue.getDateValue()).map(DateTimeFormatter.ISO_OFFSET_DATE_TIME::format).orElse(cond.getExpression());
            boolean isStr = true;
            boolean lower = false;
            if (schema.getType().isStringClass()) {
                lower = cond.getType() == AttrCond.Type.IEQ || cond.getType() == AttrCond.Type.ILIKE;
            } else if (schema.getType() != AttrSchemaType.Date) {
                lower = false;
                try {
                    switch (schema.getType()) {
                        case Long: {
                            Long.valueOf(value);
                            break;
                        }
                        case Double: {
                            Double.valueOf(value);
                            break;
                        }
                        case Boolean: {
                            if ("true".equalsIgnoreCase(value) || "false".equalsIgnoreCase(value)) break;
                            throw new IllegalArgumentException();
                        }
                    }
                    isStr = false;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            switch (cond.getType()) {
                case ISNULL: {
                    break;
                }
                case ISNOTNULL: {
                    query.append("jsonb_path_exists(").append(schema.getKey()).append(", '$[*]')");
                    break;
                }
                case ILIKE: 
                case LIKE: {
                    if (schema.getType().isStringClass()) {
                        query.append("jsonb_path_exists(").append(schema.getKey()).append(", '$[*] ? ").append("(@.").append(key).append(" like_regex \"").append(PGJPAAnySearchDAO.escapeForLikeRegex(value).replace("%", ".*")).append("\"").append(lower ? " flag \"i\"" : "").append(")')");
                        break;
                    }
                    query.append(' ').append(ALWAYS_FALSE_ASSERTION);
                    LOG.error("LIKE is only compatible with string or enum schemas");
                    break;
                }
                case IEQ: 
                case EQ: {
                    query.append("jsonb_path_exists(").append(schema.getKey()).append(", '$[*] ? ").append("(@.").append(key);
                    if (StringUtils.containsAny((CharSequence)value, (CharSequence)REGEX_CHARS) || lower) {
                        query.append(" like_regex \"^").append(PGJPAAnySearchDAO.escapeForLikeRegex(value).replace("'", "''")).append("$\"");
                    } else {
                        query.append(" == ").append(PGJPAAnySearchDAO.escapeIfString(value, isStr));
                    }
                    query.append(lower ? " flag \"i\"" : "").append(")')");
                    break;
                }
                case GE: {
                    query.append("jsonb_path_exists(").append(schema.getKey()).append(", '$[*] ? ").append("(@.").append(key).append(" >= ").append(PGJPAAnySearchDAO.escapeIfString(value, isStr)).append(")')");
                    break;
                }
                case GT: {
                    query.append("jsonb_path_exists(").append(schema.getKey()).append(", '$[*] ? ").append("(@.").append(key).append(" > ").append(PGJPAAnySearchDAO.escapeIfString(value, isStr)).append(")')");
                    break;
                }
                case LE: {
                    query.append("jsonb_path_exists(").append(schema.getKey()).append(", '$[*] ? ").append("(@.").append(key).append(" <= ").append(PGJPAAnySearchDAO.escapeIfString(value, isStr)).append(")')");
                    break;
                }
                case LT: {
                    query.append("jsonb_path_exists(").append(schema.getKey()).append(", '$[*] ? ").append("(@.").append(key).append(" < ").append(PGJPAAnySearchDAO.escapeIfString(value, isStr)).append(")')");
                    break;
                }
            }
        }
    }

    @Override
    protected String getQuery(AttrCond cond, boolean not, List<Object> parameters, SearchSupport svs) {
        Pair checked = this.check(cond, svs.anyTypeKind);
        StringBuilder query = new StringBuilder();
        switch (cond.getType()) {
            case ISNOTNULL: {
                query.append(not ? " NOT " : Character.valueOf(' ')).append("jsonb_path_exists(").append(((PlainSchema)checked.getLeft()).getKey()).append(",'$[*]')");
                break;
            }
            case ISNULL: {
                query.append(not ? Character.valueOf(' ') : " NOT ").append("jsonb_path_exists(").append(((PlainSchema)checked.getLeft()).getKey()).append(",'$[*]')");
                break;
            }
            default: {
                this.fillAttrQuery(this.anyUtilsFactory.getInstance(svs.anyTypeKind), query, (PlainAttrValue)checked.getRight(), (PlainSchema)checked.getLeft(), cond, not, svs);
            }
        }
        return query.toString();
    }

    @Override
    protected String getQuery(AnyTypeCond cond, boolean not, List<Object> parameters, SearchSupport svs) {
        StringBuilder query = new StringBuilder("type_id");
        if (not) {
            query.append("<>");
        } else {
            query.append('=');
        }
        query.append('?').append(PGJPAAnySearchDAO.setParameter(parameters, cond.getAnyTypeKey()));
        return query.toString();
    }

    @Override
    protected String getQuery(AuxClassCond cond, boolean not, List<Object> parameters, SearchSupport svs) {
        StringBuilder query = new StringBuilder();
        if (not) {
            query.append("id NOT IN (");
        } else {
            query.append("id IN (");
        }
        query.append("SELECT DISTINCT any_id FROM ").append(svs.auxClass().name()).append(" WHERE anyTypeClass_id=?").append(PGJPAAnySearchDAO.setParameter(parameters, cond.getAuxClass())).append(')');
        return query.toString();
    }

    @Override
    protected String getQuery(RoleCond cond, boolean not, List<Object> parameters, SearchSupport svs) {
        StringBuilder query = new StringBuilder().append('(');
        if (not) {
            query.append("id NOT IN (");
        } else {
            query.append("id IN (");
        }
        query.append("SELECT DISTINCT any_id FROM ").append(svs.role().name()).append(" WHERE ").append("role_id=?").append(PGJPAAnySearchDAO.setParameter(parameters, cond.getRole())).append(") ");
        if (not) {
            query.append("AND id NOT IN (");
        } else {
            query.append("OR id IN (");
        }
        query.append("SELECT DISTINCT any_id FROM ").append(SearchSupport.dynrolemembership().name()).append(" WHERE ").append("role_id=?").append(PGJPAAnySearchDAO.setParameter(parameters, cond.getRole())).append(')');
        query.append(')');
        return query.toString();
    }

    @Override
    protected String getQuery(PrivilegeCond cond, boolean not, List<Object> parameters, SearchSupport svs) {
        StringBuilder query = new StringBuilder().append('(');
        if (not) {
            query.append("id NOT IN (");
        } else {
            query.append("id IN (");
        }
        query.append("SELECT DISTINCT any_id FROM ").append(svs.priv().name()).append(" WHERE ").append("privilege_id=?").append(PGJPAAnySearchDAO.setParameter(parameters, cond.getPrivilege())).append(") ");
        if (not) {
            query.append("AND id NOT IN (");
        } else {
            query.append("OR id IN (");
        }
        query.append("SELECT DISTINCT any_id FROM ").append(svs.dynpriv().name()).append(" WHERE ").append("privilege_id=?").append(PGJPAAnySearchDAO.setParameter(parameters, cond.getPrivilege())).append(')');
        query.append(')');
        return query.toString();
    }

    @Override
    protected String getQuery(DynRealmCond cond, boolean not, List<Object> parameters, SearchSupport svs) {
        StringBuilder query = new StringBuilder();
        if (not) {
            query.append("id NOT IN (");
        } else {
            query.append("id IN (");
        }
        query.append("SELECT DISTINCT any_id FROM ").append(SearchSupport.dynrealmmembership().name()).append(" WHERE ").append("dynRealm_id=?").append(PGJPAAnySearchDAO.setParameter(parameters, cond.getDynRealm())).append(')');
        return query.toString();
    }

    @Override
    protected String getQuery(ResourceCond cond, boolean not, List<Object> parameters, SearchSupport svs) {
        StringBuilder query = new StringBuilder();
        if (not) {
            query.append("id NOT IN (");
        } else {
            query.append("id IN (");
        }
        query.append("SELECT DISTINCT any_id FROM ").append(svs.resource().name()).append(" WHERE resource_id=?").append(PGJPAAnySearchDAO.setParameter(parameters, cond.getResource()));
        if (svs.anyTypeKind == AnyTypeKind.USER || svs.anyTypeKind == AnyTypeKind.ANY_OBJECT) {
            query.append(" UNION SELECT DISTINCT any_id FROM ").append(svs.groupResource().name()).append(" WHERE resource_id=?").append(PGJPAAnySearchDAO.setParameter(parameters, cond.getResource()));
        }
        query.append(')');
        return query.toString();
    }

    @Override
    protected String getQuery(MemberCond cond, boolean not, List<Object> parameters, SearchSupport svs) {
        Set members = this.check(cond);
        StringBuilder query = new StringBuilder().append('(');
        if (not) {
            query.append("id NOT IN (");
        } else {
            query.append("id IN (");
        }
        query.append("SELECT DISTINCT group_id AS any_id FROM ").append(new SearchSupport(AnyTypeKind.USER).membership().name()).append(" WHERE ").append(members.stream().map(key -> "any_id=?" + PGJPAAnySearchDAO.setParameter(parameters, key)).collect(Collectors.joining(" OR "))).append(") ");
        if (not) {
            query.append("AND id NOT IN (");
        } else {
            query.append("OR id IN (");
        }
        query.append("SELECT DISTINCT group_id AS any_id FROM ").append(new SearchSupport(AnyTypeKind.ANY_OBJECT).membership().name()).append(" WHERE ").append(members.stream().map(key -> "any_id=?" + PGJPAAnySearchDAO.setParameter(parameters, key)).collect(Collectors.joining(" OR "))).append(')');
        query.append(')');
        return query.toString();
    }

    @Override
    protected String getQuery(RelationshipTypeCond cond, boolean not, List<Object> parameters, SearchSupport svs) {
        StringBuilder query = new StringBuilder().append('(');
        if (not) {
            query.append("id NOT IN (");
        } else {
            query.append("id IN (");
        }
        query.append("SELECT any_id ").append("FROM ").append(svs.relationship().name()).append(" WHERE type=?").append(PGJPAAnySearchDAO.setParameter(parameters, cond.getRelationshipTypeKey())).append(" UNION SELECT right_any_id AS any_id FROM ").append(svs.relationship().name()).append(" WHERE type=?").append(PGJPAAnySearchDAO.setParameter(parameters, cond.getRelationshipTypeKey())).append(')');
        query.append(')');
        return query.toString();
    }

    @Override
    protected String getQuery(RelationshipCond cond, boolean not, List<Object> parameters, SearchSupport svs) {
        Set rightAnyObjectKeys = this.check(cond);
        StringBuilder query = new StringBuilder().append('(');
        if (not) {
            query.append("id NOT IN (");
        } else {
            query.append("id IN (");
        }
        query.append("SELECT DISTINCT any_id FROM ").append(svs.relationship().name()).append(" WHERE ").append(rightAnyObjectKeys.stream().map(key -> "right_any_id=?" + PGJPAAnySearchDAO.setParameter(parameters, key)).collect(Collectors.joining(" OR "))).append(')');
        query.append(')');
        return query.toString();
    }

    @Override
    protected String getQuery(MembershipCond cond, boolean not, List<Object> parameters, SearchSupport svs) {
        List groupKeys = this.check(cond);
        String where = groupKeys.stream().map(key -> "group_id=?" + PGJPAAnySearchDAO.setParameter(parameters, key)).collect(Collectors.joining(" OR "));
        StringBuilder query = new StringBuilder().append('(');
        if (not) {
            query.append("id NOT IN (");
        } else {
            query.append("id IN (");
        }
        query.append("SELECT DISTINCT any_id FROM ").append(svs.membership().name()).append(" WHERE ").append('(').append(where).append(')').append(") ");
        if (not) {
            query.append("AND id NOT IN (");
        } else {
            query.append("OR id IN (");
        }
        query.append("SELECT DISTINCT any_id FROM ").append(svs.dyngroupmembership().name()).append(" WHERE ").append('(').append(where).append(')').append(')');
        query.append(')');
        return query.toString();
    }

    @Override
    protected String getQuery(AnyCond cond, boolean not, List<Object> parameters, SearchSupport svs) {
        if ("realm".equals(cond.getSchema()) && !SyncopeConstants.UUID_PATTERN.matcher(cond.getExpression()).matches()) {
            Realm realm = (Realm)this.realmSearchDAO.findByFullPath(cond.getExpression()).orElseThrow(() -> new IllegalArgumentException("Invalid Realm full path: " + cond.getExpression()));
            cond.setExpression(realm.getKey());
        }
        Triple checked = this.check(cond, svs.anyTypeKind);
        StringBuilder query = new StringBuilder();
        this.plainSchemaDAO.findById(cond.getSchema()).ifPresentOrElse(schema -> this.fillAttrQuery(this.anyUtilsFactory.getInstance(svs.anyTypeKind), query, (PlainAttrValue)checked.getMiddle(), (PlainSchema)checked.getLeft(), (AttrCond)checked.getRight(), not, svs), () -> this.fillAttrQuery(query, (PlainAttrValue)checked.getMiddle(), (PlainSchema)checked.getLeft(), (AttrCond)checked.getRight(), not, parameters, svs));
        return query.toString();
    }

    @Override
    protected String buildAdminRealmsFilter(Set<String> realmKeys, SearchSupport svs, List<Object> parameters) {
        if (realmKeys.isEmpty()) {
            return "realm_id IS NOT NULL";
        }
        String realmKeysArg = realmKeys.stream().map(realmKey -> "?" + PGJPAAnySearchDAO.setParameter(parameters, realmKey)).collect(Collectors.joining(","));
        return "realm_id IN (" + realmKeysArg + ")";
    }

    @Override
    protected long doCount(Realm base, boolean recursive, Set<String> adminRealms, SearchCond cond, AnyTypeKind kind) {
        ArrayList<Object> parameters = new ArrayList<Object>();
        SearchSupport svs = this.buildSearchSupport(kind);
        Triple<String, Set<String>, Set<String>> filter = this.getAdminRealmsFilter(base, recursive, adminRealms, svs, parameters);
        Pair<StringBuilder, Set<String>> queryInfo = this.getQuery(PGJPAAnySearchDAO.buildEffectiveCond((SearchCond)cond, (Set)((Set)filter.getMiddle()), (Set)((Set)filter.getRight()), (AnyTypeKind)kind), parameters, svs);
        StringBuilder queryString = new StringBuilder("SELECT count(").append(svs.table().alias()).append(".id").append(')');
        this.buildFromAndWhere(queryString, queryInfo, (String)filter.getLeft(), svs, null);
        Query countQuery = this.entityManager.createNativeQuery(queryString.toString());
        PGJPAAnySearchDAO.fillWithParameters(countQuery, parameters);
        return ((Number)countQuery.getSingleResult()).longValue();
    }

    @Override
    protected <T extends Any<?>> List<T> doSearch(Realm base, boolean recursive, Set<String> adminRealms, SearchCond cond, Pageable pageable, AnyTypeKind kind) {
        try {
            ArrayList<Object> parameters = new ArrayList<Object>();
            SearchSupport svs = this.buildSearchSupport(kind);
            Triple<String, Set<String>, Set<String>> filter = this.getAdminRealmsFilter(base, recursive, adminRealms, svs, parameters);
            SearchCond effectiveCond = PGJPAAnySearchDAO.buildEffectiveCond((SearchCond)cond, (Set)((Set)filter.getMiddle()), (Set)((Set)filter.getRight()), (AnyTypeKind)kind);
            Pair<StringBuilder, Set<String>> queryInfo = this.getQuery(effectiveCond, parameters, svs);
            OrderBySupport obs = this.parseOrderBy(svs, pageable.getSort().get());
            StringBuilder queryString = new StringBuilder("SELECT ").append(svs.table().alias()).append(".id");
            obs.items.forEach(item -> queryString.append(',').append(item.select));
            this.buildFromAndWhere(queryString, queryInfo, (String)filter.getLeft(), svs, obs);
            LOG.debug("Query: {}, parameters: {}", (Object)queryString, parameters);
            queryString.append((CharSequence)this.buildOrderBy(obs));
            LOG.debug("Query with auth and order by statements: {}, parameters: {}", (Object)queryString, parameters);
            Query query = this.entityManager.createNativeQuery(queryString.toString());
            if (pageable.isPaged()) {
                query.setFirstResult(pageable.getPageSize() * pageable.getPageNumber());
                query.setMaxResults(pageable.getPageSize());
            }
            PGJPAAnySearchDAO.fillWithParameters(query, parameters);
            return this.buildResult(query.getResultList(), kind);
        }
        catch (SyncopeClientException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error("While searching for {}", (Object)kind, (Object)e);
            return List.of();
        }
    }

    @Override
    protected void queryOp(StringBuilder query, String op, Pair<StringBuilder, Set<String>> leftInfo, Pair<StringBuilder, Set<String>> rightInfo) {
        query.append('(').append((CharSequence)leftInfo.getKey()).append(' ').append(op).append(' ').append((CharSequence)rightInfo.getKey()).append(')');
    }

    @Override
    protected void fillAttrQuery(StringBuilder query, PlainAttrValue attrValue, PlainSchema schema, AttrCond cond, boolean not, List<Object> parameters, SearchSupport svs) {
        if (not && cond.getType() == AttrCond.Type.ISNULL) {
            cond.setType(AttrCond.Type.ISNOTNULL);
            this.fillAttrQuery(query, attrValue, schema, cond, true, parameters, svs);
        } else if (not) {
            query.append("NOT (");
            this.fillAttrQuery(query, attrValue, schema, cond, false, parameters, svs);
            query.append(')');
        } else if (not && cond.getType() == AttrCond.Type.ISNULL) {
            cond.setType(AttrCond.Type.ISNOTNULL);
            this.fillAttrQuery(query, attrValue, schema, cond, true, parameters, svs);
        } else {
            boolean lower = schema.getType().isStringClass() && (cond.getType() == AttrCond.Type.IEQ || cond.getType() == AttrCond.Type.ILIKE);
            Object column = cond.getSchema();
            if (lower) {
                column = "LOWER (" + (String)column + ")";
            }
            switch (cond.getType()) {
                case ISNULL: {
                    query.append((String)column).append(" IS NULL");
                    break;
                }
                case ISNOTNULL: {
                    query.append((String)column).append(" IS NOT NULL");
                    break;
                }
                case ILIKE: 
                case LIKE: {
                    if (schema.getType().isStringClass()) {
                        query.append((String)column).append(" LIKE ");
                        if (lower) {
                            query.append("LOWER(?").append(PGJPAAnySearchDAO.setParameter(parameters, cond.getExpression())).append(')');
                            break;
                        }
                        query.append('?').append(PGJPAAnySearchDAO.setParameter(parameters, cond.getExpression()));
                        break;
                    }
                    query.append(' ').append(ALWAYS_FALSE_ASSERTION);
                    LOG.error("LIKE is only compatible with string or enum schemas");
                    break;
                }
                case IEQ: 
                case EQ: {
                    query.append((String)column).append('=');
                    if (lower) {
                        query.append("LOWER(?").append(PGJPAAnySearchDAO.setParameter(parameters, attrValue.getValue())).append(')');
                        break;
                    }
                    query.append('?').append(PGJPAAnySearchDAO.setParameter(parameters, attrValue.getValue()));
                    break;
                }
                case GE: {
                    query.append((String)column);
                    if (not) {
                        query.append('<');
                    } else {
                        query.append(">=");
                    }
                    query.append('?').append(PGJPAAnySearchDAO.setParameter(parameters, attrValue.getValue()));
                    break;
                }
                case GT: {
                    query.append((String)column);
                    if (not) {
                        query.append("<=");
                    } else {
                        query.append('>');
                    }
                    query.append('?').append(PGJPAAnySearchDAO.setParameter(parameters, attrValue.getValue()));
                    break;
                }
                case LE: {
                    query.append((String)column);
                    if (not) {
                        query.append('>');
                    } else {
                        query.append("<=");
                    }
                    query.append('?').append(PGJPAAnySearchDAO.setParameter(parameters, attrValue.getValue()));
                    break;
                }
                case LT: {
                    query.append((String)column);
                    if (not) {
                        query.append(">=");
                    } else {
                        query.append('<');
                    }
                    query.append('?').append(PGJPAAnySearchDAO.setParameter(parameters, attrValue.getValue()));
                    break;
                }
            }
        }
    }

    protected void buildFromAndWhere(StringBuilder queryString, Pair<StringBuilder, Set<String>> queryInfo, String realmsFilter, SearchSupport svs, OrderBySupport obs) {
        String obsWhere;
        queryString.append(" FROM ").append(svs.table().name()).append(' ').append(svs.table().alias());
        Set schemas = (Set)queryInfo.getRight();
        if (obs != null) {
            obs.views.stream().filter(view -> !svs.field().name().equals(view.name()) && !svs.table().name().equals(view.name())).map(view -> view.name() + " " + view.alias()).forEach(view -> queryString.append(',').append((String)view));
            obs.items.forEach(item -> {
                String schema = StringUtils.substringBefore((String)item.orderBy, (int)32);
                if (StringUtils.isNotBlank((CharSequence)schema)) {
                    schemas.add(schema);
                }
            });
        }
        schemas.forEach(schema -> this.plainSchemaDAO.findById(schema).ifPresentOrElse(pschema -> queryString.append(',').append("jsonb_path_query_array(plainattrs, '$[*] ? (@.schema==\"").append((String)schema).append("\").").append("\"").append(pschema.isUniqueConstraint() ? "uniqueValue" : "values").append("\"')").append(" AS ").append((String)schema), () -> LOG.warn("Ignoring invalid schema '{}'", schema)));
        StringBuilder where = new StringBuilder();
        if (((StringBuilder)queryInfo.getLeft()).length() > 0) {
            where.append(" WHERE ").append((CharSequence)queryInfo.getLeft());
        }
        if (((StringBuilder)queryInfo.getLeft()).length() == 0) {
            where.append(" WHERE ");
        } else {
            where.append(" AND ");
        }
        where.append(realmsFilter);
        if (obs != null && !(obsWhere = obs.views.stream().filter(view -> !svs.field().name().equals(view.name()) && !svs.table().name().equals(view.name())).map(view -> "t.id=" + view.alias() + ".any_id").collect(Collectors.joining(" AND "))).isEmpty()) {
            if (where.length() == 0) {
                where.append(" WHERE ");
            } else {
                where.append(" AND ");
            }
            where.append(obsWhere);
        }
        queryString.append((CharSequence)where);
    }
}

