/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao;

import jakarta.persistence.EntityManager;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.core.persistence.api.dao.PlainSchemaDAO;
import org.apache.syncope.core.persistence.api.entity.AnyUtils;
import org.apache.syncope.core.persistence.api.entity.PlainAttr;
import org.apache.syncope.core.persistence.api.entity.PlainAttrUniqueValue;
import org.apache.syncope.core.persistence.api.entity.PlainAttrValue;
import org.apache.syncope.core.persistence.api.entity.PlainSchema;
import org.apache.syncope.core.persistence.jpa.dao.AnyFinder;
import org.apache.syncope.core.provisioning.api.serialization.POJOHelper;

public class PGAnyFinder
extends AnyFinder {
    public PGAnyFinder(PlainSchemaDAO plainSchemaDAO, EntityManager entityManager) {
        super(plainSchemaDAO, entityManager);
    }

    @Override
    protected String queryBegin(String table) {
        return "SELECT DISTINCT id FROM " + table + " u,jsonb_array_elements(u.plainAttrs) attrs,jsonb_array_elements(COALESCE(attrs -> 'values', '[{}]'::jsonb)) attrValues ";
    }

    @Override
    protected String attrValueMatch(AnyUtils anyUtils, PlainSchema schema, PlainAttrValue attrValue, boolean ignoreCaseMatch) {
        Pair<String, Boolean> schemaInfo = this.schemaInfo(schema.getType(), ignoreCaseMatch);
        if (((Boolean)schemaInfo.getRight()).booleanValue()) {
            return "attrs ->> 'schema' = ? AND LOWER(" + (schema.isUniqueConstraint() ? "attrs -> 'uniqueValue'" : "attrValues") + " ->> '" + (String)schemaInfo.getLeft() + "') = LOWER(?)";
        }
        PlainAttr container = anyUtils.newPlainAttr();
        container.setSchema(schema);
        if (attrValue instanceof PlainAttrUniqueValue) {
            PlainAttrUniqueValue plainAttrUniqueValue = (PlainAttrUniqueValue)attrValue;
            container.setUniqueValue(plainAttrUniqueValue);
        } else {
            container.add(attrValue);
        }
        return "plainAttrs::jsonb @> '" + POJOHelper.serialize(List.of(container)).replace("'", "''") + "'::jsonb";
    }
}

