/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao;

import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.types.AttrSchemaType;
import org.apache.syncope.core.persistence.api.attrvalue.PlainAttrValidationManager;
import org.apache.syncope.core.persistence.api.dao.AnyObjectDAO;
import org.apache.syncope.core.persistence.api.dao.DynRealmDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.PlainSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.RealmSearchDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.dao.search.AnyCond;
import org.apache.syncope.core.persistence.api.dao.search.AttrCond;
import org.apache.syncope.core.persistence.api.entity.AnyUtils;
import org.apache.syncope.core.persistence.api.entity.AnyUtilsFactory;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.PlainAttrValue;
import org.apache.syncope.core.persistence.api.entity.PlainSchema;
import org.apache.syncope.core.persistence.jpa.dao.AbstractJPAAnySearchDAO;
import org.apache.syncope.core.persistence.jpa.dao.OrderBySupport;
import org.apache.syncope.core.persistence.jpa.dao.SearchSupport;
import org.springframework.data.domain.Sort;

public class OracleJPAAnySearchDAO
extends AbstractJPAAnySearchDAO {
    public OracleJPAAnySearchDAO(RealmSearchDAO realmSearchDAO, DynRealmDAO dynRealmDAO, UserDAO userDAO, GroupDAO groupDAO, AnyObjectDAO anyObjectDAO, PlainSchemaDAO schemaDAO, EntityFactory entityFactory, AnyUtilsFactory anyUtilsFactory, PlainAttrValidationManager validator, EntityManagerFactory entityManagerFactory, EntityManager entityManager) {
        super(realmSearchDAO, dynRealmDAO, userDAO, groupDAO, anyObjectDAO, schemaDAO, entityFactory, anyUtilsFactory, validator, entityManagerFactory, entityManager);
    }

    @Override
    protected void processOBS(SearchSupport svs, OrderBySupport obs, StringBuilder where) {
        Set attrs = obs.items.stream().map(item -> item.orderBy.substring(0, item.orderBy.indexOf(" "))).collect(Collectors.toSet());
        obs.views.forEach(searchView -> {
            boolean searchViewAddedToWhere = false;
            if (searchView.name().equals(svs.field().name())) {
                StringBuilder attrWhere = new StringBuilder();
                StringBuilder nullAttrWhere = new StringBuilder();
                if (svs.nonMandatorySchemas || obs.nonMandatorySchemas) {
                    where.append(", (SELECT ").append("any_id,creationContext,creationDate,creator,lastChangeContext,lastChangeDate,lastModifier,status,changePwdDate,cipherAlgorithm,failedLogins,lastLoginDate,mustChangePassword,suspended,username").append(",plainSchema,ubinaryValue,ubooleanValue,udateValue,udoubleValue,ulongValue,ustringValue,binaryValue,booleanValue,dateValue,doubleValue,longValue,stringValue FROM ").append(searchView.name());
                    searchViewAddedToWhere = true;
                    attrs.forEach(field -> {
                        if (attrWhere.length() == 0) {
                            attrWhere.append(" WHERE ");
                        } else {
                            attrWhere.append(" OR ");
                        }
                        attrWhere.append("JSON_EXISTS(plainAttrs, '$[*]?(@.schema == \"").append((String)field).append("\")')");
                        nullAttrWhere.append(" UNION SELECT DISTINCT ").append("any_id,creationContext,creationDate,creator,lastChangeContext,lastChangeDate,lastModifier,status,changePwdDate,cipherAlgorithm,failedLogins,lastLoginDate,mustChangePassword,suspended,username").append(",").append("'").append((String)field).append("'").append(" AS plainSchema, ").append("null AS ubinaryValue, ").append("null AS ubooleanValue, ").append("null AS udateValue, ").append("null AS udoubleValue, ").append("null AS ulongValue, ").append("null AS ustringValue, ").append("null AS binaryValue, ").append("null AS booleanValue, ").append("null AS dateValue, ").append("null AS doubleValue, ").append("null AS longValue, ").append("null AS stringValue ").append("FROM ").append(svs.field().name()).append(" WHERE any_id NOT IN ").append("(SELECT DISTINCT any_id FROM ").append(svs.field().name()).append(" WHERE ").append("JSON_EXISTS(plainAttrs, '$[*]?(@.schema == \"").append((String)field).append("\")'))");
                    });
                    where.append((CharSequence)attrWhere).append((CharSequence)nullAttrWhere).append(')');
                }
            }
            if (!searchViewAddedToWhere) {
                where.append(',').append(searchView.name());
            }
            where.append(' ').append(searchView.alias());
        });
    }

    @Override
    protected void parseOrderByForPlainSchema(SearchSupport svs, OrderBySupport obs, OrderBySupport.Item item, Sort.Order clause, PlainSchema schema, String fieldName) {
        obs.nonMandatorySchemas = !"true".equals(schema.getMandatoryCondition());
        obs.views.add(svs.field());
        item.select = svs.field().alias() + "." + (schema.isUniqueConstraint() ? "u" : "") + OracleJPAAnySearchDAO.key((AttrSchemaType)schema.getType()) + " AS " + fieldName;
        item.where = "plainSchema = '" + fieldName + "'";
        item.orderBy = fieldName + " " + clause.getDirection().name();
    }

    protected void fillAttrQuery(AnyUtils anyUtils, StringBuilder query, PlainAttrValue attrValue, PlainSchema schema, AttrCond cond, boolean not, List<Object> parameters, SearchSupport svs) {
        if (not && schema.isMultivalue() && !(cond instanceof AnyCond) && cond.getType() != AttrCond.Type.ISNULL && cond.getType() != AttrCond.Type.ISNOTNULL) {
            query.append("id NOT IN (SELECT DISTINCT any_id FROM ");
            query.append(svs.field().name()).append(" WHERE ");
            this.fillAttrQuery(anyUtils, query, attrValue, schema, cond, false, parameters, svs);
            query.append(')');
        } else {
            String key = OracleJPAAnySearchDAO.key((AttrSchemaType)schema.getType());
            String value = Optional.ofNullable(attrValue.getDateValue()).map(DateTimeFormatter.ISO_OFFSET_DATE_TIME::format).orElseGet(() -> schema.getType() == AttrSchemaType.Boolean ? BooleanUtils.toStringTrueFalse((Boolean)attrValue.getBooleanValue()) : cond.getExpression());
            boolean lower = schema.getType().isStringClass() && (cond.getType() == AttrCond.Type.IEQ || cond.getType() == AttrCond.Type.ILIKE);
            query.append("plainSchema=?").append(OracleJPAAnySearchDAO.setParameter(parameters, cond.getSchema())).append(" AND ").append(lower ? "LOWER(" : "");
            if (schema.isUniqueConstraint()) {
                query.append("u").append(key);
            } else {
                query.append("JSON_VALUE(").append(key).append(", '$[*]')");
            }
            query.append(lower ? Character.valueOf(')') : "");
            switch (cond.getType()) {
                case LIKE: 
                case ILIKE: {
                    if (not) {
                        query.append("NOT ");
                    }
                    query.append(" LIKE ");
                    break;
                }
                case GE: {
                    if (not) {
                        query.append('<');
                        break;
                    }
                    query.append(">=");
                    break;
                }
                case GT: {
                    if (not) {
                        query.append("<=");
                        break;
                    }
                    query.append('>');
                    break;
                }
                case LE: {
                    if (not) {
                        query.append('>');
                        break;
                    }
                    query.append("<=");
                    break;
                }
                case LT: {
                    if (not) {
                        query.append(">=");
                        break;
                    }
                    query.append('<');
                    break;
                }
                default: {
                    if (not) {
                        query.append('!');
                    }
                    query.append('=');
                }
            }
            query.append(lower ? "LOWER(" : "").append('?').append(OracleJPAAnySearchDAO.setParameter(parameters, value)).append(lower ? ")" : "");
            if (cond.getType() == AttrCond.Type.ILIKE || cond.getType() == AttrCond.Type.LIKE) {
                query.append(" ESCAPE '\\' ");
            }
        }
    }

    @Override
    protected String getQuery(AttrCond cond, boolean not, List<Object> parameters, SearchSupport svs) {
        Pair checked = this.check(cond, svs.anyTypeKind);
        if (not) {
            if (cond.getType() == AttrCond.Type.ISNULL) {
                cond.setType(AttrCond.Type.ISNOTNULL);
            } else if (cond.getType() == AttrCond.Type.ISNOTNULL) {
                cond.setType(AttrCond.Type.ISNULL);
            }
        }
        StringBuilder query = new StringBuilder("SELECT DISTINCT any_id FROM ").append(svs.field().name()).append(" WHERE ");
        switch (cond.getType()) {
            case ISNOTNULL: {
                query.append("JSON_EXISTS(plainAttrs, '$[*]?(@.schema == \"").append(((PlainSchema)checked.getLeft()).getKey()).append("\")')");
                break;
            }
            case ISNULL: {
                query.append("NOT JSON_EXISTS(plainAttrs, '$[*]?(@.schema == \"").append(((PlainSchema)checked.getLeft()).getKey()).append("\")')");
                break;
            }
            default: {
                if (not && !(cond instanceof AnyCond) && ((PlainSchema)checked.getLeft()).isMultivalue()) {
                    query = new StringBuilder("SELECT DISTINCT id AS any_id FROM ").append(svs.table().name()).append(" WHERE ");
                }
                this.fillAttrQuery(this.anyUtilsFactory.getInstance(svs.anyTypeKind), query, (PlainAttrValue)checked.getRight(), (PlainSchema)checked.getLeft(), cond, not, parameters, svs);
            }
        }
        return query.toString();
    }
}

